/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.OntologyElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ExportToTextFormat {
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_IDR = 1;
    public static final int MODE_ISA = 2;
    String fName;
    String delimeter;
    int mode;
    boolean appendToFile;
    Map<String, List<String>> appendix;

    public ExportToTextFormat(String fileName, String delimeter, boolean appendToFile, int mode) {
        this.fName = fileName;
        this.delimeter = delimeter;
        this.mode = mode;
        this.appendToFile = appendToFile;
    }

    public void export(DefaultMutableTreeNode tree, boolean addPath, boolean addUnitToKey) throws IOException {
        if (tree == null) {
            return;
        }
        HashMap<String, List<TagData>> input = MDEHelper.getInput(tree);
        List<String[]> data = this.convertData(input, addPath, addUnitToKey);
        this.createFile(data);
    }

    public void exportAll(DefaultMutableTreeNode tree, boolean addPath, boolean addUnitToKey) throws IOException {
        if (tree == null) {
            return;
        }
        HashMap<String, List<TagData>> input = MDEHelper.getAllData(tree);
        List<String[]> data = this.convertData(input, addPath, addUnitToKey);
        this.createFile(data);
    }

    private List<String[]> convertData(HashMap<String, List<TagData>> input, boolean addPath, boolean addUnitToKey) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Map.Entry<String, List<TagData>> entry : input.entrySet()) {
            if (entry.getValue() == null) continue;
            for (TagData t : entry.getValue()) {
                List<String[]> refAnnot;
                if (t.getTagValue() == null || t.getTagValue().trim().isEmpty()) continue;
                Object key = entry.getKey() + " | " + t.getTagName();
                String value = t.getTagWholeValue();
                if (!addPath) {
                    key = t.getTagName();
                }
                if (addUnitToKey && t.getTagUnitString() != null && !t.getTagUnitString().isEmpty()) {
                    key = (String)key + " (" + t.getTagUnitString() + ")";
                    value = t.getTagValue();
                }
                data.add(new String[]{key, value});
                if (!t.isOntoElement() || (refAnnot = this.ontologyRef(t.getOntologyRefElem(value), t.getTagName())) == null) continue;
                data.addAll(refAnnot);
            }
        }
        return data;
    }

    private List<String[]> ontologyRef(OntologyElement ontologyRefElem, String name) {
        if (ontologyRefElem != null) {
            ArrayList<String[]> strList = new ArrayList<String[]>();
            switch (this.mode) {
                case 1: {
                    List<String> strArr;
                    strList.add(new String[]{name + " Term Source REF", ontologyRefElem.getOntologyName()});
                    strList.add(new String[]{name + " Term Accession", ontologyRefElem.getAccession()});
                    if (this.appendix == null) {
                        this.appendix = new HashMap<String, List<String>>();
                    }
                    if ((strArr = this.appendix.get("Term Source Name")) == null) {
                        strArr = new ArrayList<String>();
                    }
                    strArr.add(ontologyRefElem.getOntologyName().equals("") ? "--" : ontologyRefElem.getOntologyName());
                    this.appendix.put("Term Source Name", strArr);
                    strArr = this.appendix.get("Term Source URI");
                    if (strArr == null) {
                        strArr = new ArrayList<String>();
                    }
                    strArr.add(ontologyRefElem.getUri());
                    this.appendix.put("Term Source URI", strArr);
                    break;
                }
                default: {
                    strList.add(new String[]{name + " Ontology Ref", String.format("%s (%s)", ontologyRefElem.getAccession(), ontologyRefElem.getUri())});
                }
            }
            return strList;
        }
        return null;
    }

    private void createFile(List<String[]> data) throws IOException {
        if (data != null) {
            FileWriter writer = new FileWriter(this.fName, this.appendToFile);
            try (PrintWriter pw = new PrintWriter(writer);){
                data.stream().map(this::convertToLineString).forEach(pw::println);
                if (this.appendix != null) {
                    for (Map.Entry<String, List<String>> entry : this.appendix.entrySet()) {
                        String value = entry.getValue().stream().collect(Collectors.joining(" "));
                        pw.println(entry.getKey() + this.delimeter + value);
                    }
                }
            }
        }
    }

    private String convertToLineString(String[] data) {
        return Stream.of(data).collect(Collectors.joining(this.delimeter));
    }
}

