/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ObjectiveComponent
extends JPanel
implements PropertyChangeListener {
    private EditorModel model;
    private AcquisitionDataUI parent;
    private JLabelButton unsetObjective;
    private boolean unsetObjectiveShown;
    private Map<String, DataComponent> fieldsObjective;
    private OMEComboBox immersionBox;
    private OMEComboBox coatingBox;
    private OMEComboBox mediumBox;
    private OMEComboBox irisBox;

    private void displayUnsetObjectiveFields() {
        this.unsetObjectiveShown = !this.unsetObjectiveShown;
        String s = "Show unset fields";
        if (this.unsetObjectiveShown) {
            s = "Hide unset fields";
        }
        this.unsetObjective.setText(s);
        this.parent.layoutFields(this, this.unsetObjective, this.fieldsObjective, this.unsetObjectiveShown);
    }

    private void transformObjective(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetObjective == null) {
            this.unsetObjective = this.parent.formatUnsetFieldsControl();
            this.unsetObjective.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (key.equals("Immersion")) {
                selected = this.model.getImageEnumerationSelected(Editor.IMMERSION, (String)value);
                if (selected != null) {
                    this.immersionBox.setSelectedItem(selected);
                    if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                        set = false;
                    }
                }
                this.immersionBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.immersionBox;
            } else if (key.equals("Correction")) {
                selected = this.model.getImageEnumerationSelected(Editor.CORRECTION, (String)value);
                if (selected != null) {
                    this.coatingBox.setSelectedItem(selected);
                    if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                        set = false;
                    }
                }
                this.coatingBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.coatingBox;
            } else if (key.equals("Medium")) {
                selected = this.model.getImageEnumerationSelected(Editor.MEDIUM, (String)value);
                if (selected != null) {
                    this.mediumBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.mediumBox.setSelectedIndex(this.mediumBox.getItemCount() - 1);
                }
                this.mediumBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.mediumBox;
            } else if (key.equals("Iris")) {
                if (value != null) {
                    boolean b = (Boolean)value;
                    if (b) {
                        this.irisBox.setSelectedItem("Yes");
                    } else {
                        this.irisBox.setSelectedItem("No");
                    }
                } else {
                    set = false;
                    this.irisBox.setSelectedItem("Not Set");
                }
                this.irisBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.irisBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                Number n = (Number)value;
                Object rounded = "";
                if (value instanceof Double) {
                    rounded = "" + UIUtilities.roundTwoDecimals(n.doubleValue());
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    rounded = "" + UIUtilities.roundTwoDecimals(n.doubleValue());
                    ((NumericalTextField)area).setNumberType(Float.class);
                } else if (value instanceof Integer) {
                    rounded = "" + n.intValue();
                }
                ((NumericalTextField)area).setText((String)rounded);
                ((NumericalTextField)area).setToolTipText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            ((JComponent)area).setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsObjective.put(key, comp);
        }
    }

    private void initComponents() {
        this.unsetObjective = null;
        this.unsetObjectiveShown = false;
        this.fieldsObjective = new LinkedHashMap<String, DataComponent>();
        this.resetBoxes();
        Object[] values = new String[]{"Yes", "No", "Not Set"};
        this.irisBox = EditorUtil.createComboBox(values);
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createTitledBorder("Objective"));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
    }

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getImageEnumerations(Editor.IMMERSION);
        this.immersionBox = EditorUtil.createComboBox(l);
        l = this.model.getImageEnumerations(Editor.CORRECTION);
        this.coatingBox = EditorUtil.createComboBox(l);
        l = this.model.getImageEnumerations(Editor.MEDIUM);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.mediumBox = EditorUtil.createComboBox(array);
    }

    ObjectiveComponent(AcquisitionDataUI parent, EditorModel model) {
        this.parent = parent;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void displayObjective(Map<String, Object> details) {
        this.resetBoxes();
        this.setOpaque(true);
        this.fieldsObjective.clear();
        this.transformObjective(details);
        this.parent.layoutFields(this, this.unsetObjective, this.fieldsObjective, this.unsetObjectiveShown);
        this.parent.attachListener(this.fieldsObjective);
    }

    boolean hasDataToSave() {
        return this.parent.hasDataToSave(this.fieldsObjective);
    }

    void prepareDataToSave() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetObjectiveFields();
        }
    }
}

