/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.login;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.LoginCredentials;
import omero.gateway.model.GroupData;

public class UserCredentials
extends LoginCredentials {
    public static final int HIGH = 0;
    public static final int MEDIUM = 1;
    public static final int LOW = 2;
    private int speedLevel;
    private long group;
    private boolean encrypted;
    private Boolean administrator;
    private Boolean owner;
    private Boolean active;
    private Map<GroupData, Boolean> groupsOwner;
    private Set<String> cmdLineArgs = new HashSet<String>();
    private String escapeChars = null;

    private void checkSpeedLevel(int level) {
        switch (level) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Speed level not valid.");
    }

    public UserCredentials(String userName, String password, String hostName, int speedLevel) {
        super(userName, password, hostName);
        this.checkSpeedLevel(speedLevel);
        this.speedLevel = speedLevel;
        this.group = -1L;
        this.owner = null;
        this.administrator = null;
    }

    public UserCredentials(String userName, String password) {
        this(userName, password, "", 0);
    }

    public void setGroup(long group) {
        this.group = group;
    }

    public long getGroup() {
        return this.group;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void resetPassword(String password) {
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Please specify a password.");
        }
        super.getUser().setPassword(password);
    }

    public int getSpeedLevel() {
        return this.speedLevel;
    }

    public void setAdministrator(Boolean administrator) {
        this.administrator = administrator;
    }

    public Boolean isAdministrator() {
        return this.administrator;
    }

    public void setOwner(Boolean owner) {
        this.owner = owner;
    }

    public Boolean isOwner() {
        return this.owner;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setGroupsOwner(Map<GroupData, Boolean> map) {
        this.groupsOwner = map;
    }

    public Map<GroupData, Boolean> getGroupsOwner() {
        return this.groupsOwner;
    }

    public Boolean isGroupOwner(GroupData group) {
        if (this.groupsOwner == null) {
            return null;
        }
        return this.groupsOwner.get(group);
    }

    public GroupData getGroupToHandle() {
        if (this.groupsOwner == null || this.groupsOwner.size() == 0) {
            return null;
        }
        Set<GroupData> groups = this.groupsOwner.keySet();
        Iterator<GroupData> i = groups.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("User Name: ");
        buf.append(this.getUser().getUsername());
        buf.append(" -- Password: ");
        if (this.getUser().getPassword() != null) {
            for (int i = 0; i < this.getUser().getPassword().length(); ++i) {
                buf.append('*');
            }
        }
        return buf.toString();
    }

    public void addCmdLineArgs(Collection<String> args) {
        this.cmdLineArgs.addAll(args);
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("--omero.user=" + this.escape(this.getUser().getUsername()));
        res.add("--omero.pass=" + this.escape(this.getUser().getPassword()));
        res.add("--omero.host=" + this.getServer().getHost());
        res.add("--omero.port=" + this.getServer().getPort());
        for (String arg : this.cmdLineArgs) {
            if (arg.startsWith("--")) {
                res.add(arg);
                continue;
            }
            res.add("--" + arg);
        }
        return res;
    }

    public void setEscapeChars(String escapeChars) {
        this.escapeChars = escapeChars;
    }

    private String escape(String arg) {
        if (this.escapeChars != null && this.escapeChars.length() > 0) {
            return arg.replaceAll("([" + this.escapeChars + "])", "\\\\$1");
        }
        return arg;
    }
}

