/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.PlateData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ContainerCounterLoader
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final SecurityContext ctx, final Map<Class<?>, List<Long>> types) {
        return new BatchCall("Counting items."){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = ContainerCounterLoader.this.context.getDataService();
                Iterator i = types.entrySet().iterator();
                OmeroImageService ms = ContainerCounterLoader.this.context.getImageService();
                ExperimenterData exp = (ExperimenterData)ContainerCounterLoader.this.context.lookup("/current_user/details");
                long userID = exp.getId();
                HashMap<Long, Long> m = new HashMap<Long, Long>();
                HashMap<Class, Map> count = new HashMap<Class, Map>();
                AdminService svc = ContainerCounterLoader.this.context.getAdminService();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Class type = (Class)entry.getKey();
                    List ids = (List)entry.getValue();
                    if (PlateData.class.equals((Object)type)) {
                        for (Long id : ids) {
                            m.put(id, Long.valueOf(ms.loadROIMeasurements(ctx, type, id, userID).size()));
                        }
                        ContainerCounterLoader.this.result = m;
                        continue;
                    }
                    if (GroupData.class.equals((Object)type)) {
                        svc = ContainerCounterLoader.this.context.getAdminService();
                        ContainerCounterLoader.this.result = count.put(type, svc.countExperimenters(ctx, ids));
                        continue;
                    }
                    count.put(type, os.getCollectionCount(ctx, type, "images", ids));
                }
                if (count.size() > 0) {
                    ContainerCounterLoader.this.result = count;
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ContainerCounterLoader(SecurityContext ctx, Set<DataObject> rootIDs) {
        if (rootIDs == null) {
            throw new NullPointerException("No root nodes.");
        }
        Iterator<DataObject> i = rootIDs.iterator();
        Long id = null;
        Class rootType = null;
        List<Long> ids = new ArrayList();
        HashMap types = new HashMap();
        while (i.hasNext()) {
            DataObject root = i.next();
            if (root instanceof DatasetData) {
                rootType = DatasetData.class;
                id = ((DatasetData)root).getId();
            } else if (root instanceof TagAnnotationData) {
                rootType = TagAnnotationData.class;
                id = ((TagAnnotationData)root).getId();
            } else if (root instanceof PlateData) {
                rootType = PlateData.class;
                id = ((PlateData)root).getId();
            } else if (root instanceof GroupData) {
                rootType = GroupData.class;
                id = ((GroupData)root).getId();
            }
            if (!types.containsKey(rootType)) {
                types.put(rootType, new ArrayList());
            }
            ids = (List)types.get(rootType);
            if (id == null) continue;
            ids.add(id);
        }
        this.loadCall = this.makeBatchCall(ctx, types);
    }
}

