/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class FilesChecker
extends BatchCallTree {
    private BatchCall loadCall;
    private Object result;

    private boolean isFileSupported(File f, FileFilter[] filters) {
        String path = f.getAbsolutePath();
        if ((path = path.toLowerCase()).endsWith(".zip")) {
            return true;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].accept(f)) continue;
            return true;
        }
        return false;
    }

    private BatchCall makeCheckCall(final List<File> files) {
        return new BatchCall("Downloading files."){

            @Override
            public void doCall() {
                OmeroImageService service = FilesChecker.this.context.getImageService();
                FileFilter[] filters = service.getSupportedFileFormats();
                HashMap m = new HashMap();
                m.put(false, new ArrayList());
                m.put(true, new ArrayList());
                for (File f : files) {
                    List l = (List)m.get(FilesChecker.this.isFileSupported(f, filters));
                    l.add(f);
                }
                FilesChecker.this.result = m;
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public FilesChecker(List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("No files to check.");
        }
        this.loadCall = this.makeCheckCall(files);
    }
}

