/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneUI;

public class ClosableTabbedPane
extends JTabbedPane
implements ChangeListener,
PropertyChangeListener {
    public static final String CLOSE_TAB_PROPERTY = "closeTab";

    private void createUI() {
        ClosableTabbedPaneUI ui = new ClosableTabbedPaneUI(this);
        this.setUI(ui);
        this.addMouseMotionListener(ui);
    }

    public ClosableTabbedPane() {
        this(1, 0);
    }

    public ClosableTabbedPane(int tabPlacement) {
        this(tabPlacement, 0);
    }

    public ClosableTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.createUI();
        this.setFocusable(false);
        this.addChangeListener(this);
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addPropertyChangeListener("awt.font.desktophints", this);
    }

    void removeOthers() {
        int tabCount = this.getTabCount();
        int index = this.getSelectedIndex();
        while (tabCount-- > 0) {
            if (index == tabCount) continue;
            this.removeTabAt(tabCount);
        }
    }

    public void insertClosableComponent(ClosableTabbedPaneComponent component) {
        if (component == null) {
            return;
        }
        this.insertTab(component.getName(), component.getIcon(), component, component.getDescription(), component.getIndex());
        this.setSelectedComponent(component);
    }

    @Override
    public void removeAll() {
        this.setSelectedIndex(-1);
        int tabCount = this.getTabCount();
        while (tabCount-- > 0) {
            this.removeTabAt(tabCount);
        }
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(this.getTabCount() - 1);
        }
    }

    @Override
    public void remove(int index) {
        this.removeTabAt(index);
    }

    @Override
    public void removeTabAt(int index) {
        Component c = this.getComponentAt(index);
        if (c instanceof ClosableTabbedPaneComponent) {
            if (!((ClosableTabbedPaneComponent)c).isClosable()) {
                return;
            }
            this.firePropertyChange(CLOSE_TAB_PROPERTY, null, c);
        }
        if (this.ui instanceof ClosableTabbedPaneUI) {
            ((ClosableTabbedPaneUI)this.ui).resetDefault();
        } else {
            this.createUI();
        }
        super.removeTabAt(index);
        int n = this.getTabCount();
        if (n == 0) {
            return;
        }
        if (index > n) {
            this.setSelectedComponent(this.getComponentAt(n - 1));
        }
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        this.insertTab(title, icon, component, "", this.getTabCount());
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        int addIndex = this.indexOfComponent(component);
        if (addIndex != -1) {
            this.setSelectedComponent(component);
            return;
        }
        if (this.ui instanceof ClosableTabbedPaneUI) {
            ((ClosableTabbedPaneUI)this.ui).resetDefault();
        } else {
            this.createUI();
        }
        super.insertTab(title, icon, component, tip, this.getTabCount());
    }

    @Override
    public void setSelectedComponent(Component component) {
        super.setSelectedComponent(component);
        if (component != null) {
            component.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setOpaque(true);
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getSelectedIndex() == i) continue;
            this.setBackgroundAt(i, this.getBackground());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("awt.font.desktophints".equals(name)) {
            this.createUI();
        }
    }
}

