/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderAction;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FindNextAction
extends FinderAction {
    private static final String NAME = "Find Next";
    private static final String DESCRIPTION = "Finds the next occurrence of the phrase.";

    @Override
    protected void onTextChanged() {
        this.setEnabled(!this.model.isTextEmpty());
    }

    @Override
    protected void onLevelChanged() {
        if (!(this.model.isNameSelected() || this.model.isDescriptionSelected() || this.model.isAnnotationSelected())) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    protected void onRetrievedChanged(int n) {
        this.setEnabled(n != 0);
    }

    public FindNextAction(Finder model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(27));
        model.addPropertyChangeListener("textEntered", this);
        model.addPropertyChangeListener("level", this);
        model.addPropertyChangeListener("retrieved", this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.findNext();
    }
}

