/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import omero.gateway.model.FileAnnotationData;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class OpeningFileDialog
extends JDialog
implements ActionListener {
    public static final String SAVE_TO_DISK_PROPERTY = "saveToDisk";
    private static final String TITLE = "Opening ";
    private static final int CANCEL = 0;
    private static final int OK = 1;
    private FileAnnotationData data;
    private JButton cancelButton;
    private JButton okButton;
    private JRadioButton openButton;
    private JRadioButton saveButton;
    private IconManager icons;

    private void setProperties() {
        this.setTitle(TITLE + this.data.getFileName());
        this.setModal(true);
    }

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("1");
        this.openButton = new JRadioButton("Open");
        this.saveButton = new JRadioButton("Save to Disk");
        ButtonGroup group = new ButtonGroup();
        group.add(this.openButton);
        group.add(this.saveButton);
        this.openButton.setSelected(true);
    }

    private JPanel buildContent() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        JLabel l = UIUtilities.setTextFont("You have chosen to open");
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 0));
        row.add(new JLabel(this.icons.getIcon(12)));
        row.add(Box.createHorizontalStrut(5));
        row.add(UIUtilities.setTextFont(this.data.getFileName()));
        content.add(UIUtilities.buildComponentPanel(l));
        content.add(UIUtilities.buildComponentPanel(row));
        content.add(Box.createVerticalStrut(10));
        l = new JLabel("What should OMERO.insight do with this file?");
        content.add(UIUtilities.buildComponentPanel(l));
        content.add(this.buildSelectionPane());
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return content;
    }

    private JPanel buildSelectionPane() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.add(this.openButton);
        content.add(this.saveButton);
        JPanel p = UIUtilities.buildComponentPanel(content);
        p.setBorder(BorderFactory.createBevelBorder(1));
        return p;
    }

    private JPanel buildBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.okButton);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.add((Component)this.buildContent(), "Center");
        c.add((Component)this.buildBar(), "South");
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void downloadData() {
        this.firePropertyChange(SAVE_TO_DISK_PROPERTY, null, this.data);
        this.cancel();
    }

    OpeningFileDialog(JFrame owner, IconManager icons, FileAnnotationData data) {
        super(owner);
        if (data == null) {
            throw new IllegalArgumentException("No file to open.");
        }
        this.icons = icons;
        this.data = data;
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.downloadData();
            }
        }
    }
}

