/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionInfo;
import Ice.ConnectionLostException;
import Ice.DatagramLimitException;
import Ice.Holder;
import Ice.LocalException;
import Ice.SocketException;
import Ice.UDPConnectionInfo;
import IceInternal.BufSizeWarnInfo;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.UdpEndpointI;
import IceUtilInternal.Assert;
import IceUtilInternal.StringUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Collections;

final class UdpTransceiver
implements Transceiver {
    private UdpEndpointI _endpoint = null;
    private ProtocolInstance _instance;
    private int _state;
    private int _rcvSize;
    private int _sndSize;
    private DatagramChannel _fd;
    private InetSocketAddress _addr;
    private InetSocketAddress _mcastAddr = null;
    private String _mcastInterface;
    private InetSocketAddress _peerAddr = null;
    private boolean _incoming = false;
    private int _port = 0;
    private boolean _bound = false;
    private static final int _udpOverhead = 28;
    private static final int _maxPacketSize = 65507;
    private static final int StateNeedConnect = 0;
    private static final int StateConnected = 1;
    private static final int StateNotConnected = 2;

    @Override
    public SelectableChannel fd() {
        assert (this._fd != null);
        return this._fd;
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer, Holder<Boolean> moreData) {
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return 0;
    }

    @Override
    public void close() {
        assert (this._fd != null);
        try {
            this._fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fd = null;
    }

    @Override
    public EndpointI bind() {
        if (this._addr.getAddress().isMulticastAddress()) {
            Network.setReuseAddress(this._fd, true);
            this._mcastAddr = this._addr;
            if (System.getProperty("os.name").startsWith("Windows") || System.getProperty("java.vm.name").startsWith("OpenJDK")) {
                int protocol = this._mcastAddr.getAddress().getAddress().length == 4 ? 0 : 1;
                this._addr = Network.getAddressForServer("", this._port, protocol, this._instance.preferIPv6());
            }
            this._addr = Network.doBind(this._fd, this._addr);
            this.configureMulticast(this._mcastAddr, this._mcastInterface, -1);
            if (this._port == 0) {
                this._mcastAddr = new InetSocketAddress(this._mcastAddr.getAddress(), this._addr.getPort());
            }
        } else {
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.doBind(this._fd, this._addr);
        }
        this._bound = true;
        this._endpoint = this._endpoint.endpoint(this);
        return this._endpoint;
    }

    @Override
    public int write(Buffer buf) {
        if (!buf.b.hasRemaining()) {
            return 0;
        }
        assert (buf.b.position() == 0);
        assert (this._fd != null && this._state >= 1);
        assert (Math.min(65507, this._sndSize - 28) >= buf.size());
        int ret = 0;
        while (true) {
            try {
                if (this._state == 1) {
                    ret = this._fd.write(buf.b);
                    break;
                }
                if (this._peerAddr == null) {
                    throw new SocketException();
                }
                ret = this._fd.send(buf.b, this._peerAddr);
            }
            catch (AsynchronousCloseException ex) {
                throw new ConnectionLostException(ex);
            }
            catch (PortUnreachableException ex) {
                throw new ConnectionLostException(ex);
            }
            catch (InterruptedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                throw new SocketException(ex);
            }
            break;
        }
        if (ret == 0) {
            return 4;
        }
        assert (ret == buf.b.limit());
        buf.b.position(buf.b.limit());
        return 0;
    }

    @Override
    public int read(Buffer buf, Holder<Boolean> moreData) {
        if (!buf.b.hasRemaining()) {
            return 0;
        }
        assert (buf.b.position() == 0);
        int packetSize = Math.min(65507, this._rcvSize - 28);
        buf.resize(packetSize, true);
        buf.b.position(0);
        int ret = 0;
        while (true) {
            try {
                SocketAddress peerAddr = this._fd.receive(buf.b);
                if (peerAddr == null || buf.b.position() == 0) {
                    return 1;
                }
                this._peerAddr = (InetSocketAddress)peerAddr;
                ret = buf.b.position();
            }
            catch (AsynchronousCloseException ex) {
                throw new ConnectionLostException(ex);
            }
            catch (PortUnreachableException ex) {
                throw new ConnectionLostException(ex);
            }
            catch (InterruptedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                throw new ConnectionLostException(ex);
            }
            break;
        }
        if (this._state == 0) {
            Network.doConnect(this._fd, this._peerAddr, null);
            this._state = 1;
            if (this._instance.traceLevel() >= 1) {
                String s = "connected " + this._instance.protocol() + " socket\n" + this.toString();
                this._instance.logger().trace(this._instance.traceCategory(), s);
            }
        }
        buf.resize(ret, true);
        buf.b.position(ret);
        return 0;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        String s;
        if (this._fd == null) {
            return "<closed>";
        }
        if (this._incoming && !this._bound) {
            s = "local address = " + Network.addrToString(this._addr);
        } else if (this._state == 2) {
            DatagramSocket socket = this._fd.socket();
            s = "local address = " + Network.addrToString((InetSocketAddress)socket.getLocalSocketAddress());
            if (this._peerAddr != null) {
                s = s + "\nremote address = " + Network.addrToString(this._peerAddr);
            }
        } else {
            s = Network.fdToString(this._fd);
        }
        if (this._mcastAddr != null) {
            s = s + "\nmulticast address = " + Network.addrToString(this._mcastAddr);
        }
        return s;
    }

    @Override
    public String toDetailedString() {
        StringBuilder s = new StringBuilder(this.toString());
        ArrayList<String> intfs = Network.getHostsForEndpointExpand(this._addr.getAddress().getHostAddress(), this._instance.protocolSupport(), true);
        if (!intfs.isEmpty()) {
            s.append("\nlocal interfaces = ");
            s.append(StringUtil.joinString(intfs, ", "));
        }
        return s.toString();
    }

    @Override
    public ConnectionInfo getInfo() {
        UDPConnectionInfo info = new UDPConnectionInfo();
        if (this._fd != null) {
            DatagramSocket socket = this._fd.socket();
            info.localAddress = socket.getLocalAddress().getHostAddress();
            info.localPort = socket.getLocalPort();
            if (this._state == 2) {
                if (this._peerAddr != null) {
                    info.remoteAddress = this._peerAddr.getAddress().getHostAddress();
                    info.remotePort = this._peerAddr.getPort();
                }
            } else if (socket.getInetAddress() != null) {
                info.remoteAddress = socket.getInetAddress().getHostAddress();
                info.remotePort = socket.getPort();
            }
            if (!socket.isClosed()) {
                info.rcvSize = Network.getRecvBufferSize(this._fd);
                info.sndSize = Network.getSendBufferSize(this._fd);
            }
        }
        if (this._mcastAddr != null) {
            info.mcastAddress = this._mcastAddr.getAddress().getHostAddress();
            info.mcastPort = this._mcastAddr.getPort();
        }
        return info;
    }

    @Override
    public void checkSendSize(Buffer buf) {
        int packetSize = Math.min(65507, this._sndSize - 28);
        if (packetSize < buf.size()) {
            throw new DatagramLimitException();
        }
    }

    @Override
    public void setBufferSize(int rcvSize, int sndSize) {
        this.setBufSize(rcvSize, sndSize);
    }

    public final int effectivePort() {
        return this._addr.getPort();
    }

    UdpTransceiver(ProtocolInstance instance, InetSocketAddress addr, InetSocketAddress sourceAddr, String mcastInterface, int mcastTtl) {
        this._instance = instance;
        this._state = 0;
        this._addr = addr;
        try {
            this._fd = Network.createUdpSocket(this._addr);
            this.setBufSize(-1, -1);
            Network.setBlock(this._fd, false);
            if (this._addr.getAddress().isMulticastAddress()) {
                this.configureMulticast(null, mcastInterface, mcastTtl);
            }
            Network.doConnect(this._fd, this._addr, sourceAddr);
            this._state = 1;
        }
        catch (LocalException ex) {
            this._fd = null;
            throw ex;
        }
    }

    UdpTransceiver(UdpEndpointI endpoint, ProtocolInstance instance, String host, int port, String mcastInterface, boolean connect) {
        this._endpoint = endpoint;
        this._instance = instance;
        this._state = connect ? 0 : 2;
        this._mcastInterface = mcastInterface;
        this._incoming = true;
        this._port = port;
        try {
            this._addr = Network.getAddressForServer(host, port, instance.protocolSupport(), instance.preferIPv6());
            this._fd = Network.createUdpSocket(this._addr);
            this.setBufSize(-1, -1);
            Network.setBlock(this._fd, false);
        }
        catch (LocalException ex) {
            this._fd = null;
            throw ex;
        }
    }

    private synchronized void setBufSize(int rcvSize, int sndSize) {
        assert (this._fd != null);
        for (int i = 0; i < 2; ++i) {
            int sizeSet;
            int sizeRequested;
            int dfltSize;
            String prop;
            String direction;
            boolean isSnd;
            if (i == 0) {
                isSnd = false;
                direction = "receive";
                prop = "Ice.UDP.RcvSize";
                dfltSize = Network.getRecvBufferSize(this._fd);
                sizeRequested = rcvSize;
                this._rcvSize = dfltSize;
            } else {
                isSnd = true;
                direction = "send";
                prop = "Ice.UDP.SndSize";
                dfltSize = Network.getSendBufferSize(this._fd);
                sizeRequested = sndSize;
                this._sndSize = dfltSize;
            }
            if (sizeRequested == -1) {
                sizeRequested = this._instance.properties().getPropertyAsIntWithDefault(prop, dfltSize);
            }
            if (sizeRequested < 42) {
                this._instance.logger().warning("Invalid " + prop + " value of " + sizeRequested + " adjusted to " + dfltSize);
                sizeRequested = dfltSize;
            }
            if (sizeRequested == dfltSize) continue;
            if (i == 0) {
                Network.setRecvBufferSize(this._fd, sizeRequested);
                sizeSet = this._rcvSize = Network.getRecvBufferSize(this._fd);
            } else {
                Network.setSendBufferSize(this._fd, sizeRequested);
                sizeSet = this._sndSize = Network.getSendBufferSize(this._fd);
            }
            if (sizeSet >= sizeRequested) continue;
            BufSizeWarnInfo winfo = this._instance.getBufSizeWarn((short)3);
            if ((!isSnd || winfo.sndWarn && winfo.sndSize == sizeRequested) && (isSnd || winfo.rcvWarn && winfo.rcvSize == sizeRequested)) continue;
            this._instance.logger().warning("UDP " + direction + " buffer size: requested size of " + sizeRequested + " adjusted to " + sizeSet);
            if (isSnd) {
                this._instance.setSndBufSizeWarn((short)3, sizeRequested);
                continue;
            }
            this._instance.setRcvBufSizeWarn((short)3, sizeRequested);
        }
    }

    private void configureMulticast(InetSocketAddress group, String interfaceAddr, int ttl) {
        try {
            NetworkInterface intf = null;
            if (interfaceAddr.length() != 0 && (intf = NetworkInterface.getByName(interfaceAddr)) == null) {
                try {
                    intf = NetworkInterface.getByInetAddress(InetAddress.getByName(interfaceAddr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (group != null) {
                if (intf != null) {
                    this._fd.join(group.getAddress(), intf);
                } else {
                    boolean join = false;
                    boolean protocol = group.getAddress().getAddress().length != 4;
                    ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                    for (NetworkInterface iface : interfaces) {
                        boolean hasProtocolAddress = false;
                        ArrayList<InetAddress> addresses = Collections.list(iface.getInetAddresses());
                        for (InetAddress address : addresses) {
                            if ((address.getAddress().length != 4 || protocol) && (address.getAddress().length == 4 || !protocol)) continue;
                            hasProtocolAddress = true;
                            break;
                        }
                        if (!hasProtocolAddress) continue;
                        this._fd.join(group.getAddress(), iface);
                        join = true;
                    }
                    if (!join) {
                        throw new SocketException(new IllegalArgumentException("There are no interfaces that are configured for the group protocol.\nCannot join the multicast group."));
                    }
                }
            } else if (intf != null) {
                this._fd.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, intf);
            }
            if (ttl != -1) {
                this._fd.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)ttl);
            }
        }
        catch (Exception ex) {
            throw new SocketException(ex);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

