/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;

public class ArrayDouble
extends Array {
    protected double[] storageD;

    static ArrayDouble factory(Index index) {
        return ArrayDouble.factory(index, null);
    }

    static ArrayDouble factory(Index index, double[] storage) {
        if (index instanceof Index0D) {
            return new D0(index, storage);
        }
        if (index instanceof Index1D) {
            return new D1(index, storage);
        }
        if (index instanceof Index2D) {
            return new D2(index, storage);
        }
        if (index instanceof Index3D) {
            return new D3(index, storage);
        }
        if (index instanceof Index4D) {
            return new D4(index, storage);
        }
        if (index instanceof Index5D) {
            return new D5(index, storage);
        }
        if (index instanceof Index6D) {
            return new D6(index, storage);
        }
        if (index instanceof Index7D) {
            return new D7(index, storage);
        }
        return new ArrayDouble(index, storage);
    }

    public ArrayDouble(int[] shape) {
        super(DataType.DOUBLE, shape);
        this.storageD = new double[(int)this.indexCalc.getSize()];
    }

    @Override
    protected Array createView(Index index) {
        return ArrayDouble.factory(index, this.storageD);
    }

    ArrayDouble(Index ima, double[] data) {
        super(DataType.DOUBLE, ima);
        this.storageD = data != null ? data : new double[(int)this.indexCalc.getSize()];
    }

    @Override
    public Object getStorage() {
        return this.storageD;
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        double[] ja;
        for (double aJa : ja = (double[])javaArray) {
            iter.setDoubleNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        double[] ja = (double[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getDoubleNext();
        }
    }

    @Override
    public ByteBuffer getDataAsByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate((int)(8L * this.getSize()));
        DoubleBuffer ib = bb.asDoubleBuffer();
        ib.put((double[])this.get1DJavaArray(DataType.DOUBLE));
        return bb;
    }

    @Override
    public Class getElementType() {
        return Double.TYPE;
    }

    public double get(Index i) {
        return this.storageD[i.currentElement()];
    }

    public void set(Index i, double value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public double getDouble(Index i) {
        return this.storageD[i.currentElement()];
    }

    @Override
    public void setDouble(Index i, double value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public float getFloat(Index i) {
        return (float)this.storageD[i.currentElement()];
    }

    @Override
    public void setFloat(Index i, float value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public long getLong(Index i) {
        return (long)this.storageD[i.currentElement()];
    }

    @Override
    public void setLong(Index i, long value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public int getInt(Index i) {
        return (int)this.storageD[i.currentElement()];
    }

    @Override
    public void setInt(Index i, int value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public short getShort(Index i) {
        return (short)this.storageD[i.currentElement()];
    }

    @Override
    public void setShort(Index i, short value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public byte getByte(Index i) {
        return (byte)this.storageD[i.currentElement()];
    }

    @Override
    public void setByte(Index i, byte value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public char getChar(Index i) {
        return (char)this.storageD[i.currentElement()];
    }

    @Override
    public void setChar(Index i, char value) {
        this.storageD[i.currentElement()] = value;
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(Index i) {
        return this.storageD[i.currentElement()];
    }

    @Override
    public void setObject(Index i, Object value) {
        this.storageD[i.currentElement()] = ((Number)value).doubleValue();
    }

    @Override
    public double getDouble(int index) {
        return this.storageD[index];
    }

    @Override
    public void setDouble(int index, double value) {
        this.storageD[index] = value;
    }

    @Override
    public float getFloat(int index) {
        return (float)this.storageD[index];
    }

    @Override
    public void setFloat(int index, float value) {
        this.storageD[index] = value;
    }

    @Override
    public long getLong(int index) {
        return (long)this.storageD[index];
    }

    @Override
    public void setLong(int index, long value) {
        this.storageD[index] = value;
    }

    @Override
    public int getInt(int index) {
        return (int)this.storageD[index];
    }

    @Override
    public void setInt(int index, int value) {
        this.storageD[index] = value;
    }

    @Override
    public short getShort(int index) {
        return (short)this.storageD[index];
    }

    @Override
    public void setShort(int index, short value) {
        this.storageD[index] = value;
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.storageD[index];
    }

    @Override
    public void setByte(int index, byte value) {
        this.storageD[index] = value;
    }

    @Override
    public char getChar(int index) {
        return (char)this.storageD[index];
    }

    @Override
    public void setChar(int index, char value) {
        this.storageD[index] = value;
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(int index) {
        return this.getDouble(index);
    }

    @Override
    public void setObject(int index, Object value) {
        this.storageD[index] = ((Number)value).doubleValue();
    }

    public static class D7
    extends ArrayDouble {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, double[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storageD[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayDouble {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, double[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l, int m, int n) {
            return this.storageD[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayDouble {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, double[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l, int m) {
            return this.storageD[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayDouble {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, double[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l) {
            return this.storageD[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayDouble {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, double[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public double get(int i, int j, int k) {
            return this.storageD[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }

        public IF getIF() {
            return new IF();
        }

        static /* synthetic */ Index3D access$800(D3 x0) {
            return x0.ix;
        }

        public class IF {
            private int currElement = -1;
            private int size = (int)D3.access$800(D3.this).getSize();

            public boolean hasNext(int howMany) {
                return this.currElement < this.size - howMany;
            }

            public double getNext() {
                return D3.this.storageD[++this.currElement];
            }

            public void setNext(double val) {
                D3.this.storageD[++this.currElement] = val;
            }
        }
    }

    public static class D2
    extends ArrayDouble {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, double[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public double get(int i, int j) {
            return this.storageD[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayDouble {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, double[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public double get(int i) {
            return this.storageD[this.ix.setDirect(i)];
        }

        public void set(int i, double value) {
            this.storageD[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayDouble {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, double[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public double get() {
            return this.storageD[this.ix.currentElement()];
        }

        public void set(double value) {
            this.storageD[this.ix.currentElement()] = value;
        }
    }
}

