/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.utils;

import dev.zarr.zarrjava.utils.Utils;
import java.util.Arrays;

public class IndexingUtils {
    public static long[][] computeChunkCoords(long[] arrayShape, int[] chunkShape) {
        return IndexingUtils.computeChunkCoords(arrayShape, chunkShape, new long[arrayShape.length], Utils.toIntArray(arrayShape));
    }

    public static long[][] computeChunkCoords(int[] arrayShape, int[] chunkShape) {
        return IndexingUtils.computeChunkCoords(Utils.toLongArray(arrayShape), chunkShape);
    }

    public static long[][] computeChunkCoords(long[] arrayShape, int[] chunkShape, long[] selOffset, int[] selShape) {
        int ndim = arrayShape.length;
        long[] start = new long[ndim];
        long[] end = new long[ndim];
        int numChunks = 1;
        for (int dimIdx = 0; dimIdx < ndim; ++dimIdx) {
            int staIdx = (int)(selOffset[dimIdx] / (long)chunkShape[dimIdx]);
            int endIdx = (int)((selOffset[dimIdx] + (long)selShape[dimIdx] - 1L) / (long)chunkShape[dimIdx]);
            numChunks *= endIdx - staIdx + 1;
            start[dimIdx] = staIdx;
            end[dimIdx] = endIdx;
        }
        long[][] chunkCoords = new long[numChunks][];
        long[] currentIdx = Arrays.copyOf(start, ndim);
        for (int i = 0; i < chunkCoords.length; ++i) {
            chunkCoords[i] = Arrays.copyOf(currentIdx, ndim);
            int dimIdx = ndim - 1;
            while (dimIdx >= 0) {
                if (currentIdx[dimIdx] >= end[dimIdx]) {
                    currentIdx[dimIdx] = start[dimIdx];
                    --dimIdx;
                    continue;
                }
                int n = dimIdx;
                currentIdx[n] = currentIdx[n] + 1L;
                dimIdx = -1;
            }
        }
        return chunkCoords;
    }

    public static ChunkProjection computeProjection(long[] chunkCoords, int[] arrayShape, int[] chunkShape) {
        return IndexingUtils.computeProjection(chunkCoords, Utils.toLongArray(arrayShape), chunkShape);
    }

    public static ChunkProjection computeProjection(long[] chunkCoords, long[] arrayShape, int[] chunkShape) {
        return IndexingUtils.computeProjection(chunkCoords, arrayShape, chunkShape, new long[chunkCoords.length], Utils.toIntArray(arrayShape));
    }

    public static ChunkProjection computeProjection(long[] chunkCoords, long[] arrayShape, int[] chunkShape, long[] selOffset, int[] selShape) {
        int ndim = chunkCoords.length;
        int[] chunkOffset = new int[ndim];
        int[] outOffset = new int[ndim];
        int[] shape = new int[ndim];
        for (int dimIdx = 0; dimIdx < chunkCoords.length; ++dimIdx) {
            long dimOffset = (long)chunkShape[dimIdx] * chunkCoords[dimIdx];
            long dimLimit = Math.min(arrayShape[dimIdx], (chunkCoords[dimIdx] + 1L) * (long)chunkShape[dimIdx]);
            if (selOffset[dimIdx] < dimOffset) {
                chunkOffset[dimIdx] = 0;
                outOffset[dimIdx] = (int)(dimOffset - selOffset[dimIdx]);
            } else {
                chunkOffset[dimIdx] = (int)(selOffset[dimIdx] - dimOffset);
                outOffset[dimIdx] = 0;
            }
            shape[dimIdx] = selOffset[dimIdx] + (long)selShape[dimIdx] > dimLimit ? (int)((long)chunkShape[dimIdx] - selOffset[dimIdx] % (long)chunkShape[dimIdx]) : (int)(selOffset[dimIdx] + (long)selShape[dimIdx] - dimOffset - (long)chunkOffset[dimIdx]);
        }
        return new ChunkProjection(chunkCoords, chunkOffset, outOffset, shape);
    }

    public static long cOrderIndex(long[] chunkCoords, long[] arrayShape) {
        long index = 0L;
        long multiplier = 1L;
        for (int i = arrayShape.length - 1; i >= 0; --i) {
            index += chunkCoords[i] * multiplier;
            multiplier *= arrayShape[i];
        }
        return index;
    }

    public static long fOrderIndex(long[] chunkCoords, long[] arrayShape) {
        int index = 0;
        int multiplier = 1;
        for (int i = 0; i < arrayShape.length; ++i) {
            index = (int)((long)index + chunkCoords[i] * (long)multiplier);
            multiplier = (int)((long)multiplier * arrayShape[i]);
        }
        return index;
    }

    public static boolean isFullChunk(int[] selOffset, int[] selShape, int[] chunkShape) {
        if (selOffset.length != selShape.length) {
            throw new IllegalArgumentException("'selOffset' and 'selShape' need to have the same rank.");
        }
        if (selOffset.length != chunkShape.length) {
            throw new IllegalArgumentException("'selOffset' and 'chunkShape' need to have the same rank.");
        }
        for (int dimIdx = 0; dimIdx < selOffset.length; ++dimIdx) {
            if (selOffset[dimIdx] == 0 && selShape[dimIdx] == chunkShape[dimIdx]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSingleFullChunk(long[] selOffset, int[] selShape, int[] chunkShape) {
        if (selOffset.length != selShape.length) {
            throw new IllegalArgumentException("'selOffset' and 'selShape' need to have the same rank.");
        }
        if (selOffset.length != chunkShape.length) {
            throw new IllegalArgumentException("'selOffset' and 'chunkShape' need to have the same rank.");
        }
        for (int dimIdx = 0; dimIdx < selOffset.length; ++dimIdx) {
            if (selOffset[dimIdx] % (long)chunkShape[dimIdx] == 0L && selShape[dimIdx] == chunkShape[dimIdx]) continue;
            return false;
        }
        return true;
    }

    public static long[] computeSingleChunkCoords(long[] selOffset, int[] chunkShape) {
        if (selOffset.length != chunkShape.length) {
            throw new IllegalArgumentException("'selOffset' and 'chunkShape' need to have the same rank.");
        }
        long[] chunkCoords = new long[selOffset.length];
        for (int dimIdx = 0; dimIdx < selOffset.length; ++dimIdx) {
            chunkCoords[dimIdx] = selOffset[dimIdx] / (long)chunkShape[dimIdx];
        }
        return chunkCoords;
    }

    public static final class ChunkProjection {
        public final long[] chunkCoords;
        public final int[] chunkOffset;
        public final int[] outOffset;
        public final int[] shape;

        public ChunkProjection(long[] chunkCoords, int[] chunkOffset, int[] outOffset, int[] shape) {
            this.chunkCoords = chunkCoords;
            this.chunkOffset = chunkOffset;
            this.outOffset = outOffset;
            this.shape = shape;
        }
    }
}

