/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.carlspring.cloud.storage.s3fs.S3ClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class OmeroAmazonS3ClientFactory
extends S3ClientFactory {
    private static final Logger log = LoggerFactory.getLogger(OmeroAmazonS3ClientFactory.class);
    private static final Map<String, S3Client> bucketClientMap = new HashMap<String, S3Client>();

    protected AwsCredentialsProvider getCredentialsProvider(Properties props) {
        if (System.getenv("AWS_ACCESS_KEY_ID") != null || System.getenv("AWS_SECRET_ACCESS_KEY") != null || System.getenv("AWS_SESSION_TOKEN") != null || System.getProperty("aws.accessKeyId") != null || System.getProperty("aws.secretAccessKey") != null) {
            throw new RuntimeException("AWS credentials supplied by environment variables or Java system properties are not supported. Please use either named profiles or instance profile credentials.");
        }
        boolean anonymous = Boolean.parseBoolean((String)props.get("s3fs_anonymous"));
        if (anonymous) {
            log.debug("Using anonymous credentials");
            return AnonymousCredentialsProvider.create();
        }
        String profileName = (String)props.get("s3fs_credential_profile_name");
        ProfileCredentialsProvider.Builder profileBuilder = ProfileCredentialsProvider.builder();
        if (profileName != null) {
            profileBuilder.profileName(profileName);
        }
        return AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{profileBuilder.build(), InstanceProfileCredentialsProvider.create()});
    }

    private String getBucketFromUri(URI uri) {
        String path = uri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.substring(0, path.indexOf("/"));
    }

    private Region getRegionFromUri(URI uri) {
        Optional region = AwsHostNameUtils.parseSigningRegion((String)uri.getHost(), null);
        if (region.isPresent()) {
            return (Region)region.get();
        }
        return Region.US_EAST_1;
    }

    public String getEndPointFromUri(URI uri) {
        return "https://" + uri.getHost();
    }

    public synchronized S3Client getS3Client(URI uri, Properties props) {
        String bucket = this.getBucketFromUri(uri);
        if (bucketClientMap.containsKey(bucket)) {
            log.info("Found bucket " + bucket);
            return bucketClientMap.get(bucket);
        }
        log.info("Creating client for bucket " + bucket);
        ClientOverrideConfiguration cconf = this.getOverrideConfiguration(props);
        S3Client client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.getCredentialsProvider(props))).region(this.getRegionFromUri(uri))).endpointOverride(URI.create(this.getEndPointFromUri(uri)))).overrideConfiguration(cconf)).build();
        bucketClientMap.put(bucket, client);
        return client;
    }
}

