/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr;

import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.upplication.s3fs.S3Path;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.perf4j.slf4j.Slf4JStopWatch;

public class OmeroS3ReadOnlySeekableByteChannel
implements SeekableByteChannel {
    private Set<? extends OpenOption> options;
    private final long length;
    byte[] data;
    private final ReadableByteChannel rbc;
    private long position = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OmeroS3ReadOnlySeekableByteChannel(S3Path path, Set<? extends OpenOption> options) throws IOException {
        this.options = Collections.unmodifiableSet(new HashSet<OpenOption>(options));
        if (this.options.contains(StandardOpenOption.WRITE) || this.options.contains(StandardOpenOption.CREATE) || this.options.contains(StandardOpenOption.CREATE_NEW) || this.options.contains(StandardOpenOption.APPEND)) {
            throw new ReadOnlyFileSystemException();
        }
        String bucketName = path.getFileStore().name();
        String key = path.getKey();
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        Slf4JStopWatch t0 = new Slf4JStopWatch("OmeroS3ReadOnlySeekableByteChannel.getObject", "s3://" + bucketName + "/" + key);
        try {
            S3Object s3Object = path.getFileSystem().getClient().getObject(getObjectRequest);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (S3ObjectInputStream s3Stream = s3Object.getObjectContent();){
                byte[] readBuf = new byte[0x100000];
                int readLen = 0;
                while ((readLen = s3Stream.read(readBuf)) > 0) {
                    outputStream.write(readBuf, 0, readLen);
                }
            }
            this.data = outputStream.toByteArray();
        }
        finally {
            t0.stop();
        }
        this.length = this.data.length;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.data);
        this.rbc = Channels.newChannel(inputStream);
        this.position = 0L;
    }

    @Override
    public boolean isOpen() {
        return this.rbc.isOpen();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long targetPosition) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.rbc.read(dst);
        if (n > 0) {
            this.position += (long)n;
        }
        return n;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public long size() throws IOException {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }
}

