/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v2;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.codec.CodecPipeline;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v2.ArrayMetadata;
import dev.zarr.zarrjava.v2.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v2.codec.Codec;
import dev.zarr.zarrjava.v2.codec.CodecRegistry;
import dev.zarr.zarrjava.v2.codec.core.BytesCodec;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Array
implements dev.zarr.zarrjava.core.Array {
    static final String ZARRAY = ".zarray";
    public ArrayMetadata metadata;
    public StoreHandle storeHandle;
    CodecPipeline codecPipeline;

    protected Array(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        Codec[] codecArray;
        this.storeHandle = storeHandle;
        this.metadata = arrayMetadata;
        Codec[] codecArray2 = new Codec[]{};
        Codec[][] codecArrayArray = new Codec[3][];
        codecArrayArray[0] = this.metadata.filters == null ? new Codec[]{} : this.metadata.filters;
        codecArrayArray[1] = new Codec[]{new BytesCodec(arrayMetadata.endianness.toEndian())};
        if (this.metadata.compressor == null) {
            codecArray = new Codec[]{};
        } else {
            Codec[] codecArray3 = new Codec[1];
            codecArray = codecArray3;
            codecArray3[0] = this.metadata.compressor;
        }
        codecArrayArray[2] = codecArray;
        this.codecPipeline = new CodecPipeline(Utils.concatArrays(codecArray2, codecArrayArray), this.metadata.coreArrayMetadata);
    }

    public static Array open(StoreHandle storeHandle) throws IOException, ZarrException {
        return new Array(storeHandle, (ArrayMetadata)Array.makeObjectMapper().readValue(Utils.toArray(storeHandle.resolve(ZARRAY).readNonNull()), ArrayMetadata.class));
    }

    public static ObjectMapper makeObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerSubtypes(CodecRegistry.getNamedTypes());
        return objectMapper;
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadata, false);
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata, boolean existsOk) throws IOException, ZarrException {
        StoreHandle metadataHandle = storeHandle.resolve(ZARRAY);
        if (!existsOk && metadataHandle.exists()) {
            throw new RuntimeException("Trying to create a new array in " + storeHandle + ". But " + metadataHandle + " already exists.");
        }
        ObjectMapper objectMapper = Array.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)arrayMetadata));
        metadataHandle.set(metadataBytes);
        return new Array(storeHandle, arrayMetadata);
    }

    public static Array create(StoreHandle storeHandle, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper, boolean existsOk) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadataBuilderMapper.apply(new ArrayMetadataBuilder()).build(), existsOk);
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder() {
        return new ArrayMetadataBuilder();
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder(ArrayMetadata existingMetadata) {
        return ArrayMetadataBuilder.fromArrayMetadata(existingMetadata);
    }

    public String toString() {
        return String.format("<v2.Array {%s} (%s) %s>", this.storeHandle, Arrays.stream(this.metadata.shape).mapToObj(Long::toString).collect(Collectors.joining(", ")), this.metadata.dataType);
    }

    @Override
    public ArrayMetadata metadata() {
        return this.metadata;
    }

    @Override
    public StoreHandle storeHandle() {
        return this.storeHandle;
    }

    @Override
    public CodecPipeline codecPipeline() {
        return this.codecPipeline;
    }
}

