/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.Array;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v3.GroupMetadata;
import dev.zarr.zarrjava.v3.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Group
extends Node {
    public GroupMetadata metadata;

    Group(@Nonnull StoreHandle storeHandle, @Nonnull GroupMetadata groupMetadata) throws IOException {
        super(storeHandle);
        this.metadata = groupMetadata;
    }

    public static Group open(@Nonnull StoreHandle storeHandle) throws IOException {
        StoreHandle metadataHandle = storeHandle.resolve("zarr.json");
        ByteBuffer metadataBytes = metadataHandle.readNonNull();
        return new Group(storeHandle, (GroupMetadata)Node.makeObjectMapper().readValue(Utils.toArray(metadataBytes), GroupMetadata.class));
    }

    public static Group create(@Nonnull StoreHandle storeHandle, @Nonnull GroupMetadata groupMetadata) throws IOException {
        ObjectMapper objectMapper = Node.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)groupMetadata));
        storeHandle.resolve("zarr.json").set(metadataBytes);
        return new Group(storeHandle, groupMetadata);
    }

    public static Group create(@Nonnull StoreHandle storeHandle, @Nonnull Map<String, Object> attributes) throws IOException, ZarrException {
        return new Group(storeHandle, new GroupMetadata(attributes));
    }

    public static Group create(@Nonnull StoreHandle storeHandle) throws IOException, ZarrException {
        return Group.create(storeHandle, GroupMetadata.defaultValue());
    }

    @Nullable
    public Node get(String key) throws ZarrException {
        StoreHandle keyHandle = this.storeHandle.resolve(key);
        ObjectMapper objectMapper = Node.makeObjectMapper();
        ByteBuffer metadataBytes = keyHandle.resolve("zarr.json").read();
        if (metadataBytes == null) {
            return null;
        }
        byte[] metadataBytearray = Utils.toArray(metadataBytes);
        try {
            String nodeType;
            switch (nodeType = objectMapper.readTree(metadataBytearray).get("node_type").asText()) {
                case "array": {
                    return new Array(keyHandle, (ArrayMetadata)objectMapper.readValue(metadataBytearray, ArrayMetadata.class));
                }
                case "group": {
                    return new Group(keyHandle, (GroupMetadata)objectMapper.readValue(metadataBytearray, GroupMetadata.class));
                }
            }
            throw new ZarrException("Unsupported node_type '" + nodeType + "' in " + keyHandle);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Group createGroup(String key, GroupMetadata groupMetadata) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key), groupMetadata);
    }

    public Group createGroup(String key, Map<String, Object> attributes) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key), new GroupMetadata(attributes));
    }

    public Group createGroup(String key) throws IOException, ZarrException {
        return Group.create(this.storeHandle.resolve(key), GroupMetadata.defaultValue());
    }

    public Array createArray(String key, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(this.storeHandle.resolve(key), arrayMetadata);
    }

    public Array createArray(String key, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper) throws IOException, ZarrException {
        return Array.create(this.storeHandle.resolve(key), arrayMetadataBuilderMapper, false);
    }

    public Stream<Node> list() {
        return this.storeHandle.list().map(key -> {
            try {
                return this.get((String)key);
            }
            catch (ZarrException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull);
    }

    public Node[] listAsArray() {
        try (Stream<Node> nodeStream = this.list();){
            Node[] nodeArray = (Node[])nodeStream.toArray(Node[]::new);
            return nodeArray;
        }
    }

    private Group writeMetadata(GroupMetadata newGroupMetadata) throws IOException {
        ObjectMapper objectMapper = Node.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)newGroupMetadata));
        this.storeHandle.resolve("zarr.json").set(metadataBytes);
        return new Group(this.storeHandle, newGroupMetadata);
    }

    public Group setAttributes(Map<String, Object> newAttributes) throws ZarrException, IOException {
        GroupMetadata newGroupMetadata = new GroupMetadata(newAttributes);
        return this.writeMetadata(newGroupMetadata);
    }

    public Group updateAttributes(Function<Map<String, Object>, Map<String, Object>> attributeMapper) throws ZarrException, IOException {
        return this.setAttributes(attributeMapper.apply(this.metadata.attributes));
    }

    public String toString() {
        return String.format("<v3.Group {%s}>", this.storeHandle);
    }
}

