/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.glencoesoftware.omero.zarr.ZarrPixelBuffer;
import com.glencoesoftware.omero.zarr.compat.ZArray;
import com.glencoesoftware.omero.zarr.compat.ZarrInfo;
import com.glencoesoftware.omero.zarr.compat.ZarrPath;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import ome.api.IQuery;
import ome.conditions.LockTimeout;
import ome.io.nio.BackOff;
import ome.io.nio.FilePathResolver;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.io.nio.TileSizes;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.meta.ExternalInfo;
import ome.model.roi.Mask;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZarrPixelsService
extends PixelsService {
    private static final Logger log = LoggerFactory.getLogger(ZarrPixelsService.class);
    public static final String NGFF_ENTITY_TYPE = "com.glencoesoftware.ngff:multiscales";
    public static final long NGFF_ENTITY_ID = 3L;
    protected final Integer maxPlaneWidth;
    protected final Integer maxPlaneHeight;
    private final long zarrCacheSize;
    private final IQuery iQuery;
    private final AsyncLoadingCache<ZarrPath, Map<String, Object>> zarrMetadataCache;
    private final AsyncLoadingCache<ZarrPath, ZArray> zarrArrayCache;

    public ZarrPixelsService(String path, boolean isReadOnlyRepo, File memoizerDirectory, long memoizerWait, FilePathResolver resolver, BackOff backOff, TileSizes sizes, IQuery iQuery, long zarrCacheSize, int maxPlaneWidth, int maxPlaneHeight) {
        super(path, isReadOnlyRepo, memoizerDirectory, memoizerWait, resolver, backOff, sizes, iQuery);
        this.zarrCacheSize = zarrCacheSize;
        log.info("Zarr metadata and array cache size: {}", (Object)zarrCacheSize);
        this.maxPlaneWidth = maxPlaneWidth;
        this.maxPlaneHeight = maxPlaneHeight;
        this.iQuery = iQuery;
        this.zarrMetadataCache = Caffeine.newBuilder().maximumSize(this.zarrCacheSize).buildAsync(ZarrPixelsService::getZarrMetadata);
        this.zarrArrayCache = Caffeine.newBuilder().maximumSize(this.zarrCacheSize).buildAsync(ZarrPixelsService::getZarrArray);
    }

    public static Map<String, Object> getZarrMetadata(ZarrPath path) throws IOException {
        return path.getMetadata();
    }

    public static ZArray getZarrArray(ZarrPath path) throws IOException {
        return path.getArray();
    }

    public String getUri(IObject object) {
        return this.getUri(object, NGFF_ENTITY_TYPE, 3L);
    }

    public String getUri(IObject object, String targetEntityType, Long targetEntityId) {
        ExternalInfo externalInfo = object.getDetails().getExternalInfo();
        if (externalInfo == null) {
            log.debug("{}:{} missing ExternalInfo", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        String entityType = externalInfo.getEntityType();
        if (entityType == null) {
            log.debug("{}:{} missing ExternalInfo entityType", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        if (!entityType.equals(targetEntityType)) {
            log.debug("{}:{} unsupported ExternalInfo entityType {}", new Object[]{object.getClass().getSimpleName(), object.getId(), entityType});
            return null;
        }
        Long entityId = externalInfo.getEntityId();
        if (entityType == null) {
            log.debug("{}:{} missing ExternalInfo entityId", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        if (!entityId.equals(targetEntityId)) {
            log.debug("{}:{} unsupported ExternalInfo entityId {}", new Object[]{object.getClass().getSimpleName(), object.getId(), entityId});
            return null;
        }
        String uri = externalInfo.getLsid();
        if (uri == null) {
            log.debug("{}:{} missing LSID", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        return uri;
    }

    protected Image getImage(Pixels pixels) {
        if (pixels.getImage().isLoaded()) {
            return pixels.getImage();
        }
        return (Image)this.iQuery.get(Image.class, pixels.getImage().getId().longValue());
    }

    protected int getSeries(Pixels pixels) {
        if (pixels.getImage().isLoaded()) {
            return pixels.getImage().getSeries();
        }
        return super.getSeries(pixels);
    }

    public ZarrPixelBuffer getLabelImagePixelBuffer(Mask mask) throws IOException {
        Pixels pixels = new Pixels();
        pixels.setSizeX(Integer.valueOf(mask.getWidth().intValue()));
        pixels.setSizeY(Integer.valueOf(mask.getHeight().intValue()));
        pixels.setSizeC(Integer.valueOf(1));
        pixels.setSizeT(Integer.valueOf(1));
        pixels.setSizeZ(Integer.valueOf(1));
        String root = this.getUri((IObject)mask);
        if (root == null) {
            throw new IllegalArgumentException("No root for Mask:" + mask.getId());
        }
        ZarrInfo zarrInfo = new ZarrInfo(root);
        ZarrPath zarrPath = zarrInfo.getZarrPath();
        return new ZarrPixelBuffer(pixels, zarrPath, this.maxPlaneWidth, this.maxPlaneHeight, this.zarrMetadataCache, this.zarrArrayCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZarrPixelBuffer createOmeNgffPixelBuffer(Pixels pixels) {
        block11: {
            Slf4JStopWatch t0 = new Slf4JStopWatch("createOmeNgffPixelBuffer()");
            try {
                Image image = this.getImage(pixels);
                String uri = this.getUri((IObject)image);
                if (uri == null) {
                    if (image.getFormat() != null && "OMEXML".equals(image.getFormat().getValue())) {
                        throw new LockTimeout("Import in progress.", 15000L, 0);
                    }
                    log.debug("No OME-NGFF root");
                    ZarrPixelBuffer zarrPixelBuffer = null;
                    return zarrPixelBuffer;
                }
                ZarrInfo zarrInfo = new ZarrInfo(uri);
                log.info("OME-NGFF root is: " + zarrInfo);
                try {
                    ZarrPixelBuffer v = new ZarrPixelBuffer(pixels, zarrInfo.getZarrPath(), this.maxPlaneWidth, this.maxPlaneHeight, this.zarrMetadataCache, this.zarrArrayCache);
                    log.info("Using OME-NGFF pixel buffer");
                    ZarrPixelBuffer zarrPixelBuffer = v;
                    return zarrPixelBuffer;
                }
                catch (Exception e) {
                    try {
                        log.warn("Getting OME-NGFF pixel buffer failed - attempting to get local data", (Throwable)e);
                    }
                    catch (Exception e1) {
                        log.debug("Failed to find OME-NGFF metadata for Pixels:{}", (Object)pixels.getId());
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    t0.stop();
                }
            }
            finally {
                t0.stop();
            }
        }
        return null;
    }

    public PixelBuffer getPixelBuffer(Pixels pixels, boolean write) {
        ZarrPixelBuffer pixelBuffer = this.createOmeNgffPixelBuffer(pixels);
        if (pixelBuffer != null) {
            return pixelBuffer;
        }
        return this._getPixelBuffer(pixels, write);
    }
}

