/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;

public class HISReader
extends FormatReader {
    public static final String HIS_MAGIC_STRING = "IM";
    private long[] pixelOffset;

    public HISReader() {
        super("Hamamatsu HIS", "his");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)2, (boolean)false)) {
            return false;
        }
        return stream.readString(2).indexOf(HIS_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(this.pixelOffset[this.getSeries()]);
        if (this.getBitsPerPixel() % 8 == 0) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            int bits = this.getBitsPerPixel();
            int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
            this.in.skipBits((long)(y * this.getSizeX() * this.getSizeC() * bits));
            for (int row = 0; row < h; ++row) {
                int rowOffset = row * w * this.getSizeC() * bpp;
                this.in.skipBits((long)(x * this.getSizeC() * bits));
                for (int col = 0; col < w; ++col) {
                    int colOffset = col * this.getSizeC() * bpp;
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        int sample = this.in.readBits(bits);
                        DataTools.unpackBytes((long)sample, (byte[])buf, (int)(rowOffset + colOffset + c * bpp), (int)bpp, (boolean)this.isLittleEndian());
                    }
                }
                this.in.skipBits((long)(this.getSizeC() * bits * (this.getSizeX() - w - x)));
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.in.skipBytes(14);
        int nSeries = this.in.readShort();
        this.pixelOffset = new long[nSeries];
        String[] date = new String[nSeries];
        String[] binning = new String[nSeries];
        double[] offset = new double[nSeries];
        double[] exposureTime = new double[nSeries];
        boolean adjustedBitDepth = false;
        this.in.seek(0L);
        this.core.clear();
        for (int i = 0; i < nSeries; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            String checkString = this.in.readString(2);
            if (!checkString.equals(HIS_MAGIC_STRING) && i > 0 && this.getBitsPerPixel() == 12) {
                ((CoreMetadata)this.core.get((int)(i - 1))).bitsPerPixel = 16;
                long prevSkip = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * 12L / 8L;
                long totalBytes = FormatTools.getPlaneSize((IFormatReader)this);
                this.in.skipBytes(totalBytes - prevSkip);
                adjustedBitDepth = true;
            }
            this.setSeries(i);
            short commentBytes = this.in.readShort();
            ms.sizeX = this.in.readShort();
            ms.sizeY = this.in.readShort();
            this.in.skipBytes(4);
            short dataType = this.in.readShort();
            switch (dataType) {
                case 1: {
                    ms.pixelType = 1;
                    break;
                }
                case 2: {
                    ms.pixelType = 3;
                    break;
                }
                case 6: {
                    ms.pixelType = 3;
                    ms.bitsPerPixel = adjustedBitDepth ? 16 : 12;
                    break;
                }
                case 11: {
                    ms.pixelType = 1;
                    ms.sizeC = 3;
                    break;
                }
                case 12: {
                    ms.pixelType = 3;
                    ms.sizeC = 3;
                    break;
                }
                case 14: {
                    ms.pixelType = 3;
                    ms.sizeC = 3;
                    ms.bitsPerPixel = adjustedBitDepth ? 16 : 12;
                }
            }
            this.in.skipBytes(50);
            String comment = this.in.readString((int)commentBytes);
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                String[] data;
                for (String token : data = comment.split(";")) {
                    int eq = token.indexOf(61);
                    if (eq == -1) continue;
                    String key = token.substring(0, eq);
                    String value = token.substring(eq + 1);
                    this.addSeriesMeta(key, value);
                    if (key.equals("vDate")) {
                        date[i] = value;
                        continue;
                    }
                    if (key.equals("vTime")) {
                        int n = i;
                        date[n] = date[n] + " " + value;
                        date[i] = DateTools.formatDate((String)date[i], (String)"yyyy/MM/dd HH:mm:ss");
                        continue;
                    }
                    if (key.equals("vOffset")) {
                        offset[i] = Double.parseDouble(value);
                        continue;
                    }
                    if (key.equals("vBinX")) {
                        binning[i] = value;
                        continue;
                    }
                    if (key.equals("vBinY")) {
                        int n = i;
                        binning[n] = binning[n] + "x" + value;
                        continue;
                    }
                    if (!key.equals("vExpTim1")) continue;
                    exposureTime[i] = Double.parseDouble(value) * 100.0;
                }
            }
            this.pixelOffset[i] = this.in.getFilePointer();
            ms.littleEndian = true;
            if (ms.sizeC == 0) {
                ms.sizeC = 1;
            }
            ms.sizeT = 1;
            ms.sizeZ = 1;
            ms.imageCount = 1;
            ms.rgb = ms.sizeC > 1;
            ms.interleaved = this.isRGB();
            ms.dimensionOrder = "XYCZT";
            this.in.skipBytes(this.getSizeX() * this.getSizeY() * this.getSizeC() * this.getBitsPerPixel() / 8);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrumentID, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < nSeries; ++i) {
                store.setImageInstrumentRef(instrumentID, i);
                if (date[i] != null) {
                    store.setImageAcquisitionDate(new Timestamp(date[i]), i);
                }
                store.setPlaneExposureTime(new Time((Number)exposureTime[i], UNITS.SECOND), i, 0);
                String detectorID = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, i});
                store.setDetectorID(detectorID, 0, i);
                store.setDetectorOffset(Double.valueOf(offset[i]), 0, i);
                store.setDetectorType(MetadataTools.getDetectorType((String)"Other"), 0, i);
                store.setDetectorSettingsID(detectorID, i, 0);
                store.setDetectorSettingsBinning(MetadataTools.getBinning((String)binning[i]), i, 0);
            }
        }
    }
}

