/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileFilterUtil {
    public static void sortFileArrayByName(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String o1Name = o1.getName();
                String o2Name = o2.getName();
                return o1Name.compareTo(o2Name);
            }
        });
    }

    public static void reverseSortFileArrayByName(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String o1Name = o1.getName();
                String o2Name = o2.getName();
                return o2Name.compareTo(o1Name);
            }
        });
    }

    public static String afterLastSlash(String sregex) {
        int i = sregex.lastIndexOf(47);
        if (i == -1) {
            return sregex;
        }
        return sregex.substring(i + 1);
    }

    public static boolean isEmptyDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("[" + dir + "] must be a directory");
        }
        String[] filesInDir = dir.list();
        return filesInDir == null || filesInDir.length == 0;
    }

    public static File[] filesInFolderMatchingStemRegex(File file2, String stemRegex) {
        if (file2 == null) {
            return new File[0];
        }
        if (!file2.exists() || !file2.isDirectory()) {
            return new File[0];
        }
        Pattern pattern = Pattern.compile(stemRegex);
        return file2.listFiles((dir, name) -> pattern.matcher(name).matches());
    }

    public static int findHighestCounter(File[] matchingFileArray, String stemRegex) {
        int max = Integer.MIN_VALUE;
        for (File aFile : matchingFileArray) {
            int aCounter = FileFilterUtil.extractCounter(aFile, stemRegex);
            if (max >= aCounter) continue;
            max = aCounter;
        }
        return max;
    }

    public static int extractCounter(File file2, String stemRegex) {
        String lastFileName;
        Pattern p = Pattern.compile(stemRegex);
        Matcher m4 = p.matcher(lastFileName = file2.getName());
        if (!m4.matches()) {
            throw new IllegalStateException("The regex [" + stemRegex + "] should match [" + lastFileName + "]");
        }
        String counterAsStr = m4.group(1);
        return Integer.parseInt(counterAsStr);
    }

    public static String slashify(String in) {
        return in.replace('\\', '/');
    }

    public static void removeEmptyParentDirectories(File file2, int recursivityCount) {
        if (recursivityCount >= 3) {
            return;
        }
        File parent = file2.getParentFile();
        if (parent.isDirectory() && FileFilterUtil.isEmptyDirectory(parent)) {
            parent.delete();
            FileFilterUtil.removeEmptyParentDirectories(parent, recursivityCount + 1);
        }
    }
}

