/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class InveonReader
extends FormatReader {
    private static final String HEADER = "Header file for data file";
    private String datFile;
    private ArrayList<Long> dataPointers = new ArrayList();

    public InveonReader() {
        super("Inveon", new String[]{"hdr"});
        this.domains = new String[]{"Medical Imaging"};
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .hdr file plus one similarly-named file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (InveonReader.checkSuffix(name, "hdr")) {
            return super.isThisType(name, open);
        }
        Location file2 = new Location(name + ".hdr");
        if (!file2.exists()) {
            return false;
        }
        return super.isThisType(file2.getAbsolutePath(), open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 128;
        if (!FormatTools.validStream(stream, 128, false)) {
            return false;
        }
        return stream.readString(128).indexOf(HEADER) >= 0;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.datFile};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        long planeSize = FormatTools.getPlaneSize(this);
        int index = this.getCoreIndex();
        try (RandomAccessInputStream dat = new RandomAccessInputStream(this.datFile);){
            dat.order(this.isLittleEndian());
            dat.seek(this.dataPointers.get(index) + (long)no * planeSize);
            this.readPlane(dat, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.datFile = null;
            this.dataPointers.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!InveonReader.checkSuffix(id, "hdr")) {
            id = id + ".hdr";
        }
        super.initFile(id);
        String headerData = DataTools.readFile(id);
        String[] lines = headerData.split("\n");
        String date = null;
        String institution = null;
        String investigator = null;
        String model = null;
        String description = null;
        Double pixelSizeX = null;
        Double pixelSizeY = null;
        Double pixelSizeZ = null;
        int frames = 0;
        for (String line : lines) {
            Double size;
            int space;
            if ((line = line.trim()).startsWith("#") || (space = line.indexOf(32)) < 0) continue;
            String key = line.substring(0, space);
            String value = line.substring(space + 1);
            if (key.equals("institution")) {
                institution = value;
            } else if (key.equals("investigator")) {
                investigator = value;
            } else if (key.equals("study")) {
                description = value;
            } else if (key.equals("model")) {
                model = value = this.transformModel(value);
            } else if (key.equals("modality")) {
                value = this.transformModality(value);
            } else if (key.equals("modality_configuration")) {
                value = this.transformModalityConfiguration(value);
            } else if (key.equals("file_type")) {
                value = this.transformFileType(value);
            } else if (key.equals("acquisition_mode")) {
                value = this.transformAcquisitionMode(value);
            } else if (key.equals("bed_control")) {
                value = this.transformBedControl(value);
            } else if (key.equals("bed_motion")) {
                value = this.transformBedMotion(value);
            } else if (key.equals("registration_available")) {
                value = this.transformRegistrationAvailable(value);
            } else if (key.equals("normalization_applied")) {
                value = this.transformNormalizationApplied(value);
            } else if (key.equals("recon_algorithm")) {
                value = this.transformReconAlgorithm(value);
            } else if (key.equals("x_filter")) {
                value = this.transformFilter(value);
            } else if (key.equals("y_filter")) {
                value = this.transformFilter(value);
            } else if (key.equals("z_filter")) {
                value = this.transformFilter(value);
            } else if (key.equals("subject_orientation")) {
                value = this.transformSubjectOrientation(value);
            } else if (key.equals("subject_length_units")) {
                value = this.transformSubjectLengthUnits(value);
            } else if (key.equals("subject_weight_units")) {
                value = this.transformSubjectWeightUnits(value);
            } else if (key.equals("gantry_rotation")) {
                value = this.transformGantryRotation(value);
            } else if (key.equals("rotation_direction")) {
                value = this.transformRotationDirection(value);
            } else if (key.equals("ct_warping")) {
                value = this.transformCTWarping(value);
            } else if (key.equals("ct_projection_interpolation")) {
                value = this.transformCTProjectionInterpolation(value);
            } else if (key.equals("event_type")) {
                value = this.transformEventType(value);
            } else if (key.equals("projection") || key.equals("ct_projection_center_offset") || key.equals("ct_projection_horizontal_bed_offset")) {
                space = value.indexOf(32);
                int index = Integer.parseInt(value.substring(0, space));
                value = value.substring(space + 1);
                key = key + " " + index;
            } else if (key.equals("user")) {
                space = value.indexOf(32);
                key = value.substring(0, space);
                value = value.substring(space + 1);
            } else if (key.equals("file_name")) {
                value = value.replace('/', File.separatorChar);
                value = value.replace('\\', File.separatorChar);
                value = value.substring(value.lastIndexOf(File.separator) + 1);
                Location header = new Location(this.currentId).getAbsoluteFile();
                Location dat = new Location(header.getParent(), value);
                if (dat.exists()) {
                    this.datFile = dat.getAbsolutePath();
                } else {
                    Object[] allFiles = header.getParentFile().list(true);
                    Arrays.sort(allFiles);
                    String headerName = header.getName();
                    for (Object file2 : allFiles) {
                        if (headerName.equals(file2) || !headerName.startsWith((String)file2)) continue;
                        this.datFile = new Location(header.getParent(), (String)file2).getAbsolutePath();
                    }
                }
            } else if (key.equals("time_frames")) {
                int sizeT = Integer.parseInt(value);
                for (int i = 0; i < this.core.size(); ++i) {
                    ((CoreMetadata)this.core.get((int)i)).sizeT = sizeT;
                }
            } else if (key.equals("total_frames")) {
                frames = Integer.parseInt(value);
            } else if (key.equals("number_of_bed_positions")) {
                int nPos = Math.min(frames, Integer.parseInt(value));
                if (nPos > 1) {
                    CoreMetadata original = (CoreMetadata)this.core.get(0);
                    this.core.clear();
                    for (int i = 0; i < nPos; ++i) {
                        this.core.add(original);
                    }
                }
            } else if (key.equals("data_type")) {
                this.setDataType(value);
            } else if (key.equals("x_dimension")) {
                int sizeX = Integer.parseInt(value);
                for (int i = 0; i < this.core.size(); ++i) {
                    ((CoreMetadata)this.core.get((int)i)).sizeX = sizeX;
                }
            } else if (key.equals("y_dimension")) {
                int sizeY = Integer.parseInt(value);
                for (int i = 0; i < this.core.size(); ++i) {
                    ((CoreMetadata)this.core.get((int)i)).sizeY = sizeY;
                }
            } else if (key.equals("z_dimension")) {
                int sizeZ = Integer.parseInt(value);
                for (int i = 0; i < this.core.size(); ++i) {
                    ((CoreMetadata)this.core.get((int)i)).sizeZ = sizeZ;
                }
            } else if (key.equals("scan_time")) {
                date = value;
            } else if (key.equals("data_file_pointer")) {
                String[] values = value.split(" ");
                int[] ints = new int[values.length];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = Integer.parseInt(values[i]);
                }
                byte[] b = DataTools.intsToBytes(ints, false);
                this.dataPointers.add(DataTools.bytesToLong(b, false));
            } else if (key.equals("pixel_size_x")) {
                Double size2 = DataTools.parseDouble(value);
                if (size2 != null) {
                    pixelSizeX = size2 * 1000.0;
                }
            } else if (key.equals("pixel_size_y")) {
                Double size3 = DataTools.parseDouble(value);
                if (size3 != null) {
                    pixelSizeY = size3 * 1000.0;
                }
            } else if (key.equals("pixel_size_z") && (size = DataTools.parseDouble(value)) != null) {
                pixelSizeZ = size * 1000.0;
            }
            this.addGlobalMeta(key, value);
        }
        for (int i = 0; i < this.core.size(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            if (ms.sizeZ == 0) {
                ms.sizeZ = 1;
            }
            if (ms.sizeT == 0) {
                ms.sizeT = 1;
            }
            ms.sizeC = 1;
            ms.rgb = false;
            ms.interleaved = false;
            ms.indexed = false;
            ms.dimensionOrder = "XYZCT";
            ms.imageCount = ms.sizeZ * ms.sizeC * ms.sizeT;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String experimenter = null;
        String instrument = null;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            experimenter = MetadataTools.createLSID("Experimenter", 0);
            store.setExperimenterID(experimenter, 0);
            store.setExperimenterUserName(investigator, 0);
            store.setExperimenterInstitution(institution, 0);
            instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setMicroscopeModel(model, 0);
        }
        for (int i = 0; i < this.core.size(); ++i) {
            String newDate;
            if (date != null && (newDate = DateTools.formatDate(date, "EEE MMM dd HH:mm:ss yyyy")) != null) {
                store.setImageAcquisitionDate(new Timestamp(newDate), i);
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            if (experimenter != null) {
                store.setImageExperimenterRef(experimenter, i);
            }
            if (instrument != null) {
                store.setImageInstrumentRef(instrument, i);
            }
            store.setImageDescription(description, i);
            Length sizeX = FormatTools.getPhysicalSizeX(pixelSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(pixelSizeY);
            Length sizeZ = FormatTools.getPhysicalSizeZ(pixelSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, i);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, i);
            }
            if (sizeZ == null) continue;
            store.setPixelsPhysicalSizeZ(sizeZ, i);
        }
    }

    private String transformModel(String value) {
        int model = Integer.parseInt(value);
        switch (model) {
            case 2000: {
                return "Primate";
            }
            case 2001: {
                return "Rodent";
            }
            case 2002: {
                return "microPET2";
            }
            case 2500: {
                return "Focus_220";
            }
            case 2501: {
                return "Focus_120";
            }
            case 3000: {
                return "mCAT";
            }
            case 3500: {
                return "mCATII";
            }
            case 4000: {
                return "mSPECT";
            }
            case 5000: {
                return "Inveon_Dedicated_PET";
            }
            case 5001: {
                return "Inveon_MM_Platform";
            }
            case 6000: {
                return "MR_PET_Head_Insert";
            }
            case 8000: {
                return "Tuebingen_PET_MR";
            }
        }
        return "Unknown";
    }

    private String transformModality(String value) {
        int modality = Integer.parseInt(value);
        switch (modality) {
            case 0: {
                return "PET acquisition";
            }
            case 1: {
                return "CT acquisition";
            }
            case 2: {
                return "SPECT acquisition";
            }
        }
        return "Unknown";
    }

    private String transformModalityConfiguration(String value) {
        int modalityConfiguration = Integer.parseInt(value);
        switch (modalityConfiguration) {
            case 3000: {
                return "mCAT";
            }
            case 3500: {
                return "mCATII";
            }
            case 3600: {
                return "Inveon_MM_Std_CT";
            }
            case 3601: {
                return "Inveon_MM_HiRes_Std_CT";
            }
            case 3602: {
                return "Inveon_MM_Std_LFOV_CT";
            }
            case 3603: {
                return "Inveon_MM_HiRes_LFOV_CT";
            }
        }
        return "Unknown";
    }

    private String transformFileType(String value) {
        int type = Integer.parseInt(value);
        switch (type) {
            case 1: {
                return "List mode";
            }
            case 2: {
                return "Sinogram";
            }
            case 3: {
                return "Normalization";
            }
            case 4: {
                return "Attenuation correction";
            }
            case 5: {
                return "Image data";
            }
            case 6: {
                return "Blank data";
            }
            case 8: {
                return "Mu map";
            }
            case 9: {
                return "Scatter correction";
            }
            case 10: {
                return "Crystal efficiency";
            }
            case 11: {
                return "Crystal interference correction";
            }
            case 12: {
                return "Transaxial geometric correction";
            }
            case 13: {
                return "Axial geometric correction";
            }
            case 14: {
                return "CT projection";
            }
            case 15: {
                return "SPECT raw projection";
            }
            case 16: {
                return "SPECT energy data from projections";
            }
            case 17: {
                return "SPECT normalization";
            }
        }
        return "Unknown";
    }

    private String transformAcquisitionMode(String value) {
        int mode = Integer.parseInt(value);
        switch (mode) {
            case 1: {
                return "Blank";
            }
            case 2: {
                return "Emission";
            }
            case 3: {
                return "Dynamic";
            }
            case 4: {
                return "Gated";
            }
            case 5: {
                return "Continuous bed motion";
            }
            case 6: {
                return "Singles transmission";
            }
            case 7: {
                return "Windowed coincidence transmission";
            }
            case 8: {
                return "Non-windowed coincidence transmission";
            }
            case 9: {
                return "CT projection";
            }
            case 10: {
                return "CT calibration";
            }
            case 11: {
                return "SPECT planar projection";
            }
            case 12: {
                return "SPECT multi-projection";
            }
            case 13: {
                return "SPECT calibration";
            }
            case 14: {
                return "SPECT normalization";
            }
            case 15: {
                return "SPECT detector setup";
            }
            case 16: {
                return "SPECT scout view";
            }
        }
        return "Unknown";
    }

    private String transformBedControl(String value) {
        int control = Integer.parseInt(value);
        switch (control) {
            case 1: {
                return "Dedicated PET";
            }
            case 2: {
                return "microCAT II";
            }
            case 3: {
                return "Multimodality bed control";
            }
            case 4: {
                return "microPET bed control";
            }
        }
        return "Unknown";
    }

    private String transformBedMotion(String value) {
        int motion = Integer.parseInt(value);
        switch (motion) {
            case 1: {
                return "Continuous";
            }
            case 2: {
                return "Multiple bed positions";
            }
        }
        return "Unknown";
    }

    private String transformRegistrationAvailable(String value) {
        int available = Integer.parseInt(value);
        switch (available) {
            case 1: {
                return "CT";
            }
            case 2: {
                return "PET";
            }
        }
        return "None";
    }

    private String transformNormalizationApplied(String value) {
        int normalization = Integer.parseInt(value);
        switch (normalization) {
            case 1: {
                return "Point source inversion";
            }
            case 2: {
                return "Point source component based";
            }
            case 3: {
                return "Cylinder source inversion";
            }
            case 4: {
                return "Cylinder source component based";
            }
            case 5: {
                return "Dark/bright field log normalization (CT)";
            }
            case 6: {
                return "SPECT flood inversion based";
            }
        }
        return "None";
    }

    private String transformReconAlgorithm(String value) {
        int algorithm = Integer.parseInt(value);
        switch (algorithm) {
            case 1: {
                return "Filtered Backprojection";
            }
            case 2: {
                return "OSEM2d";
            }
            case 3: {
                return "OSEM3d";
            }
            case 6: {
                return "OSEM3D followed by MAP or FastMAP";
            }
            case 7: {
                return "MAPTR for transmission image";
            }
            case 8: {
                return "MAP 3D reconstruction";
            }
            case 9: {
                return "Feldkamp cone beam";
            }
        }
        return "Unknown";
    }

    private String transformFilter(String value) {
        int space = value.indexOf(32);
        int filter = Integer.parseInt(value.substring(0, space));
        String cutoff = " (cutoff = " + value.substring(space + 1) + ")";
        String filterType = "Unknown";
        switch (filter) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Ramp filter (backprojection)";
            }
            case 2: {
                return "First-order Butterworth window";
            }
            case 3: {
                return "Hanning window";
            }
            case 4: {
                return "Hamming window";
            }
            case 5: {
                return "Parzen window";
            }
            case 6: {
                return "Shepp filter";
            }
            case 7: {
                return "Second-order Butterworth window";
            }
        }
        return filterType + cutoff;
    }

    private String transformSubjectOrientation(String value) {
        int orientation = Integer.parseInt(value);
        switch (orientation) {
            case 1: {
                return "Feet first, prone";
            }
            case 2: {
                return "Head first, prone";
            }
            case 3: {
                return "Feet first, supine";
            }
            case 4: {
                return "Head first, supine";
            }
            case 5: {
                return "Feet first, right";
            }
            case 6: {
                return "Head first, right";
            }
            case 7: {
                return "Feet first, left";
            }
            case 8: {
                return "Head first, left";
            }
        }
        return "Unknown";
    }

    private String transformSubjectLengthUnits(String value) {
        int units = Integer.parseInt(value);
        switch (units) {
            case 1: {
                return "millimeters";
            }
            case 2: {
                return "centimeters";
            }
            case 3: {
                return "inches";
            }
        }
        return "Unknown";
    }

    private String transformSubjectWeightUnits(String value) {
        int units = Integer.parseInt(value);
        switch (units) {
            case 1: {
                return "grams";
            }
            case 2: {
                return "ounces";
            }
            case 3: {
                return "kilograms";
            }
            case 4: {
                return "pounds";
            }
        }
        return "Unknown";
    }

    private String transformGantryRotation(String value) {
        int rotation = Integer.parseInt(value);
        switch (rotation) {
            case 0: {
                return "No gantry rotation";
            }
            case 1: {
                return "Rotation with discrete steps";
            }
            case 2: {
                return "Continuous rotation";
            }
        }
        return "Unknown";
    }

    private String transformRotationDirection(String value) {
        return value.equals("0") ? "Clockwise" : "Counterclockwise";
    }

    private String transformCTWarping(String value) {
        int warping = Integer.parseInt(value);
        switch (warping) {
            case 1: {
                return "None";
            }
            case 2: {
                return "Bilinear";
            }
            case 3: {
                return "Nearest neighbor";
            }
        }
        return "Unknown";
    }

    private String transformCTProjectionInterpolation(String value) {
        int interpolation = Integer.parseInt(value);
        switch (interpolation) {
            case 1: {
                return "Bilinear";
            }
            case 2: {
                return "Nearest neighbor";
            }
        }
        return "Unknown";
    }

    private String transformEventType(String value) {
        int type = Integer.parseInt(value);
        switch (type) {
            case 1: {
                return "Singles";
            }
            case 2: {
                return "Prompt events (coincidences)";
            }
            case 3: {
                return "Delay events";
            }
            case 4: {
                return "Trues (prompts - delays)";
            }
            case 5: {
                return "Energy spectrum data";
            }
        }
        return "Unknown";
    }

    private void setDataType(String value) {
        int type = Integer.parseInt(value);
        int pixelType = 0;
        boolean littleEndian = true;
        switch (type) {
            case 2: {
                pixelType = 2;
                break;
            }
            case 3: {
                pixelType = 4;
                break;
            }
            case 4: {
                pixelType = 6;
                break;
            }
            case 5: {
                pixelType = 6;
                littleEndian = false;
                break;
            }
            case 6: {
                pixelType = 2;
                littleEndian = false;
                break;
            }
            case 7: {
                pixelType = 4;
                littleEndian = false;
            }
        }
        for (int i = 0; i < this.core.size(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.pixelType = pixelType;
            ms.littleEndian = littleEndian;
        }
    }
}

