/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import ucar.httpservices.HTTPMethod;

@ThreadSafe
abstract class HTTPConnections {
    public static boolean TRACE = false;
    static int DFALTMAXCONNS = 20;
    protected boolean closed = false;
    protected boolean pooling = false;
    protected int maxconnections = DFALTMAXCONNS;
    protected int actualconnections = 0;
    protected Registry<ConnectionSocketFactory> protocolregistry = null;
    protected Map<String, ConnectionSocketFactory> protocols = new HashMap<String, ConnectionSocketFactory>();

    public static int setDefaultMaxConections(int n) {
        int old = DFALTMAXCONNS;
        if (n > 0) {
            DFALTMAXCONNS = n;
        }
        return old;
    }

    protected HTTPConnections(boolean pooling) {
        this.pooling = pooling;
        this.addProtocol("http", PlainConnectionSocketFactory.getSocketFactory());
    }

    public void addProtocol(String proto, ConnectionSocketFactory factory) {
        this.protocols.put(proto, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConnections(int n) {
        if (n > 0) {
            HTTPConnections hTTPConnections = this;
            synchronized (hTTPConnections) {
                this.maxconnections = n;
            }
        }
    }

    public void setClientManager(HttpClientBuilder cb, HTTPMethod method) {
        HttpClientConnectionManager mgr = this.newManager(method);
        cb.setConnectionManager(mgr);
    }

    protected Registry<ConnectionSocketFactory> getRegistry() {
        if (this.protocolregistry == null) {
            RegistryBuilder rb = RegistryBuilder.create();
            for (Map.Entry<String, ConnectionSocketFactory> entry : this.protocols.entrySet()) {
                rb.register(entry.getKey(), (Object)entry.getValue());
            }
            this.protocolregistry = rb.build();
        }
        return this.protocolregistry;
    }

    void validate() {
        assert (this.actualconnections == 0);
    }

    int getActualConnections() {
        return this.actualconnections;
    }

    public abstract HttpClientConnectionManager newManager(HTTPMethod var1);

    public abstract void freeManager(HTTPMethod var1);

    public abstract void close();
}

