/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import java.util.ArrayList;
import loci.tests.testng.ConfigurationTree;
import loci.tests.testng.FormatWriterTest;
import loci.tests.testng.TestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Factory;

public class FormatWriterTestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatWriterTestFactory.class);

    @Factory
    public Object[] createInstances() {
        ArrayList<String> files = new ArrayList<String>();
        String nameProp = "testng.filename";
        String filename = System.getProperty("testng.filename");
        if (filename != null && filename.equals("${testng.filename}")) {
            filename = null;
        }
        if (filename != null && !new File(filename).exists()) {
            LOGGER.error("Invalid filename: {}", (Object)filename);
            return new Object[0];
        }
        String baseDir = null;
        if (filename == null) {
            String baseDirProp = "testng.directory";
            baseDir = System.getProperty("testng.directory");
            if (!new File(baseDir).isDirectory()) {
                if (baseDir == null || baseDir.equals("${testng.directory}")) {
                    LOGGER.error("No base directory specified.");
                } else {
                    LOGGER.error("Invalid base directory: {}", (Object)baseDir);
                }
                LOGGER.error("Please specify a directory containing files to test:");
                LOGGER.error("   ant -D{}=\"/path/to/data\" test-all", (Object)"testng.directory");
                return new Object[0];
            }
            FormatWriterTest.configTree = new ConfigurationTree(baseDir);
            LOGGER.info("testng.directory = {}", (Object)baseDir);
        }
        String multProp = "testng.multiplier";
        String mult = System.getProperty("testng.multiplier");
        float multiplier = 1.0f;
        if (mult != null && !mult.equals("${testng.multiplier}")) {
            try {
                multiplier = Float.parseFloat(mult);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Invalid multiplier: {}", (Object)mult);
            }
        }
        LOGGER.info("testng.multiplier = {}", (Object)Float.valueOf(multiplier));
        String toplevelConfigProp = "testng.toplevel-config";
        String toplevelConfig = System.getProperty("testng.toplevel-config");
        long maxMemory = Runtime.getRuntime().maxMemory() >> 20;
        LOGGER.info("Maximum heap size = {} MB", (Object)maxMemory);
        LOGGER.info("user.language = {}", (Object)System.getProperty("user.language"));
        LOGGER.info("user.country = {}", (Object)System.getProperty("user.country"));
        if (filename == null) {
            System.out.println("Scanning for files...");
            long start = System.currentTimeMillis();
            TestTools.getFiles(baseDir, files, FormatWriterTest.configTree, toplevelConfig);
            long end = System.currentTimeMillis();
            double time = (double)(end - start) / 1000.0;
            LOGGER.info("----------------------------------------");
            LOGGER.info("Total files: {}", (Object)files.size());
            long avg = end - start;
            if (files.size() > 0) {
                avg /= (long)files.size();
            }
            LOGGER.info("Scan time: {} s ({} ms/file)", (Object)time, (Object)avg);
            LOGGER.info("----------------------------------------");
        } else {
            files.add(filename);
        }
        System.out.println("Building list of tests...");
        Object[] tests = new Object[files.size()];
        for (int i = 0; i < tests.length; ++i) {
            String id = (String)files.get(i);
            tests[i] = new FormatWriterTest(id);
        }
        if (tests.length == 1) {
            System.out.println("Ready to test " + files.get(0));
        } else {
            System.out.println("Ready to test " + tests.length + " files");
        }
        return tests;
    }
}

