/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;

public class SimpleTiledWriter {
    private ImageReader reader;
    private OMETiffWriter writer;
    private String inputFile;
    private String outputFile;
    private int tileSizeX;
    private int tileSizeY;

    public SimpleTiledWriter(String inputFile, String outputFile, int tileSizeX, int tileSizeY) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.tileSizeX = tileSizeX;
        this.tileSizeY = tileSizeY;
    }

    private void initialize() throws DependencyException, FormatException, IOException, ServiceException {
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata omexml = service.createOMEXMLMetadata();
        this.reader = new ImageReader();
        this.reader.setMetadataStore((MetadataStore)omexml);
        this.reader.setId(this.inputFile);
        this.writer = new OMETiffWriter();
        this.writer.setMetadataRetrieve((MetadataRetrieve)omexml);
        this.writer.setInterleaved(this.reader.isInterleaved());
        this.tileSizeX = this.writer.setTileSizeX(this.tileSizeX);
        this.tileSizeY = this.writer.setTileSizeY(this.tileSizeY);
        this.writer.setId(this.outputFile);
    }

    public void readWriteTiles() throws FormatException, DependencyException, ServiceException, IOException {
        byte[] buf = new byte[FormatTools.getPlaneSize((IFormatReader)this.reader)];
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            this.reader.setSeries(series);
            this.writer.setSeries(series);
            for (int image = 0; image < this.reader.getImageCount(); ++image) {
                buf = this.reader.openBytes(image);
                this.writer.saveBytes(image, buf);
            }
        }
    }

    private void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close reader.");
            e.printStackTrace();
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close writer.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws FormatException, IOException, DependencyException, ServiceException {
        int tileSizeX = Integer.parseInt(args[2]);
        int tileSizeY = Integer.parseInt(args[3]);
        SimpleTiledWriter tiledWriter = new SimpleTiledWriter(args[0], args[1], tileSizeX, tileSizeY);
        tiledWriter.initialize();
        try {
            tiledWriter.readWriteTiles();
        }
        catch (Exception e) {
            System.err.println("Failed to read and write tiles.");
            e.printStackTrace();
            throw e;
        }
        finally {
            tiledWriter.cleanup();
        }
    }
}

