/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.util.ArrayList;
import loci.formats.AxisGuesser;
import loci.formats.FilePattern;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AxisGuesserTest {
    @DataProvider(name="booleanStates")
    public Object[][] createBooleans() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider(name="prefixCases")
    public Object[][] createPrefixCases() {
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        String template = "%s_<0-1>%s_<2-3>%s_<4-5>%s_<6-7>";
        for (String z : AxisGuesser.Z_PREFIXES) {
            for (String t : AxisGuesser.T_PREFIXES) {
                for (String c : AxisGuesser.C_PREFIXES) {
                    for (String s : AxisGuesser.S_PREFIXES) {
                        cases.add(new Object[]{String.format(template, z, t, c, s)});
                        cases.add(new Object[]{String.format(template, z.toUpperCase(), t.toUpperCase(), c.toUpperCase(), s.toUpperCase())});
                    }
                }
            }
        }
        return (Object[][])cases.toArray((T[])new Object[cases.size()][]);
    }

    @DataProvider(name="bioRadCases")
    public Object[][] createBioRadCases() {
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        String template = "_<%s>%s";
        for (String suffix : new String[]{".pic", ".PIC"}) {
            for (String block : new String[]{"1,2", "2,3", "1,3", "1,2,3"}) {
                cases.add(new Object[]{String.format(template, block, suffix)});
            }
        }
        return (Object[][])cases.toArray((T[])new Object[cases.size()][]);
    }

    @DataProvider(name="RGBCases")
    public Object[][] createRGBCases() {
        String[] blocks;
        ArrayList<Object[]> cases = new ArrayList<Object[]>();
        String template = "_<%s>";
        for (String b : blocks = new String[]{"r,g,b", "r,b,g", "g,r,b", "g,b,r", "b,r,g", "b,g,r", "r,g", "g,r"}) {
            cases.add(new Object[]{String.format(template, b)});
            cases.add(new Object[]{String.format(template, b.toUpperCase())});
        }
        return (Object[][])cases.toArray((T[])new Object[cases.size()][]);
    }

    @DataProvider(name="swapCases")
    public Object[][] createSwapCases() {
        return new Object[][]{{"z<0-1>_<0-1>", 2, 1, true, new int[]{1, 2}}, {"z<0-1>_<0-1>", 2, 1, false, new int[]{1, 3}}, {"_<0-1>t<0-1>", 1, 2, true, new int[]{1, 2}}, {"_<0-1>t<0-1>", 1, 2, false, new int[]{3, 2}}};
    }

    @DataProvider(name="fillInCases")
    public Object[][] createFillInCases() {
        return new Object[][]{{"z<0-1>t<0-1>_<0-1>", "XYZCT", 1, 1, 1, new int[]{1, 2, 3}}, {"z<0-1>t<0-1>_<0-1>", "XYZCT", 1, 1, 2, new int[]{1, 2, 2}}, {"z<0-1>c<0-1>_<0-1>", "XYZTC", 1, 1, 1, new int[]{1, 3, 2}}, {"z<0-1>c<0-1>_<0-1>", "XYZTC", 1, 2, 1, new int[]{1, 3, 3}}, {"t<0-1>c<0-1>_<0-1>", "XYTZC", 1, 1, 1, new int[]{2, 3, 1}}, {"t<0-1>c<0-1>_<0-1>", "XYTZC", 2, 1, 1, new int[]{2, 3, 3}}};
    }

    private void check(String p, String order, int sZ, int sT, int sC, boolean cert, String newOrder, int[] types) {
        FilePattern fp = new FilePattern(p);
        AxisGuesser ag = new AxisGuesser(fp, order, sZ, sT, sC, cert);
        Assert.assertEquals((String)ag.getFilePattern().getPattern(), (String)p);
        Assert.assertEquals((String)ag.getOriginalOrder(), (String)order);
        Assert.assertEquals((String)ag.getAdjustedOrder(), (String)newOrder);
        Assert.assertEquals((Object)ag.getAxisTypes(), (Object)types);
        this.checkAxisCount(ag, types);
    }

    private String mkPrefix(String baseTag, Boolean upperCase) {
        if (upperCase.booleanValue()) {
            baseTag = baseTag.toUpperCase();
        }
        return String.format("_%s", baseTag);
    }

    private void checkAxisCount(AxisGuesser ag, int[] axisTypes) {
        int countZ = 0;
        int countT = 0;
        int countC = 0;
        int countS = 0;
        block6: for (int t : axisTypes) {
            switch (t) {
                case 1: {
                    ++countZ;
                    continue block6;
                }
                case 2: {
                    ++countT;
                    continue block6;
                }
                case 3: {
                    ++countC;
                    continue block6;
                }
                case 4: {
                    ++countS;
                }
            }
        }
        Assert.assertEquals((int)ag.getAxisCount(1), (int)countZ);
        Assert.assertEquals((int)ag.getAxisCountZ(), (int)countZ);
        Assert.assertEquals((int)ag.getAxisCount(2), (int)countT);
        Assert.assertEquals((int)ag.getAxisCountT(), (int)countT);
        Assert.assertEquals((int)ag.getAxisCount(3), (int)countC);
        Assert.assertEquals((int)ag.getAxisCountC(), (int)countC);
        Assert.assertEquals((int)ag.getAxisCount(4), (int)countS);
        Assert.assertEquals((int)ag.getAxisCountS(), (int)countS);
        Assert.assertEquals((int)ag.getAxisCount(0), (int)0);
    }

    @Test(dataProvider="prefixCases")
    public void testPrefix(String pattern) {
        this.check(pattern, "XYZCT", 1, 1, 1, true, "XYZCT", new int[]{1, 2, 3, 4});
    }

    @Test(dataProvider="bioRadCases")
    public void testBioRad(String pattern) {
        this.check(pattern, "XYZCT", 1, 1, 1, true, "XYZCT", new int[]{3});
    }

    @Test(dataProvider="RGBCases")
    public void testRGB(String pattern) {
        this.check(pattern, "XYZCT", 1, 1, 1, true, "XYZCT", new int[]{3});
    }

    @Test(dataProvider="swapCases")
    public void testSwap(String pattern, int sZ, int sT, boolean isCertain, int[] types) {
        String order = "XYZCT";
        String newOrder = isCertain ? order : "XYTCZ";
        this.check(pattern, order, sZ, sT, 1, isCertain, newOrder, types);
    }

    @Test(dataProvider="fillInCases")
    public void testFillIn(String pattern, String order, int sZ, int sT, int sC, int[] types) {
        this.check(pattern, order, sZ, sT, sC, true, order, types);
    }

    @Test(dataProvider="booleanStates")
    public void testGetAxisType(Boolean upperCase) {
        for (String s : AxisGuesser.Z_PREFIXES) {
            Assert.assertEquals((int)AxisGuesser.getAxisType((String)this.mkPrefix(s, upperCase)), (int)1);
        }
        for (String s : AxisGuesser.T_PREFIXES) {
            Assert.assertEquals((int)AxisGuesser.getAxisType((String)this.mkPrefix(s, upperCase)), (int)2);
        }
        for (String s : AxisGuesser.C_PREFIXES) {
            Assert.assertEquals((int)AxisGuesser.getAxisType((String)this.mkPrefix(s, upperCase)), (int)3);
        }
        for (String s : AxisGuesser.S_PREFIXES) {
            Assert.assertEquals((int)AxisGuesser.getAxisType((String)this.mkPrefix(s, upperCase)), (int)4);
        }
    }
}

