/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.services.ServiceFactory;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.in.ICSReader;
import loci.formats.in.OMETiffReader;
import loci.formats.in.TiffDelegateReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.TiffParser;
import loci.formats.tools.ImageConverter;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ImageConverterTest {
    private Path tempDir;
    private File outFile;
    private int width = 512;
    private int resolutionCount;
    private final PrintStream oldOut = System.out;
    private final PrintStream oldErr = System.err;

    @BeforeMethod
    public void setUp() throws IOException {
        this.tempDir = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
        this.tempDir.toFile().deleteOnExit();
        this.width = 512;
        this.resolutionCount = 1;
    }

    @AfterClass
    public void tearDown() {
        System.setOut(this.oldOut);
        System.setErr(this.oldErr);
    }

    @DataProvider(name="suffixes")
    public Object[][] createSuffixes() {
        return new Object[][]{{".ome.tiff"}, {".tif"}, {".ics"}};
    }

    @DataProvider(name="options")
    public Object[][] createOptions() {
        return new Object[][]{{"-z 2"}, {"-series 0 -z 2"}, {"-channel 1"}, {"-series 0 -channel 1"}, {"-series 0 -timepoint 3"}, {"-timepoint 3"}, {"-series 1"}, {"-series 1 -channel 1"}, {"-series 1 -timepoint 3"}, {"-series 1 -channel 1 -timepoint 3"}};
    }

    public void checkImage(String outFileToCheck, int expectedWidth) throws FormatException, IOException {
        ClassList readerClasses = new ClassList(IFormatReader.class);
        readerClasses.addClass(OMETiffReader.class);
        readerClasses.addClass(ICSReader.class);
        readerClasses.addClass(TiffDelegateReader.class);
        ImageReader r = new ImageReader(readerClasses);
        r.setFlattenedResolutions(false);
        r.setId(outFileToCheck);
        Assert.assertEquals((int)r.getSizeX(), (int)expectedWidth);
        Assert.assertEquals((int)r.getResolutionCount(), (int)this.resolutionCount);
        r.close();
    }

    public void checkImage(String outFileToCheck, int expectedWidth, int expectedTileWidth) throws FormatException, IOException {
        ClassList readerClasses = new ClassList(IFormatReader.class);
        readerClasses.addClass(TiffReader.class);
        readerClasses.addClass(OMETiffReader.class);
        ImageReader r = new ImageReader(readerClasses);
        r.setFlattenedResolutions(false);
        r.setId(outFileToCheck);
        Assert.assertEquals((int)r.getOptimalTileWidth(), (int)expectedTileWidth);
        Assert.assertEquals((int)r.getOptimalTileHeight(), (int)expectedTileWidth);
        r.close();
    }

    public void checkImage() throws FormatException, IOException {
        this.checkImage(this.outFile.getAbsolutePath(), this.width);
    }

    public void assertConversion(String[] args) throws FormatException, IOException {
        this.assertConversion(args, this.outFile.getAbsolutePath(), this.width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertConversion(String[] args, String outFileToCheck, int expectedWidth, int expectedTileWidth) throws FormatException, IOException {
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            this.outFile.deleteOnExit();
            Assert.assertTrue((boolean)success);
            this.checkImage(outFileToCheck, expectedWidth, expectedTileWidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertConversion(String[] args, String outFileToCheck, int expectedWidth) throws FormatException, IOException {
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            this.outFile.deleteOnExit();
            Assert.assertTrue((boolean)success);
            this.checkImage(outFileToCheck, expectedWidth);
        }
    }

    public void testConstructor() throws FormatException, IOException {
        this.outFile = this.getOutFile("test.ome.tiff");
        ImageConverter converter = new ImageConverter();
        boolean status = converter.testConvert((IFormatWriter)new ImageWriter(), new String[]{"test.fake", this.outFile.getAbsolutePath()});
        Assert.assertEquals((Object)status, (Object)0);
        this.checkImage();
    }

    @Test(dataProvider="suffixes")
    public void testDefault(String suffix) throws FormatException, IOException {
        this.outFile = this.getOutFile("test" + suffix);
        String[] args = new String[]{"test.fake", this.outFile.getAbsolutePath()};
        this.assertConversion(args);
    }

    @Test(dataProvider="options")
    public void testOptions(String options) throws FormatException, IOException {
        this.outFile = this.getOutFile("test.ome.tiff");
        String[] optionsArgs = options.split(" ");
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("test&sizeZ=3&sizeC=2&sizeT=4&series=2.fake");
        argsList.addAll(Arrays.asList(optionsArgs));
        argsList.add(this.outFile.getAbsolutePath());
        String[] args = new String[argsList.size()];
        this.assertConversion(argsList.toArray(args));
    }

    @Test(dataProvider="suffixes")
    public void testOverwrite(String suffix) throws FormatException, IOException {
        this.outFile = Files.createTempFile(this.tempDir, "test", suffix, new FileAttribute[0]).toFile();
        String[] args = new String[]{"-overwrite", "test.fake", this.outFile.getAbsolutePath()};
        this.assertConversion(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadArgument() throws FormatException, IOException {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        this.outFile = this.getOutFile("test.ome.tiff");
        String[] args = new String[]{"-foo", "test.fake", this.outFile.getAbsolutePath()};
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            Assert.assertFalse((boolean)success);
            Assert.assertTrue((boolean)outContent.toString().endsWith("Found unknown command flag: -foo; exiting." + System.getProperty("line.separator")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompanion() throws FormatException, IOException {
        Path tempSubdir = this.getTempSubdir();
        this.outFile = tempSubdir.resolve("test.ome.tiff").toFile();
        File compFile = tempSubdir.resolve("test.companion.ome").toFile();
        String[] args = new String[]{"-option", "ometiff.companion", compFile.getAbsolutePath(), "test.fake", this.outFile.getAbsolutePath()};
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            this.outFile.deleteOnExit();
            compFile.deleteOnExit();
            Assert.assertTrue((boolean)success);
            Assert.assertTrue((boolean)compFile.exists());
            this.checkImage();
        }
    }

    @Test
    public void testSPWSeries() throws FormatException, IOException {
        this.outFile = this.getOutFile("plate.ome.tiff");
        String[] args = new String[]{"-series", "0", "plate&plates=1&fields=2.fake", this.outFile.getAbsolutePath()};
        this.assertConversion(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCrop() throws FormatException, IOException {
        this.outFile = this.getOutFile("test.ome.tiff");
        String[] args = new String[]{"-tilex", "128", "-tiley", "128", "-crop", "256,256,256,256", "test.fake", this.outFile.getAbsolutePath()};
        this.width = 256;
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            this.outFile.deleteOnExit();
            Assert.assertTrue((boolean)success);
            this.checkImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCropOddTileSize() throws FormatException, IOException {
        this.outFile = this.getOutFile("odd-test.ome.tiff");
        String[] args = new String[]{"-tilex", "128", "-tiley", "128", "-crop", "123,127,129,131", "test.fake", this.outFile.getAbsolutePath()};
        this.width = 129;
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            this.outFile.deleteOnExit();
            Assert.assertTrue((boolean)success);
            this.checkImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCropLargerThanTileSize() throws FormatException, IOException {
        this.outFile = this.getOutFile("large-crop.ome.tiff");
        String[] args = new String[]{"-tilex", "128", "-tiley", "128", "-crop", "0,0,256,256", "test&sizeX=128&sizeY=128.fake", this.outFile.getAbsolutePath()};
        this.width = 128;
        boolean success = false;
        try {
            ImageConverter converter = new ImageConverter();
            success = converter.testConvert((IFormatWriter)new ImageWriter(), args);
        }
        finally {
            this.outFile.deleteOnExit();
            Assert.assertTrue((boolean)success);
            this.checkImage();
        }
    }

    @Test(dataProvider="options")
    public void testTileOptions(String options) throws FormatException, IOException {
        this.outFile = this.getOutFile("tile-options.ome.tiff");
        String[] optionsArgs = options.split(" ");
        String[] tileArgs = new String[]{"-tilex", "128", "-tiley", "128"};
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("test&sizeZ=3&sizeC=2&sizeT=4&series=3&sizeX=512&sizeY=512.fake");
        argsList.addAll(Arrays.asList(optionsArgs));
        argsList.addAll(Arrays.asList(tileArgs));
        argsList.add(this.outFile.getAbsolutePath());
        String[] args = new String[argsList.size()];
        this.assertConversion(argsList.toArray(args));
    }

    @Test(dataProvider="options")
    public void testIndividualTiles(String options) throws FormatException, IOException {
        Path tempSubdir = this.getTempSubdir();
        this.outFile = tempSubdir.resolve("seperate-tiles_%x_%y_%m.ome.tiff").toFile();
        String[] optionsArgs = options.split(" ");
        String[] tileArgs = new String[]{"-tilex", "256", "-tiley", "256"};
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("test&sizeZ=3&sizeC=2&sizeT=4&series=3&sizeX=512&sizeY=512.fake");
        argsList.addAll(Arrays.asList(optionsArgs));
        argsList.addAll(Arrays.asList(tileArgs));
        argsList.add(this.outFile.getAbsolutePath());
        String[] args = new String[argsList.size()];
        File outFileToCheck = this.outFile = tempSubdir.resolve("seperate-tiles_0_0_0.ome.tiff").toFile();
        this.assertConversion(argsList.toArray(args), outFileToCheck.getAbsolutePath(), 256);
        for (File subfile : tempSubdir.toFile().listFiles()) {
            subfile.deleteOnExit();
        }
    }

    @Test(dataProvider="options")
    public void testTileGranularity(String options) throws FormatException, IOException {
        this.outFile = this.getOutFile("tile-options.tiff");
        String[] optionsArgs = options.split(" ");
        String[] tileArgs = new String[]{"-tilex", "42", "-tiley", "42"};
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("test&sizeZ=3&sizeC=2&sizeT=4&series=3&sizeX=512&sizeY=512.fake");
        argsList.addAll(Arrays.asList(optionsArgs));
        argsList.addAll(Arrays.asList(tileArgs));
        argsList.add(this.outFile.getAbsolutePath());
        String[] args = new String[argsList.size()];
        this.assertConversion(argsList.toArray(args), this.outFile.getAbsolutePath(), 512, 48);
    }

    @Test
    public void testConvertResolutionsFlattened() throws FormatException, IOException {
        this.outFile = this.getOutFile("resoutions_flat.ome.tiff");
        String[] args = new String[]{"test&resolutions=2.fake", this.outFile.getAbsolutePath()};
        this.assertConversion(args);
    }

    @Test
    public void testConvertResolutions() throws FormatException, IOException {
        this.outFile = this.getOutFile("resolutions_noflat.ome.tiff");
        String[] args = new String[]{"-noflat", "test&resolutions=2.fake", this.outFile.getAbsolutePath()};
        this.resolutionCount = 2;
        this.assertConversion(args);
    }

    @Test
    public void testConvertSingleChannel() throws FormatException, IOException {
        this.outFile = this.getOutFile("single-channel.ome.tiff");
        String[] args = new String[]{"single-channel&sizeC=3.fake", "-channel", "1", this.outFile.getAbsolutePath()};
        this.assertConversion(args);
        IMetadata meta = this.getOMEXMLMetadata(this.outFile);
        Assert.assertEquals((int)meta.getChannelCount(0), (int)1);
    }

    @Test
    public void testConvertResolutionsSingleChannel() throws FormatException, IOException {
        this.outFile = this.getOutFile("multires-single-plane.ome.tiff");
        String[] args = new String[]{"pyramid&sizeC=2&resolutions=2&resolutionScale=2.fake", "-noflat", "-channel", "0", this.outFile.getAbsolutePath()};
        this.resolutionCount = 2;
        this.assertConversion(args);
        IMetadata meta = this.getOMEXMLMetadata(this.outFile);
        Assert.assertEquals((int)meta.getImageCount(), (int)1);
        Assert.assertEquals((int)meta.getChannelCount(0), (int)1);
        Assert.assertEquals((int)((Integer)meta.getPixelsSizeC(0).getValue()), (int)1);
        Assert.assertEquals((int)((Integer)meta.getPixelsSizeZ(0).getValue()), (int)1);
        Assert.assertEquals((int)((Integer)meta.getPixelsSizeT(0).getValue()), (int)1);
    }

    @Test
    public void testConvertResolutionsSingleZ() throws FormatException, IOException {
        this.outFile = this.getOutFile("multires-single-z.ome.tiff");
        String[] args = new String[]{"pyramid&sizeC=3&sizeZ=4&resolutions=2&resolutionScale=2.fake", "-noflat", "-z", "1", this.outFile.getAbsolutePath()};
        this.resolutionCount = 2;
        this.assertConversion(args);
        IMetadata meta = this.getOMEXMLMetadata(this.outFile);
        Assert.assertEquals((int)meta.getImageCount(), (int)1);
        Assert.assertEquals((int)meta.getChannelCount(0), (int)3);
        Assert.assertEquals((int)((Integer)meta.getPixelsSizeC(0).getValue()), (int)3);
        Assert.assertEquals((int)((Integer)meta.getPixelsSizeZ(0).getValue()), (int)1);
        Assert.assertEquals((int)((Integer)meta.getPixelsSizeT(0).getValue()), (int)1);
    }

    private Path getTempSubdir() throws IOException {
        Path subdir = Files.createTempDirectory(this.tempDir, "ImageConverterTest", new FileAttribute[0]);
        subdir.toFile().deleteOnExit();
        return subdir;
    }

    private File getOutFile(String name) throws IOException {
        return this.getTempSubdir().resolve(name).toFile();
    }

    private IMetadata getOMEXMLMetadata(File out) throws FormatException {
        OMEXMLMetadata meta = null;
        try (TiffParser parser = new TiffParser(this.outFile.getAbsolutePath());){
            String comment = parser.getComment();
            OMEXMLService service = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
            meta = service.createOMEXMLMetadata(comment);
        }
        catch (Exception e) {
            throw new FormatException((Throwable)e);
        }
        return meta;
    }
}

