/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.EOFException;
import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class BufferAlignmentReadTest {
    private static final byte[] PAGE = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 2;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 2);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)64L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)4, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)6, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)8, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)10, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)11, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)12, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)13, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)14, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)15, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)16, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)17, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)18, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)19, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)20, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)21, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)22, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)23, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)24, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)25, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)26, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)27, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)28, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)29, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)30, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)31, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)32, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)33, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)34, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)35, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)36, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)37, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)38, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)39, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)40, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)41, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)42, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)43, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)44, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)45, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)46, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)47, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)48, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)49, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)50, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)51, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)52, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)53, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)54, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)55, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)56, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)57, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)58, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)59, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)60, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)61, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)62, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)63, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)64, (int)this.fileHandle.readByte());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(32L);
        AssertJUnit.assertEquals((int)33, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)34, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)35, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)36, (int)this.fileHandle.readByte());
    }

    @Test
    public void testReset() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)4, (int)this.fileHandle.readByte());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readByte());
    }

    @Test
    public void testSeekBack() throws IOException {
        this.fileHandle.seek(48L);
        this.fileHandle.seek(32L);
        AssertJUnit.assertEquals((int)33, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)34, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)35, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)36, (int)this.fileHandle.readByte());
    }

    @Test
    public void testBufferBoundry() throws IOException {
        this.fileHandle.seek(32L);
        AssertJUnit.assertEquals((int)33, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)34, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)35, (int)this.fileHandle.readByte());
        this.fileHandle.seek(31L);
        AssertJUnit.assertEquals((int)32, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)33, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)34, (int)this.fileHandle.readByte());
        this.fileHandle.seek(28L);
        AssertJUnit.assertEquals((int)29, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)30, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)31, (int)this.fileHandle.readByte());
    }

    @Test
    public void testReadOverBufferBoundary() throws IOException {
        this.fileHandle.seek(1L);
        AssertJUnit.assertEquals((int)515, (int)this.fileHandle.readShort());
    }

    @Test
    public void testRandomAccessReadByte() throws IOException {
        this.testSeekForward();
        this.testSeekBack();
        this.testBufferBoundry();
        this.fileHandle.seek(0L);
        this.testReset();
    }

    @Test(expectedExceptions={EOFException.class})
    public void testReadExplicitlyOffEnd() throws IOException {
        this.fileHandle.seek(64L);
        this.fileHandle.readByte();
    }

    @Test(expectedExceptions={EOFException.class})
    public void testReadPartiallyOffEnd() throws IOException {
        this.fileHandle.seek(63L);
        this.fileHandle.readShort();
    }

    public void testReadExplicitlyArrayOffEnd() throws IOException {
        this.fileHandle.seek(64L);
        byte[] buf = new byte[1];
        AssertJUnit.assertEquals((int)0, (int)this.fileHandle.read(buf));
        AssertJUnit.assertEquals((int)0, (int)buf[0]);
    }

    public void testReadPartiallyArrayOffEnd() throws IOException {
        this.fileHandle.seek(63L);
        byte[] buf = new byte[2];
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.read(buf));
        AssertJUnit.assertEquals((int)64, (int)buf[0]);
        AssertJUnit.assertEquals((int)0, (int)buf[1]);
    }

    public void testReadExplicitlySubArrayOffEnd() throws IOException {
        this.fileHandle.seek(64L);
        byte[] buf = new byte[3];
        AssertJUnit.assertEquals((int)0, (int)this.fileHandle.read(buf, 1, 1));
        AssertJUnit.assertEquals((int)0, (int)buf[0]);
        AssertJUnit.assertEquals((int)0, (int)buf[1]);
        AssertJUnit.assertEquals((int)0, (int)buf[2]);
    }

    public void testReadPartiallySubArrayOffEnd() throws IOException {
        this.fileHandle.seek(63L);
        byte[] buf = new byte[6];
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.read(buf, 2, 2));
        AssertJUnit.assertEquals((int)0, (int)buf[0]);
        AssertJUnit.assertEquals((int)0, (int)buf[1]);
        AssertJUnit.assertEquals((int)64, (int)buf[2]);
        AssertJUnit.assertEquals((int)0, (int)buf[3]);
        AssertJUnit.assertEquals((int)0, (int)buf[4]);
        AssertJUnit.assertEquals((int)0, (int)buf[5]);
    }
}

