/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import ucar.ma2.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.Time2DCoordSys;
import ucar.nc2.ft2.coverage.Time2DOffsetCoordSys;
import ucar.nc2.ft2.coverage.TimeAxis2DFmrc;
import ucar.nc2.ft2.coverage.TimeOffsetAxis;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Misc;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class CoverageCoordSys {
    protected CoordSysContainer dataset;
    private HorizCoordSys horizCoordSys;
    private Time2DCoordSys time2DCoordSys;
    private Map<String, List<CoverageCoordAxis>> dependentMap;
    private boolean isConstantForecast;
    private boolean immutable;
    private final String name;
    private final List<String> axisNames;
    private final List<String> transformNames;
    private final FeatureType type;

    public static String makeCoordSysName(List<String> axisNames) {
        StringBuilder sb = new StringBuilder();
        for (String axisName : axisNames) {
            sb.append(axisName).append(' ');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public CoverageCoordSys(String name, List<String> axisNames, List<String> transformNames, FeatureType type) {
        this.name = name != null ? name : CoverageCoordSys.makeCoordSysName(axisNames);
        this.axisNames = axisNames;
        this.transformNames = transformNames;
        this.type = type;
    }

    public CoverageCoordSys(CoverageCoordSys from) {
        this.name = from.getName();
        this.axisNames = from.getAxisNames();
        this.transformNames = from.getTransformNames();
        this.type = from.getCoverageType();
    }

    public boolean isConstantForecast() {
        return this.isConstantForecast;
    }

    void setIsConstantForecast(boolean isConstantForecast) {
        if (this.immutable) {
            throw new RuntimeException("Cant change CoverageCoordSys dataset once set immutable");
        }
        this.isConstantForecast = isConstantForecast;
    }

    void setImmutable() {
        this.immutable = true;
    }

    public void setDataset(CoordSysContainer dataset) {
        if (this.immutable) {
            throw new RuntimeException("Cant change CoverageCoordSys dataset once set immutable");
        }
        this.dataset = dataset;
        this.dependentMap = new HashMap<String, List<CoverageCoordAxis>>();
        for (CoverageCoordAxis axis : this.getAxes()) {
            if (axis.getDependenceType() != CoverageCoordAxis.DependenceType.dependent) continue;
            for (String indAxisName : axis.dependsOn) {
                CoverageCoordAxis independentAxis = dataset.findCoordAxis(indAxisName);
                if (independentAxis == null) {
                    throw new RuntimeException("Dependent axis " + axis.getName() + " depends on " + indAxisName + " not in Dataset");
                }
                if (!this.axisNames.contains(indAxisName)) {
                    throw new RuntimeException("Dependent axis " + axis.getName() + " depends on " + indAxisName + " not in CoordSys");
                }
                List dependents = this.dependentMap.computeIfAbsent(indAxisName, k -> new ArrayList());
                dependents.add(axis);
            }
        }
        TimeAxis2DFmrc time2DAxis = null;
        TimeOffsetAxis timeOffsetAxis = null;
        CoverageCoordAxis1D runtimeAxis = null;
        for (CoverageCoordAxis axis : this.getAxes()) {
            if (axis.getAxisType() == AxisType.TimeOffset) {
                if (timeOffsetAxis != null) {
                    throw new RuntimeException("Cant have multiple TimeOffset Axes in a CoverageCoordSys");
                }
                if (axis instanceof TimeOffsetAxis) {
                    timeOffsetAxis = (TimeOffsetAxis)axis;
                }
            }
            if (axis.getAxisType() == AxisType.RunTime) {
                if (runtimeAxis != null) {
                    throw new RuntimeException("Cant have multiple RunTime axes in a CoverageCoordSys");
                }
                runtimeAxis = (CoverageCoordAxis1D)axis;
            }
            if (!(axis instanceof TimeAxis2DFmrc)) continue;
            if (time2DAxis != null) {
                throw new RuntimeException("Cant have multiple TimeAxis2D axes in a CoverageCoordSys");
            }
            time2DAxis = (TimeAxis2DFmrc)axis;
        }
        if (timeOffsetAxis != null) {
            if (runtimeAxis == null) {
                throw new RuntimeException("TimeOffset Axis must have a RunTime axis in a CoverageCoordSys");
            }
            if (this.immutable && this.time2DCoordSys != null) {
                throw new RuntimeException("Cant have multiple Time2DCoordSys in a CoverageCoordSys");
            }
            this.time2DCoordSys = new Time2DOffsetCoordSys(runtimeAxis, timeOffsetAxis);
        }
        if (time2DAxis != null) {
            if (runtimeAxis == null) {
                throw new RuntimeException("TimeAxis2D Axis must have a RunTime axis in a CoverageCoordSys");
            }
            if (this.immutable && this.time2DCoordSys != null) {
                throw new RuntimeException("Cant have multiple Time2DCoordSys in a CoverageCoordSys");
            }
            this.time2DCoordSys = new Time2DCoordSys(runtimeAxis, time2DAxis);
        }
    }

    public void setHorizCoordSys(HorizCoordSys horizCoordSys) {
        if (this.immutable) {
            throw new RuntimeException("Cant change CoverageCoordSys horizCoordSys once set immutable");
        }
        this.horizCoordSys = horizCoordSys;
    }

    public HorizCoordSys makeHorizCoordSys() {
        CoverageCoordAxis xaxis = this.getAxis(AxisType.GeoX);
        CoverageCoordAxis yaxis = this.getAxis(AxisType.GeoY);
        CoverageCoordAxis lataxis = this.getAxis(AxisType.Lat);
        CoverageCoordAxis lonaxis = this.getAxis(AxisType.Lon);
        CoverageTransform hct = this.getHorizTransform();
        return HorizCoordSys.factory((CoverageCoordAxis1D)xaxis, (CoverageCoordAxis1D)yaxis, lataxis, lonaxis, hct);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTransformNames() {
        return this.transformNames != null ? this.transformNames : new ArrayList<String>();
    }

    public List<CoverageTransform> getTransforms() {
        ArrayList<CoverageTransform> result = new ArrayList<CoverageTransform>();
        for (String name : this.getTransformNames()) {
            result.add(this.dataset.findCoordTransform(name));
        }
        return result;
    }

    public CoverageTransform getHorizTransform() {
        for (String name : this.getTransformNames()) {
            CoverageTransform ct = this.dataset.findCoordTransform(name);
            if (ct == null || !ct.isHoriz()) continue;
            return ct;
        }
        return null;
    }

    public HorizCoordSys getHorizCoordSys() {
        return this.horizCoordSys;
    }

    public FeatureType getCoverageType() {
        return this.type;
    }

    public List<String> getAxisNames() {
        return this.axisNames;
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        indent.incr();
        f.format("%s CoordSys '%s' type %s", new Object[]{indent, this.name, this.type});
        f.format(" has coordVars:", new Object[0]);
        for (String v : this.axisNames) {
            f.format("%s, ", v);
        }
        f.format(" (shape=[%s])", Misc.showInts(this.getShape()));
        if (this.transformNames != null && !this.transformNames.isEmpty()) {
            f.format("; has transforms:", new Object[0]);
            for (String t2 : this.transformNames) {
                f.format("%s, ", t2);
            }
        }
        indent.decr();
    }

    public CoverageCoordAxis getXAxis() {
        CoverageCoordAxis result = this.getAxis(AxisType.GeoX);
        if (result == null) {
            result = this.getAxis(AxisType.Lon);
        }
        if (result == null) {
            throw new IllegalArgumentException("Cant find X axis for coordsys " + this.getName());
        }
        return result;
    }

    public CoverageCoordAxis getYAxis() {
        CoverageCoordAxis result = this.getAxis(AxisType.GeoY);
        if (result == null) {
            result = this.getAxis(AxisType.Lat);
        }
        if (result == null) {
            throw new IllegalArgumentException("Cant find Y axis for coordsys " + this.getName());
        }
        return result;
    }

    public CoverageCoordAxis getZAxis() {
        for (String axisName : this.getAxisNames()) {
            CoverageCoordAxis axis = this.dataset.findCoordAxis(axisName);
            if (axis == null) {
                throw new IllegalStateException("Cant find axis with name " + axisName);
            }
            if (axis.getAxisType() != AxisType.GeoZ && axis.getAxisType() != AxisType.Height && axis.getAxisType() != AxisType.Pressure) continue;
            return axis;
        }
        return null;
    }

    public CoverageCoordAxis getTimeAxis() {
        CoverageCoordAxis result = this.getAxis(AxisType.Time);
        if (result == null) {
            result = this.getAxis(AxisType.TimeOffset);
        }
        return result;
    }

    public CoverageCoordAxis getAxis(AxisType type) {
        for (String axisName : this.getAxisNames()) {
            CoverageCoordAxis axis = this.dataset.findCoordAxis(axisName);
            if (axis == null) {
                throw new IllegalStateException("Cant find axis with name " + axisName);
            }
            if (axis.getAxisType() != type) continue;
            return axis;
        }
        return null;
    }

    public CoverageCoordAxis getAxis(String axisName) {
        return this.dataset.findCoordAxis(axisName);
    }

    public List<CoverageCoordAxis> getAxes() {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        for (String axisName : this.getAxisNames()) {
            CoverageCoordAxis axis = this.dataset.findCoordAxis(axisName);
            if (axis == null) {
                throw new IllegalStateException("Cant find " + axisName);
            }
            result.add(axis);
        }
        return result;
    }

    public int[] getShape() {
        int rank = 2;
        if (this.time2DCoordSys != null) {
            rank += this.time2DCoordSys.getShape().length;
        }
        for (CoverageCoordAxis axis : this.getAxes()) {
            if (axis.getAxisType().isHoriz() || this.isTime2D(axis) || axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
            ++rank;
        }
        int[] result = new int[rank];
        int count = 0;
        if (this.time2DCoordSys != null) {
            int[] timeShape = this.time2DCoordSys.getShape();
            System.arraycopy(timeShape, 0, result, count, timeShape.length);
            count += timeShape.length;
        }
        for (CoverageCoordAxis axis : this.getAxes()) {
            if (axis.getAxisType().isHoriz() || this.isTime2D(axis) || axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
            result[count++] = axis.getNcoords();
        }
        for (RangeIterator ri : this.horizCoordSys.getRanges()) {
            result[count++] = ri.length();
        }
        return result;
    }

    public List<RangeIterator> getRanges() {
        ArrayList<RangeIterator> result = new ArrayList<RangeIterator>();
        for (CoverageCoordAxis axis : this.getAxes()) {
            if (axis.getAxisType().isHoriz() || axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) continue;
            result.add(axis.getRangeIterator());
        }
        result.addAll(this.horizCoordSys.getRanges());
        return result;
    }

    public boolean isRegularSpatial() {
        CoverageCoordAxis xaxis = this.getXAxis();
        CoverageCoordAxis yaxis = this.getYAxis();
        if (!(xaxis instanceof CoverageCoordAxis1D) || !xaxis.isRegular()) {
            return false;
        }
        return yaxis instanceof CoverageCoordAxis1D && yaxis.isRegular();
    }

    public ProjectionImpl getProjection() {
        for (String ctName : this.getTransformNames()) {
            CoverageTransform ct = this.dataset.findCoordTransform(ctName);
            if (ct == null || !ct.isHoriz()) continue;
            return ct.getProjection();
        }
        return new LatLonProjection();
    }

    public boolean isTime2D(CoverageCoordAxis axis) {
        if (this.time2DCoordSys == null) {
            return false;
        }
        if (axis instanceof TimeOffsetAxis) {
            return true;
        }
        if (axis instanceof TimeAxis2DFmrc) {
            return true;
        }
        return axis.getAxisType() == AxisType.RunTime && axis.getDependenceType() != CoverageCoordAxis.DependenceType.dependent;
    }

    public Optional<CoverageCoordSys> subset(SubsetParams params) {
        return this.subset(params, false, true);
    }

    public Optional<CoverageCoordSys> subset(SubsetParams params, boolean makeCFcompliant, boolean finish) {
        Optional<HorizCoordSys> horizo;
        Formatter errMessages = new Formatter();
        ArrayList<CoverageCoordAxis> subsetAxes = new ArrayList<CoverageCoordAxis>();
        for (CoverageCoordAxis axis : this.getAxes()) {
            if (axis.getDependenceType() == CoverageCoordAxis.DependenceType.dependent || axis.getAxisType().isHoriz() || this.isTime2D(axis)) continue;
            Optional<CoverageCoordAxis> axiso = axis.subset(params);
            if (!axiso.isPresent()) {
                errMessages.format("%s: %s;%n", axis.getName(), axiso.getErrorMessage());
                continue;
            }
            CoverageCoordAxis1D subsetInd = (CoverageCoordAxis1D)axiso.get();
            subsetAxes.add(subsetInd);
            for (CoverageCoordAxis dependent : this.getDependentAxes(subsetInd)) {
                Optional<CoverageCoordAxis> depo = dependent.subsetDependent(subsetInd);
                if (depo.isPresent()) {
                    subsetAxes.add(depo.get());
                    continue;
                }
                errMessages.format("%s;%n", depo.getErrorMessage());
            }
        }
        AtomicBoolean isConstantForecast = new AtomicBoolean(false);
        if (this.time2DCoordSys != null) {
            Optional<List<CoverageCoordAxis>> time2Do = this.time2DCoordSys.subset(params, isConstantForecast, makeCFcompliant);
            if (!time2Do.isPresent()) {
                errMessages.format("%s;%n", time2Do.getErrorMessage());
            } else {
                subsetAxes.addAll((Collection)time2Do.get());
            }
        }
        if (!(horizo = this.horizCoordSys.subset(params)).isPresent()) {
            errMessages.format("%s;%n", horizo.getErrorMessage());
        } else {
            HorizCoordSys subsetHcs = horizo.get();
            subsetAxes.addAll(subsetHcs.getCoordAxes());
        }
        String errs = errMessages.toString();
        if (!errs.isEmpty()) {
            return Optional.empty(errs);
        }
        Collections.sort(subsetAxes);
        ArrayList<String> names = new ArrayList<String>();
        for (CoverageCoordAxis axis : subsetAxes) {
            names.add(axis.getName());
        }
        CoverageCoordSys resultCoordSys = new CoverageCoordSys(null, names, this.getTransformNames(), this.getCoverageType());
        MyCoordSysContainer fakeDataset = new MyCoordSysContainer(subsetAxes, this.getTransforms());
        resultCoordSys.setDataset(fakeDataset);
        resultCoordSys.setHorizCoordSys(resultCoordSys.makeHorizCoordSys());
        resultCoordSys.setIsConstantForecast(isConstantForecast.get());
        if (finish) {
            resultCoordSys.setImmutable();
        }
        return Optional.of(resultCoordSys);
    }

    public List<CoverageCoordAxis> getDependentAxes(CoverageCoordAxis indAxis) {
        ArrayList result = this.dependentMap.get(indAxis.getName());
        return result == null ? new ArrayList() : result;
    }

    private static class MyCoordSysContainer
    implements CoordSysContainer {
        public List<CoverageCoordAxis> axes;
        public List<CoverageTransform> transforms;

        private MyCoordSysContainer(List<CoverageCoordAxis> axes, List<CoverageTransform> transforms) {
            this.axes = axes;
            this.transforms = transforms;
        }

        @Override
        public CoverageTransform findCoordTransform(String transformName) {
            for (CoverageTransform ct : this.transforms) {
                if (!ct.getName().equalsIgnoreCase(transformName)) continue;
                return ct;
            }
            return null;
        }

        @Override
        public CoverageCoordAxis findCoordAxis(String axisName) {
            for (CoverageCoordAxis axis : this.axes) {
                if (!axis.getName().equalsIgnoreCase(axisName)) continue;
                return axis;
            }
            return null;
        }
    }
}

