/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.NCheader;
import ucar.unidata.io.RandomAccessFile;

@Deprecated
public class N3header
extends NCheader {
    private static Logger log = LoggerFactory.getLogger(N3header.class);
    static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    static final byte[] MAGIC = new byte[]{67, 68, 70, 1};
    static final byte[] MAGIC_LONG = new byte[]{67, 68, 70, 2};
    static final int MAGIC_DIM = 10;
    static final int MAGIC_VAR = 11;
    static final int MAGIC_ATT = 12;
    public static boolean disallowFileTruncation;
    public static boolean debugHeaderSize;
    private static boolean debugVariablePos;
    private static boolean debugStreaming;
    RandomAccessFile raf;
    private NetcdfFile ncfile;
    private List<Variable> uvars = new ArrayList<Variable>();
    private Dimension udim;
    boolean isStreaming;
    int numrecs;
    long recsize;
    long recStart = Integer.MAX_VALUE;
    private boolean useLongOffset;
    private long nonRecordDataSize;
    private long dataStart = Long.MAX_VALUE;
    private long globalAttsPos;
    private Optional<Boolean> headerCreated = Optional.empty();

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        switch (N3header.checkFileType(raf)) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile, Formatter fout) throws IOException {
        long calcSize;
        Variable uvar;
        DataType dtype;
        this.raf = raf;
        this.ncfile = ncfile;
        long actualSize = raf.length();
        this.nonRecordDataSize = 0L;
        this.recsize = 0L;
        this.recStart = Integer.MAX_VALUE;
        long pos = 0L;
        raf.order(0);
        raf.seek(pos);
        byte[] b = new byte[4];
        raf.readFully(b);
        for (int i = 0; i < 3; ++i) {
            if (b[i] == MAGIC[i]) continue;
            throw new IOException("Not a netCDF file " + raf.getLocation());
        }
        if (b[3] != 1 && b[3] != 2) {
            throw new IOException("Not a netCDF file " + raf.getLocation());
        }
        this.useLongOffset = b[3] == 2;
        this.numrecs = raf.readInt();
        if (fout != null) {
            fout.format("numrecs= %d%n", this.numrecs);
        }
        if (this.numrecs == -1) {
            this.isStreaming = true;
            this.numrecs = 0;
        }
        int numdims = 0;
        int magic = raf.readInt();
        if (magic == 0) {
            raf.readInt();
        } else {
            if (magic != 10) {
                throw new IOException("Misformed netCDF file - dim magic number wrong " + raf.getLocation());
            }
            numdims = raf.readInt();
            if (fout != null) {
                fout.format("numdims= %d%n", numdims);
            }
        }
        for (int i = 0; i < numdims; ++i) {
            Dimension dim;
            if (fout != null) {
                fout.format("  dim %d pos= %d%n", i, raf.getFilePointer());
            }
            String name = this.readString();
            int len = raf.readInt();
            if (len == 0) {
                this.udim = dim = new Dimension(name, this.numrecs, true, true, false);
            } else {
                dim = new Dimension(name, len, true, false, false);
            }
            ncfile.addDimension(null, dim);
            if (fout == null) continue;
            fout.format(" added dimension %s%n", dim);
        }
        this.globalAttsPos = raf.getFilePointer();
        this.readAtts(ncfile.getRootGroup(), fout);
        int nvars = 0;
        magic = raf.readInt();
        if (magic == 0) {
            raf.readInt();
        } else {
            if (magic != 11) {
                throw new IOException("Misformed netCDF file  - var magic number wrong " + raf.getLocation());
            }
            nvars = raf.readInt();
            if (fout != null) {
                fout.format("numdims= %d%n", numdims);
            }
        }
        if (fout != null) {
            fout.format("num variables= %d%n", nvars);
        }
        for (int i = 0; i < nvars; ++i) {
            long begin;
            long startPos = raf.getFilePointer();
            String name = this.readString();
            Variable var = new Variable(ncfile, ncfile.getRootGroup(), null, name);
            long velems = 1L;
            boolean isRecord = false;
            int rank = raf.readInt();
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (int j = 0; j < rank; ++j) {
                int dimIndex = raf.readInt();
                Dimension dim = ncfile.getRootGroup().getDimensions().get(dimIndex);
                if (dim.isUnlimited()) {
                    isRecord = true;
                    this.uvars.add(var);
                } else {
                    velems *= (long)dim.getLength();
                }
                dims.add(dim);
            }
            var.setDimensions(dims);
            if (fout != null) {
                fout.format("---name=<%s> dims = [", name);
                for (Dimension dim : dims) {
                    fout.format("%s ", dim.getShortName());
                }
                fout.format("]%n", new Object[0]);
            }
            long varAttsPos = raf.getFilePointer();
            this.readAtts(var, fout);
            int type = raf.readInt();
            DataType dataType = this.getDataType(type);
            var.setDataType(dataType);
            long vsize = raf.readInt();
            long l = begin = this.useLongOffset ? raf.readLong() : (long)raf.readInt();
            if (fout != null) {
                fout.format(" name= %s type=%d vsize=%s velems=%d begin= %d isRecord=%s attsPos=%d%n", name, type, vsize, velems, begin, isRecord, varAttsPos);
                long calcVsize = (velems + (long)N3header.padding(velems)) * (long)dataType.getSize();
                if (vsize != calcVsize) {
                    fout.format(" *** readVsize %d != calcVsize %d%n", vsize, calcVsize);
                }
            }
            if (vsize < 0L) {
                vsize = (velems + (long)N3header.padding(velems)) * (long)dataType.getSize();
            }
            var.setSPobject(new Vinfo(vsize, begin, isRecord, varAttsPos));
            if (isRecord) {
                this.recsize += vsize;
                this.recStart = Math.min(this.recStart, begin);
            } else {
                this.nonRecordDataSize = Math.max(this.nonRecordDataSize, begin + vsize);
            }
            this.dataStart = Math.min(this.dataStart, begin);
            if (debugVariablePos) {
                System.out.printf("%s begin at=%d end=%d  isRecord=%s nonRecordDataSize=%d%n", var.getFullName(), begin, begin + vsize, isRecord, this.nonRecordDataSize);
            }
            if (fout != null) {
                fout.format("%s begin at=%d end=%d  isRecord=%s nonRecordDataSize=%d%n", var.getFullName(), begin, begin + vsize, isRecord, this.nonRecordDataSize);
            }
            if (debugHeaderSize) {
                System.out.printf("%s header size=%d data size= %d%n", var.getFullName(), raf.getFilePointer() - startPos, vsize);
            }
            ncfile.addVariable(null, var);
        }
        pos = raf.getFilePointer();
        if (this.dataStart == Long.MAX_VALUE) {
            this.dataStart = pos;
        }
        if (this.nonRecordDataSize > 0L) {
            this.nonRecordDataSize -= this.dataStart;
        }
        if (this.uvars.isEmpty()) {
            this.recStart = 0L;
        }
        if (this.uvars.size() == 1 && ((dtype = (uvar = this.uvars.get(0)).getDataType()) == DataType.CHAR || dtype == DataType.BYTE || dtype == DataType.SHORT)) {
            long vsize = uvar.getDataType().getSize();
            for (Dimension curDim : uvar.getDimensions()) {
                if (curDim.isUnlimited()) continue;
                vsize *= (long)curDim.getLength();
            }
            Vinfo vinfo = (Vinfo)uvar.getSPobject();
            if (vsize != vinfo.vsize) {
                this.recsize = vsize;
                vinfo.vsize = vsize;
            }
        }
        if (debugHeaderSize) {
            System.out.println("  filePointer = " + pos + " dataStart=" + this.dataStart);
            System.out.println("  recStart = " + this.recStart + " dataStart+nonRecordDataSize =" + (this.dataStart + this.nonRecordDataSize));
            System.out.println("  nonRecordDataSize size= " + this.nonRecordDataSize);
            System.out.println("  recsize= " + this.recsize);
            System.out.println("  numrecs= " + this.numrecs);
            System.out.println("  actualSize= " + actualSize);
        }
        if (this.isStreaming) {
            long recordSpace = actualSize - this.recStart;
            int n = this.numrecs = this.recsize == 0L ? 0 : (int)(recordSpace / this.recsize);
            if (debugStreaming) {
                long extra = this.recsize == 0L ? 0L : recordSpace % this.recsize;
                System.out.println(" isStreaming recordSpace=" + recordSpace + " numrecs=" + this.numrecs + " has extra bytes = " + extra);
            }
            if (this.udim != null) {
                this.udim.setLength(this.numrecs);
                for (Variable uvar2 : this.uvars) {
                    uvar2.resetShape();
                    uvar2.invalidateCache();
                }
            }
        }
        if ((calcSize = this.dataStart + this.nonRecordDataSize + this.recsize * (long)this.numrecs) > actualSize + 3L) {
            if (disallowFileTruncation) {
                throw new IOException("File is truncated calculated size= " + calcSize + " actual = " + actualSize);
            }
            raf.setExtendMode();
        }
    }

    long calcFileSize() {
        long size = 0L;
        if (this.headerCreated.isPresent() && this.headerCreated.get().booleanValue()) {
            size = this.udim != null ? this.recStart + this.recsize * (long)this.numrecs : this.dataStart + this.nonRecordDataSize;
        }
        return size;
    }

    void showDetail(Formatter out) throws IOException {
        long actual = this.raf.length();
        out.format("  raf length= %s %n", actual);
        out.format("  isStreaming= %s %n", this.isStreaming);
        out.format("  useLongOffset= %s %n", this.useLongOffset);
        out.format("  dataStart= %d%n", this.dataStart);
        out.format("  nonRecordData size= %d %n", this.nonRecordDataSize);
        out.format("  unlimited dimension = %s %n", this.udim);
        if (this.udim != null) {
            out.format("  record Data starts = %d %n", this.recStart);
            out.format("  recsize = %d %n", this.recsize);
            out.format("  numrecs = %d %n", this.numrecs);
        }
        long calcSize = this.calcFileSize();
        out.format("  computedSize = %d %n", calcSize);
        if (actual < calcSize) {
            out.format("  TRUNCATED!! actual size = %d (%d bytes) %n", actual, calcSize - actual);
        } else if (actual != calcSize) {
            out.format(" actual size larger = %d (%d byte extra) %n", actual, actual - calcSize);
        }
        out.format("%n  %20s____start_____size__unlim%n", "name");
        for (Variable v : this.ncfile.getVariables()) {
            Vinfo vinfo = (Vinfo)v.getSPobject();
            out.format("  %20s %8d %8d  %s %n", v.getShortName(), vinfo.begin, vinfo.vsize, vinfo.isRecord);
        }
    }

    synchronized boolean removeRecordStructure() {
        boolean found = false;
        for (Variable v : this.uvars) {
            if (!v.getFullName().equals("record")) continue;
            this.uvars.remove(v);
            this.ncfile.getRootGroup().getVariables().remove(v);
            found = true;
            break;
        }
        this.ncfile.finish();
        return found;
    }

    synchronized boolean makeRecordStructure() {
        if (!this.uvars.isEmpty()) {
            Structure recordStructure = new Structure(this.ncfile, this.ncfile.getRootGroup(), null, "record");
            recordStructure.setDimensions(this.udim.getShortName());
            for (Variable v : this.uvars) {
                Variable memberV;
                try {
                    memberV = v.slice(0, 0);
                }
                catch (InvalidRangeException e) {
                    log.warn("N3header.makeRecordStructure cant slice variable " + v + " " + e.getMessage());
                    return false;
                }
                memberV.setParentStructure(recordStructure);
                recordStructure.addMemberVariable(memberV);
            }
            this.uvars.add(recordStructure);
            this.ncfile.getRootGroup().addVariable(recordStructure);
            this.ncfile.finish();
            return true;
        }
        return false;
    }

    private int readAtts(AttributeContainer atts, Formatter fout) throws IOException {
        int natts = 0;
        int magic = this.raf.readInt();
        if (magic == 0) {
            this.raf.readInt();
        } else {
            if (magic != 12) {
                throw new IOException("Misformed netCDF file  - att magic number wrong");
            }
            natts = this.raf.readInt();
        }
        if (fout != null) {
            fout.format(" num atts= %d%n", natts);
        }
        for (int i = 0; i < natts; ++i) {
            Attribute att;
            if (fout != null) {
                fout.format("***att %d pos= %d%n", i, this.raf.getFilePointer());
            }
            String name = this.readString();
            int type = this.raf.readInt();
            if (type == 2) {
                String val;
                if (fout != null) {
                    fout.format(" begin read String val pos= %d%n", this.raf.getFilePointer());
                }
                if ((val = this.readString()) == null) {
                    val = "";
                }
                if (fout != null) {
                    fout.format(" end read String val pos= %d%n", this.raf.getFilePointer());
                }
                att = new Attribute(name, val);
            } else {
                if (fout != null) {
                    fout.format(" begin read val pos= %d%n", this.raf.getFilePointer());
                }
                int nelems = this.raf.readInt();
                DataType dtype = this.getDataType(type);
                if (nelems == 0) {
                    att = new Attribute(name, dtype);
                } else {
                    int[] shape = new int[]{nelems};
                    Array arr = Array.factory(dtype, shape);
                    IndexIterator ii = arr.getIndexIterator();
                    int nbytes = 0;
                    for (int j = 0; j < nelems; ++j) {
                        nbytes += this.readAttributeValue(dtype, ii);
                    }
                    att = new Attribute(name, arr);
                    this.skip(nbytes);
                }
                if (fout != null) {
                    fout.format(" end read val pos= %d%n", this.raf.getFilePointer());
                }
            }
            atts.addAttribute(att);
            if (fout == null) continue;
            fout.format("  %s%n", att);
        }
        return natts;
    }

    private int readAttributeValue(DataType type, IndexIterator ii) throws IOException {
        if (type == DataType.BYTE) {
            byte b = (byte)this.raf.read();
            ii.setByteNext(b);
            return 1;
        }
        if (type == DataType.CHAR) {
            char c = (char)this.raf.read();
            ii.setCharNext(c);
            return 1;
        }
        if (type == DataType.SHORT) {
            short s2 = this.raf.readShort();
            ii.setShortNext(s2);
            return 2;
        }
        if (type == DataType.INT) {
            int i = this.raf.readInt();
            ii.setIntNext(i);
            return 4;
        }
        if (type == DataType.FLOAT) {
            float f = this.raf.readFloat();
            ii.setFloatNext(f);
            return 4;
        }
        if (type == DataType.DOUBLE) {
            double d = this.raf.readDouble();
            ii.setDoubleNext(d);
            return 8;
        }
        return 0;
    }

    private String readString() throws IOException {
        int count;
        int nelems = this.raf.readInt();
        byte[] b = new byte[nelems];
        this.raf.readFully(b);
        this.skip(nelems);
        if (nelems == 0) {
            return null;
        }
        for (count = 0; count < nelems && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, StandardCharsets.UTF_8);
    }

    private void skip(int nbytes) throws IOException {
        int pad = N3header.padding(nbytes);
        if (pad > 0) {
            this.raf.seek(this.raf.getFilePointer() + (long)pad);
        }
    }

    static int padding(int nbytes) {
        int pad = nbytes % 4;
        if (pad != 0) {
            pad = 4 - pad;
        }
        return pad;
    }

    static int padding(long nbytes) {
        int pad = (int)(nbytes % 4L);
        if (pad != 0) {
            pad = 4 - pad;
        }
        return pad;
    }

    private DataType getDataType(int type) {
        switch (type) {
            case 1: {
                return DataType.BYTE;
            }
            case 2: {
                return DataType.CHAR;
            }
            case 3: {
                return DataType.SHORT;
            }
            case 4: {
                return DataType.INT;
            }
            case 5: {
                return DataType.FLOAT;
            }
            case 6: {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("unknown type == " + type);
    }

    static int getType(DataType dt) {
        if (dt == DataType.BYTE) {
            return 1;
        }
        if (dt == DataType.CHAR || dt == DataType.STRING) {
            return 2;
        }
        if (dt == DataType.SHORT) {
            return 3;
        }
        if (dt == DataType.INT) {
            return 4;
        }
        if (dt == DataType.FLOAT) {
            return 5;
        }
        if (dt == DataType.DOUBLE) {
            return 6;
        }
        throw new IllegalArgumentException("unknown DataType == " + (Object)((Object)dt));
    }

    void create(RandomAccessFile raf, NetcdfFile ncfile, int extra, boolean largeFile, Formatter fout) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        this.writeHeader(extra, largeFile, false, fout);
    }

    boolean rewriteHeader(boolean largeFile, Formatter fout) throws IOException {
        boolean rewriteInPlace = true;
        int want = this.sizeHeader(largeFile);
        if ((long)want > this.dataStart) {
            rewriteInPlace = false;
        } else if (want != -1 && !this.headerCreated.isPresent()) {
            this.writeHeader(0, largeFile, true, fout);
            rewriteInPlace = true;
        } else if (this.headerCreated.isPresent() && this.headerCreated.get().booleanValue()) {
            this.writeHeader(0, largeFile, true, fout);
            rewriteInPlace = true;
        } else if (this.headerCreated.isPresent() && !this.headerCreated.get().booleanValue()) {
            rewriteInPlace = true;
        }
        return rewriteInPlace;
    }

    void writeHeader(int extra, boolean largeFile, boolean keepDataStart, Formatter fout) throws IOException {
        Vinfo vinfo;
        this.useLongOffset = largeFile;
        this.nonRecordDataSize = 0L;
        this.recsize = 0L;
        this.recStart = Long.MAX_VALUE;
        this.headerCreated = Optional.of(false);
        this.raf.seek(0L);
        this.raf.write(largeFile ? MAGIC_LONG : MAGIC);
        this.raf.writeInt(0);
        List<Dimension> dims = this.ncfile.getDimensions();
        int numdims = dims.size();
        if (numdims == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(10);
            this.raf.writeInt(numdims);
        }
        for (int i = 0; i < numdims; ++i) {
            Dimension dim = dims.get(i);
            if (fout != null) {
                fout.format("  dim %d pos %d%n", i, this.raf.getFilePointer());
            }
            this.writeString(dim.getShortName());
            this.raf.writeInt(dim.isUnlimited() ? 0 : dim.getLength());
            if (!dim.isUnlimited()) continue;
            this.udim = dim;
        }
        this.globalAttsPos = this.raf.getFilePointer();
        this.writeAtts(this.ncfile.getGlobalAttributes(), fout);
        List<Variable> vars = this.ncfile.getVariables();
        for (Variable curVar : vars) {
            if (!curVar.isUnlimited()) continue;
            this.uvars.add(curVar);
        }
        this.writeVars(vars, largeFile, fout);
        if (!keepDataStart) {
            this.dataStart = this.raf.getFilePointer();
            if (extra > 0) {
                this.dataStart += (long)extra;
            }
        }
        long pos = this.dataStart;
        for (Variable var : vars) {
            vinfo = (Vinfo)var.getSPobject();
            if (vinfo.isRecord) continue;
            this.raf.seek(vinfo.begin);
            if (largeFile) {
                this.raf.writeLong(pos);
            } else {
                if (pos > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Variable starting pos=" + pos + " may not exceed " + Integer.MAX_VALUE);
                }
                this.raf.writeInt((int)pos);
            }
            vinfo.begin = pos;
            if (fout != null) {
                fout.format("  %s begin at = %d end= %d%n", var.getFullName(), vinfo.begin, vinfo.begin + vinfo.vsize);
            }
            pos += vinfo.vsize;
            this.nonRecordDataSize = Math.max(this.nonRecordDataSize, vinfo.begin + vinfo.vsize);
        }
        this.recStart = pos;
        for (Variable var : vars) {
            vinfo = (Vinfo)var.getSPobject();
            if (!vinfo.isRecord) continue;
            this.raf.seek(vinfo.begin);
            if (largeFile) {
                this.raf.writeLong(pos);
            } else {
                this.raf.writeInt((int)pos);
            }
            vinfo.begin = pos;
            if (fout != null) {
                fout.format(" %s record begin at = %d%n", var.getFullName(), this.dataStart);
            }
            pos += vinfo.vsize;
            this.recsize += vinfo.vsize;
            this.recStart = Math.min(this.recStart, vinfo.begin);
        }
        if (this.nonRecordDataSize > 0L) {
            this.nonRecordDataSize -= this.dataStart;
        }
        if (this.uvars.isEmpty()) {
            this.recStart = 0L;
        }
        this.headerCreated = Optional.of(true);
    }

    int sizeHeader(boolean largeFile) {
        int size = -1;
        if (!this.headerCreated.isPresent() || this.headerCreated.isPresent() && this.headerCreated.get().booleanValue()) {
            size = 4;
            size += 4;
            size += 8;
            for (Dimension dim : this.ncfile.getDimensions()) {
                size += this.sizeString(dim.getShortName()) + 4;
            }
            size += this.sizeAtts(this.ncfile.getGlobalAttributes());
            size += 8;
            for (Variable var : this.ncfile.getVariables()) {
                size += this.sizeString(var.getShortName());
                size += 4;
                size += 4 * var.getDimensions().size();
                size += this.sizeAtts(var.attributes());
                size += 8;
                size += largeFile ? 8 : 4;
            }
        }
        return size;
    }

    private void writeAtts(Iterable<Attribute> atts, Formatter fout) throws IOException {
        int n = Iterables.size(atts);
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(12);
            this.raf.writeInt(n);
        }
        int count = 0;
        for (Attribute att : atts) {
            if (fout != null) {
                fout.format("***att %d pos= %d%n", count, this.raf.getFilePointer());
            }
            this.writeString(att.getShortName());
            int type = N3header.getType(att.getDataType());
            this.raf.writeInt(type);
            if (type == 2) {
                this.writeStringValues(att);
            } else {
                int nelems = att.getLength();
                this.raf.writeInt(nelems);
                int nbytes = 0;
                for (int j = 0; j < nelems; ++j) {
                    nbytes += this.writeAttributeValue(att.getNumericValue(j));
                }
                this.pad(nbytes, (byte)0);
                if (fout != null) {
                    fout.format(" end write val pos= %d%n", this.raf.getFilePointer());
                }
            }
            if (fout == null) continue;
            fout.format("  %s%n", att);
        }
        ++count;
    }

    private int sizeAtts(Iterable<Attribute> atts) {
        int size = 8;
        for (Attribute att : atts) {
            size += this.sizeString(att.getShortName());
            size += 4;
            int type = N3header.getType(att.getDataType());
            if (type == 2) {
                size += this.sizeStringValues(att);
                continue;
            }
            size += 4;
            int nelems = att.getLength();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.sizeAttributeValue(att.getNumericValue(j));
            }
            size += nbytes;
            size += N3header.padding(nbytes);
        }
        return size;
    }

    private void writeStringValues(Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            this.writeString(att.getStringValue());
        } else {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            this.writeString(values.toString());
        }
    }

    private int sizeStringValues(Attribute att) {
        int size = 0;
        int n = att.getLength();
        if (n == 1) {
            size += this.sizeString(att.getStringValue());
        } else {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            size += this.sizeString(values.toString());
        }
        return size;
    }

    private int writeAttributeValue(Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            this.raf.write(numValue.byteValue());
            return 1;
        }
        if (numValue instanceof Short) {
            this.raf.writeShort(numValue.shortValue());
            return 2;
        }
        if (numValue instanceof Integer) {
            this.raf.writeInt(numValue.intValue());
            return 4;
        }
        if (numValue instanceof Float) {
            this.raf.writeFloat(numValue.floatValue());
            return 4;
        }
        if (numValue instanceof Double) {
            this.raf.writeDouble(numValue.doubleValue());
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private int sizeAttributeValue(Number numValue) {
        if (numValue instanceof Byte) {
            return 1;
        }
        if (numValue instanceof Short) {
            return 2;
        }
        if (numValue instanceof Integer) {
            return 4;
        }
        if (numValue instanceof Float) {
            return 4;
        }
        if (numValue instanceof Double) {
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private void writeVars(List<Variable> vars, boolean largeFile, Formatter fout) throws IOException {
        int n = vars.size();
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(11);
            this.raf.writeInt(n);
        }
        for (Variable var : vars) {
            this.writeString(var.getShortName());
            long vsize = var.getDataType().getSize();
            List<Dimension> dims = var.getDimensions();
            this.raf.writeInt(dims.size());
            for (Dimension dim : dims) {
                int dimIndex = this.findDimensionIndex(this.ncfile, dim);
                this.raf.writeInt(dimIndex);
                if (dim.isUnlimited()) continue;
                vsize *= (long)dim.getLength();
            }
            long unpaddedVsize = vsize;
            vsize += (long)N3header.padding(vsize);
            long varAttsPos = this.raf.getFilePointer();
            this.writeAtts(var.attributes(), fout);
            DataType dtype = var.getDataType();
            int type = N3header.getType(dtype);
            this.raf.writeInt(type);
            int vsizeWrite = vsize < 0xFFFFFFFFL ? (int)vsize : -1;
            this.raf.writeInt(vsizeWrite);
            long pos = this.raf.getFilePointer();
            if (largeFile) {
                this.raf.writeLong(0L);
            } else {
                this.raf.writeInt(0);
            }
            if (this.uvars.size() == 1 && this.uvars.get(0) == var && (dtype == DataType.CHAR || dtype == DataType.BYTE || dtype == DataType.SHORT)) {
                vsize = unpaddedVsize;
            }
            var.setSPobject(new Vinfo(vsize, pos, var.isUnlimited(), varAttsPos));
        }
    }

    private void writeString(String s2) throws IOException {
        byte[] b = s2.getBytes(StandardCharsets.UTF_8);
        this.raf.writeInt(b.length);
        this.raf.write(b);
        this.pad(b.length, (byte)0);
    }

    private int sizeString(String s2) {
        int size = s2.length() + 4;
        return size + N3header.padding(s2.length());
    }

    private int findDimensionIndex(NetcdfFile ncfile, Dimension wantDim) {
        List<Dimension> dims = ncfile.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (!dim.equals(wantDim)) continue;
            return i;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    private void pad(int nbytes, byte fill) throws IOException {
        int pad = N3header.padding(nbytes);
        for (int i = 0; i < pad; ++i) {
            this.raf.write(fill);
        }
    }

    void writeNumrecs() throws IOException {
        this.raf.seek(4L);
        this.raf.writeInt(this.numrecs);
    }

    void setNumrecs(int n) {
        this.numrecs = n;
    }

    synchronized boolean synchNumrecs() throws IOException {
        int n = this.raf.readIntUnbuffered(4L);
        if (n == this.numrecs) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        this.numrecs = n;
        this.udim.setLength(this.numrecs);
        for (Variable uvar : this.uvars) {
            uvar.resetShape();
            uvar.invalidateCache();
        }
        return true;
    }

    void updateAttribute(Variable v2, Attribute att) throws IOException {
        long pos;
        if (v2 == null) {
            pos = this.findAtt(this.globalAttsPos, att.getShortName());
        } else {
            Vinfo vinfo = (Vinfo)v2.getSPobject();
            pos = this.findAtt(vinfo.attsPos, att.getShortName());
        }
        this.raf.seek(pos);
        int type = this.raf.readInt();
        DataType have = this.getDataType(type);
        DataType want = att.getDataType();
        if (want == DataType.STRING) {
            want = DataType.CHAR;
        }
        if (want != have) {
            throw new IllegalArgumentException("Update Attribute must have same type or original = " + (Object)((Object)have) + " att = " + att);
        }
        if (type == 2) {
            String s2 = att.getStringValue();
            int org = this.raf.readInt();
            int size = org + N3header.padding(org);
            int max = Math.min(size, s2.length());
            if (max > org) {
                this.raf.seek(pos + 4L);
                this.raf.writeInt(max);
            }
            byte[] b = new byte[size];
            for (int i = 0; i < max; ++i) {
                b[i] = (byte)s2.charAt(i);
            }
            this.raf.write(b);
        } else {
            int nelems = this.raf.readInt();
            int max = Math.min(nelems, att.getLength());
            for (int j = 0; j < max; ++j) {
                this.writeAttributeValue(att.getNumericValue(j));
            }
        }
    }

    private long findAtt(long start_pos, String want) throws IOException {
        this.raf.seek(start_pos + 4L);
        int natts = this.raf.readInt();
        for (int i = 0; i < natts; ++i) {
            String name = this.readString();
            if (name.equals(want)) {
                return this.raf.getFilePointer();
            }
            int type = this.raf.readInt();
            if (type == 2) {
                this.readString();
                continue;
            }
            int nelems = this.raf.readInt();
            DataType dtype = this.getDataType(type);
            int[] shape = new int[]{nelems};
            Array arr = Array.factory(dtype, shape);
            IndexIterator ii = arr.getIndexIterator();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.readAttributeValue(dtype, ii);
            }
            this.skip(nbytes);
        }
        throw new IllegalArgumentException("no such attribute " + want);
    }

    static class Vinfo {
        long vsize;
        long begin;
        boolean isRecord;
        long attsPos;

        Vinfo(long vsize, long begin, boolean isRecord, long attsPos) {
            this.vsize = vsize;
            this.begin = begin;
            this.isRecord = isRecord;
            this.attsPos = attsPos;
        }
    }
}

