/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil2;

public class TableParser {
    private static Logger logger = LoggerFactory.getLogger(TableParser.class);
    private static final boolean debug = false;
    private List<Field> fields = new ArrayList<Field>();
    private String comment = "#";

    public static List<Record> readTable(String urlString, String format, int maxLines) throws IOException, NumberFormatException {
        InputStream ios;
        if (urlString.startsWith("http:")) {
            URL url = new URL(urlString);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(urlString);
        }
        return TableParser.readTable(ios, format, maxLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Record> readTable(InputStream ios, String format, int maxLines) throws IOException, NumberFormatException {
        List<Record> result;
        try {
            TableParser parser = new TableParser(format);
            result = parser.readAllRecords(ios, maxLines);
        }
        finally {
            ios.close();
        }
        return result;
    }

    public TableParser(String format) throws NumberFormatException {
        int start = 0;
        StringTokenizer stoker = new StringTokenizer(format, " ,");
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            Class type = String.class;
            char last = tok.charAt(tok.length() - 1);
            if (last == 'i') {
                type = Integer.TYPE;
            }
            if (last == 'd') {
                type = Double.TYPE;
            }
            if (last == 'L') {
                type = Long.TYPE;
            }
            if (type != String.class) {
                tok = tok.substring(0, tok.length() - 1);
            }
            int end = Integer.parseInt(tok);
            this.fields.add(new Field(start, end, type));
            start = end;
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Record> readAllRecords(InputStream ios, int maxLines) throws IOException, NumberFormatException {
        String line;
        ArrayList<Record> records = new ArrayList<Record>();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
        int count = 0;
        while ((maxLines < 0 || count < maxLines) && (line = dataIS.readLine()) != null) {
            if (line.startsWith(this.comment) || line.trim().isEmpty()) continue;
            Record r = Record.make(line, this.fields);
            if (r != null) {
                records.add(r);
            }
            ++count;
        }
        return records;
    }

    public Field getField(int fldno) {
        return this.fields.get(fldno);
    }

    public int getNumberOfFields() {
        return this.fields.size();
    }

    public DerivedField addDerivedField(Field from, Transform transform, Class type) {
        DerivedField fld = new DerivedField(from, transform, type);
        this.fields.add(fld);
        return fld;
    }

    public static class Record {
        List<Object> values = new ArrayList<Object>();

        static Record make(String line, List fields) {
            try {
                Record r = new Record();
                for (Object field : fields) {
                    Field f = (Field)field;
                    r.values.add(f.parse(line));
                }
                return r;
            }
            catch (NumberFormatException e) {
                logger.warn("Bad line={}", (Object)line);
                return null;
            }
        }

        public int nfields() {
            return this.values.size();
        }

        public Object get(int k) {
            return this.values.get(k);
        }

        public void toString(Formatter f) {
            for (Object s2 : this.values) {
                f.format(" %s,", s2.toString());
            }
            f.format("%n", new Object[0]);
        }
    }

    public static interface Transform {
        public Object derive(Object var1);
    }

    public static class DerivedField
    extends Field {
        Field from;
        Transform transform;

        DerivedField(Field from, Transform transform, Class type) {
            this.from = from;
            this.transform = transform;
            this.type = type;
        }

        @Override
        protected Object parse(String line, int start, int end) throws NumberFormatException {
            Object org = this.from.parse(line);
            return this.transform.derive(org);
        }
    }

    public static class Field {
        int start;
        int end;
        Class type;
        boolean hasScale;
        float scale;

        Field(int start, int end, Class type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        protected Field() {
        }

        public Object parse(String line) throws NumberFormatException {
            return this.parse(line, this.start, this.end);
        }

        public Object parse(String line, int offset) throws NumberFormatException {
            return this.parse(line, this.start + offset, this.end + offset);
        }

        protected Object parse(String line, int start, int end) throws NumberFormatException {
            String svalue = start >= line.length() ? "" : (end >= line.length() ? line.substring(start) : line.substring(start, end));
            if (this.type == String.class) {
                return svalue;
            }
            try {
                svalue = StringUtil2.remove(svalue, 32);
                boolean isBlank = svalue.trim().isEmpty();
                if (this.type == Double.TYPE) {
                    return isBlank ? 0.0 : new Double(svalue);
                }
                if (this.type == Integer.TYPE) {
                    Integer result = isBlank ? 0 : new Integer(svalue);
                    if (this.hasScale) {
                        return Float.valueOf((float)result.intValue() * this.scale);
                    }
                    return result;
                }
                if (this.type == Long.TYPE) {
                    return isBlank ? 0L : new Long(svalue);
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Bad line={} ", (Object)String.format("  [%d,%d) = <%s> %n", start, end, svalue));
                throw e;
            }
            return null;
        }

        public void setScale(float scale) {
            this.scale = scale;
            this.hasScale = true;
        }
    }
}

