/*
 * Decompiled with CFR 0.152.
 */
package loci.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOTester.class);
    private static final String TAG = "<END>";
    private static final int SIZE = 0x3200000;
    private static final long NUM_DOTS = 80L;
    private static final String ALPHANUM = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";

    public byte[] createData() {
        byte[] data = new byte[0x3200000];
        int middle = (int)((double)(data.length - TAG.length() - 1) * Math.random());
        int left = data.length - middle - TAG.length();
        int rest = middle + TAG.length();
        long middlePercent = 100L * (long)middle / 0x3200000L;
        long leftPercent = 100L * (long)left / 0x3200000L;
        LOGGER.info("Generating data: {} ({}%) alphanumeric + {} ({}%) binary", new Object[]{middle, middlePercent, left, leftPercent});
        long progress = 0L;
        for (int i = 0; i < data.length; ++i) {
            int rnd;
            long p = 80L * (long)i / (long)data.length;
            if (p > progress) {
                LOGGER.info(".");
                progress = p;
            }
            if (i < middle) {
                rnd = (int)((double)ALPHANUM.length() * Math.random());
                data[i] = (byte)ALPHANUM.charAt(rnd);
                continue;
            }
            if (i >= rest) {
                rnd = (int)(256.0 * Math.random());
                data[i] = (byte)rnd;
                continue;
            }
            data[i] = (byte)TAG.charAt(i - middle);
        }
        LOGGER.info("");
        return data;
    }

    public void saveData(String filename, byte[] data) throws IOException {
        LOGGER.info("Saving {}...", (Object)filename);
        FileOutputStream out = new FileOutputStream(filename);
        out.write(data);
        out.close();
    }

    public long testSequential(String filename) throws IOException {
        LOGGER.info("Searching for divider tag sequentially...");
        long start = System.currentTimeMillis();
        RandomAccessInputStream in = new RandomAccessInputStream(filename);
        int matchIndex = 0;
        char matchChar = TAG.charAt(0);
        long inputLen = in.length();
        for (long i = 0L; i < inputLen; ++i) {
            char c = in.readChar();
            if (c == matchChar) {
                if (++matchIndex == TAG.length()) break;
                matchChar = TAG.charAt(matchIndex);
                continue;
            }
            matchIndex = 0;
            matchChar = TAG.charAt(0);
        }
        long offset = in.getFilePointer();
        in.close();
        long end = System.currentTimeMillis();
        LOGGER.info("Search result: {} -- in {} ms", (Object)offset, (Object)(end - start));
        return offset;
    }

    public long testBlock(String filename, int blockSize) throws IOException {
        LOGGER.info("Searching for divider in blocks of {}...", (Object)blockSize);
        long start = System.currentTimeMillis();
        RandomAccessInputStream in = new RandomAccessInputStream(filename);
        long offset = in.findString(blockSize, new String[]{TAG}).length();
        in.close();
        long end = System.currentTimeMillis();
        LOGGER.info("Search result: {} -- in {} ms", (Object)offset, (Object)(end - start));
        return offset;
    }

    public void deleteData(String filename) {
        LOGGER.info("Deleting {}", (Object)filename);
        File f = new File(filename);
        f.delete();
    }

    public void testIO() throws IOException {
        String prefix = "IOTester";
        byte[] data = this.createData();
        String file1 = prefix + "1.tmp";
        String file2 = prefix + "2.tmp";
        String file3 = prefix + "3.tmp";
        String file4 = prefix + "4.tmp";
        String file5 = prefix + "5.tmp";
        this.saveData(file1, data);
        this.saveData(file2, data);
        this.saveData(file3, data);
        this.saveData(file4, data);
        this.saveData(file5, data);
        this.testBlock(file1, 65536);
        this.testBlock(file2, 262144);
        this.testBlock(file3, 524288);
        this.testBlock(file4, 0x100000);
        this.testSequential(file5);
        this.deleteData(file1);
        this.deleteData(file2);
        this.deleteData(file3);
        this.deleteData(file4);
        this.deleteData(file5);
    }

    public static void main(String[] args) throws IOException {
        new IOTester().testIO();
    }
}

