/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.tests.testng.TestTools;
import nl.javadude.assumeng.AssumptionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Listeners(value={AssumptionListener.class})
public class EquivalentPixelsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(EquivalentPixelsTest.class);
    private String src;
    private String check;
    private IFormatReader srcReader;
    private IFormatReader checkReader;

    @Parameters(value={"src", "check"})
    @BeforeClass
    public void init(String src, String check) throws Exception {
        this.src = src;
        this.check = check;
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.srcReader.close();
        this.checkReader.close();
    }

    @Test
    public void setId() throws Exception {
        this.srcReader = new ImageReader();
        this.checkReader = new ImageReader();
        this.srcReader.setId(this.src);
        this.checkReader.setId(this.check);
        AssertJUnit.assertEquals((int)this.srcReader.getSeriesCount(), (int)this.checkReader.getSeriesCount());
        for (int s = 0; s < this.srcReader.getSeriesCount(); ++s) {
            this.srcReader.setSeries(s);
            this.checkReader.setSeries(s);
            AssertJUnit.assertEquals((int)this.srcReader.getSizeX(), (int)this.checkReader.getSizeX());
            AssertJUnit.assertEquals((int)this.srcReader.getSizeY(), (int)this.checkReader.getSizeY());
            AssertJUnit.assertEquals((int)this.srcReader.getSizeC(), (int)this.checkReader.getSizeC());
            AssertJUnit.assertEquals((int)this.srcReader.getSizeZ(), (int)this.checkReader.getSizeZ());
            AssertJUnit.assertEquals((int)this.srcReader.getSizeT(), (int)this.checkReader.getSizeT());
            AssertJUnit.assertEquals((int)this.srcReader.getPixelType(), (int)this.checkReader.getPixelType());
            AssertJUnit.assertEquals((boolean)this.srcReader.isRGB(), (boolean)this.checkReader.isRGB());
            AssertJUnit.assertEquals((String)this.srcReader.getDimensionOrder(), (String)this.checkReader.getDimensionOrder());
        }
    }

    @Test(dependsOnMethods={"setId"})
    public void testEquivalent() throws Exception {
        for (int s = 0; s < this.srcReader.getSeriesCount(); ++s) {
            this.srcReader.setSeries(s);
            this.checkReader.setSeries(s);
            int optimalTileWidth = this.srcReader.getOptimalTileWidth();
            int optimalTileHeight = this.srcReader.getOptimalTileHeight();
            int bpp = FormatTools.getBytesPerPixel((int)this.srcReader.getPixelType());
            boolean flipEndian = bpp > 1 && this.srcReader.isLittleEndian() != this.checkReader.isLittleEndian();
            for (int image = 0; image < this.srcReader.getImageCount(); ++image) {
                LOGGER.info("Reading from series {} image {}", (Object)s, (Object)image);
                int tilesWide = (int)Math.ceil((double)this.srcReader.getSizeX() / (double)optimalTileWidth);
                int tilesHigh = (int)Math.ceil((double)this.srcReader.getSizeY() / (double)optimalTileHeight);
                int y = 0;
                for (int tileX = 0; tileX < tilesWide; ++tileX) {
                    for (int tileY = 0; tileY < tilesHigh; ++tileY) {
                        int x = tileX * optimalTileWidth;
                        y = tileY * optimalTileHeight;
                        int actualTileWidth = Math.min(optimalTileWidth, this.srcReader.getSizeX() - x);
                        int actualTileHeight = Math.min(optimalTileHeight, this.srcReader.getSizeY() - y);
                        LOGGER.info("Reading tile at {}x{}", (Object)x, (Object)y);
                        byte[] srcTile = this.srcReader.openBytes(image, x, y, actualTileWidth, actualTileHeight);
                        byte[] checkTile = this.checkReader.openBytes(image, x, y, actualTileWidth, actualTileHeight);
                        if (flipEndian) {
                            for (int p = 0; p < checkTile.length; p += bpp) {
                                for (int b = 0; b < bpp / 2; ++b) {
                                    byte tmp = checkTile[p + b];
                                    checkTile[p + b] = checkTile[p + (bpp - b - 1)];
                                    checkTile[p + (bpp - b - 1)] = tmp;
                                }
                            }
                        }
                        String srcMD5 = TestTools.md5(srcTile);
                        String checkMD5 = TestTools.md5(checkTile);
                        AssertJUnit.assertEquals((String)srcMD5, (String)checkMD5);
                    }
                }
            }
        }
    }
}

