/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import loci.common.services.ServiceFactory;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.tests.testng.TestTools;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataStore;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class TiffWriterTest {
    private IFormatReader reader;
    private IMetadata metadata;
    private OMEXMLService service;
    private static final String[] COMPRESSION = new String[2];
    private static final Boolean[] BIG_TIFF;

    private TiffWriter initializeWriter(String output, String compression, boolean bigTiff) throws Exception {
        OMEXMLMetadata newMetadata = this.service.createOMEXMLMetadata();
        MetadataConverter.convertMetadata((ome.xml.meta.MetadataRetrieve)this.metadata, (MetadataStore)newMetadata);
        TiffWriter writer = new TiffWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)newMetadata);
        writer.setCompression(compression);
        writer.setWriteSequentially(true);
        writer.setInterleaved(false);
        writer.setBigTiff(bigTiff);
        writer.setId(output);
        return writer;
    }

    private void assertTiles(String output, String compression, int n, int m, boolean bigTiff) throws Exception {
        byte[] tile;
        int x;
        int y;
        int count;
        int h;
        int w;
        TiffWriter writer = this.initializeWriter(output, compression, bigTiff);
        int series = this.reader.getSeriesCount();
        String[][][] tileMD5s = new String[series][][];
        for (int s = 0; s < series; ++s) {
            this.reader.setSeries(s);
            w = this.reader.getSizeX() / n;
            h = this.reader.getSizeY() / m;
            long[] rowPerStrip = new long[]{h};
            count = this.reader.getImageCount();
            tileMD5s[s] = new String[count][m * n];
            for (int k = 0; k < count; ++k) {
                IFD ifd = new IFD();
                ifd.put((Object)322, (Object)w);
                ifd.put((Object)323, (Object)h);
                ifd.put((Object)278, (Object)rowPerStrip);
                for (int i = 0; i < m; ++i) {
                    y = h * i;
                    for (int j = 0; j < n; ++j) {
                        x = w * j;
                        tile = this.reader.openBytes(k, x, y, w, h);
                        tileMD5s[s][k][i * n + j] = TestTools.md5(tile);
                        writer.saveBytes(k, tile, ifd, x, y, w, h);
                    }
                }
            }
        }
        writer.close();
        TiffReader outputReader = new TiffReader();
        outputReader.setId(output);
        for (int s = 0; s < series; ++s) {
            outputReader.setSeries(s);
            count = outputReader.getImageCount();
            h = outputReader.getSizeY() / m;
            w = outputReader.getSizeX() / n;
            for (int k = 0; k < count; ++k) {
                for (int i = 0; i < m; ++i) {
                    y = h * i;
                    for (int j = 0; j < n; ++j) {
                        String writtenDigest = tileMD5s[s][k][i * n + j];
                        x = w * j;
                        tile = outputReader.openBytes(k, x, y, w, h);
                        String readDigest = TestTools.md5(tile);
                        if (writtenDigest.equals(readDigest)) continue;
                        AssertJUnit.fail((String)String.format("Compression:%s MD5:%d;%d;%d;%d;%d; %s != %s", compression, k, x, y, w, h, writtenDigest, readDigest));
                    }
                }
            }
        }
        outputReader.close();
    }

    private void assertUnevenTiles(String output, String compression, int blockWidth, int blockHeight, boolean bigTiff) throws Exception {
        byte[] tile;
        int w;
        int h;
        int y;
        int x;
        int count;
        int diffHeight;
        int diffWidth;
        int m;
        int n;
        int sizeY;
        int sizeX;
        TiffWriter writer = this.initializeWriter(output, compression, bigTiff);
        int series = this.reader.getSeriesCount();
        String[][][] tileMD5s = new String[series][][];
        for (int s = 0; s < series; ++s) {
            this.reader.setSeries(s);
            sizeX = this.reader.getSizeX();
            sizeY = this.reader.getSizeY();
            if (blockWidth <= 0) {
                blockWidth = sizeX;
            }
            if (blockHeight <= 0) {
                blockHeight = sizeY;
            }
            n = sizeX / blockWidth;
            m = sizeY / blockHeight;
            if (n == 0) {
                blockWidth = sizeX;
                n = 1;
            }
            if (m == 0) {
                blockHeight = sizeY;
                m = 1;
            }
            diffWidth = sizeX - n * blockWidth;
            diffHeight = sizeY - m * blockHeight;
            if (diffWidth > 0) {
                ++n;
            }
            if (diffHeight > 0) {
                ++m;
            }
            long[] rowPerStrip = new long[]{blockHeight};
            count = this.reader.getImageCount();
            tileMD5s[s] = new String[count][m * n];
            for (int k = 0; k < count; ++k) {
                x = 0;
                y = 0;
                IFD ifd = new IFD();
                ifd.put((Object)322, (Object)blockWidth);
                ifd.put((Object)323, (Object)blockHeight);
                ifd.put((Object)278, (Object)rowPerStrip);
                for (int i = 0; i < m; ++i) {
                    if (diffHeight > 0 && i == m - 1) {
                        y = sizeY - diffHeight;
                        h = diffHeight;
                    } else {
                        y = blockHeight * i;
                        h = blockHeight;
                    }
                    for (int j = 0; j < n; ++j) {
                        if (diffWidth > 0 && j == n - 1) {
                            x = sizeX - diffWidth;
                            w = diffWidth;
                        } else {
                            x = blockWidth * j;
                            w = blockWidth;
                        }
                        tile = this.reader.openBytes(k, x, y, w, h);
                        tileMD5s[s][k][i * n + j] = TestTools.md5(tile);
                        writer.saveBytes(0, tile, ifd, x, y, w, h);
                    }
                }
            }
        }
        writer.close();
        TiffReader outputReader = new TiffReader();
        outputReader.setId(output);
        for (int s = 0; s < series; ++s) {
            outputReader.setSeries(s);
            count = outputReader.getImageCount();
            for (int k = 0; k < count; ++k) {
                sizeX = outputReader.getSizeX();
                sizeY = outputReader.getSizeY();
                n = sizeX / blockWidth;
                m = sizeY / blockHeight;
                diffWidth = sizeX - n * blockWidth;
                diffHeight = sizeY - m * blockHeight;
                if (diffWidth > 0) {
                    ++n;
                }
                if (diffHeight > 0) {
                    ++m;
                }
                for (int i = 0; i < m; ++i) {
                    if (diffHeight > 0 && i == m - 1) {
                        y = sizeY - diffHeight;
                        h = diffHeight;
                    } else {
                        y = blockHeight * i;
                        h = blockHeight;
                    }
                    for (int j = 0; j < n; ++j) {
                        if (diffWidth > 0 && j == n - 1) {
                            x = sizeX - diffWidth;
                            w = diffWidth;
                        } else {
                            x = blockWidth * j;
                            w = blockWidth;
                        }
                        tile = outputReader.openBytes(k, x, y, w, h);
                        String writtenDigest = tileMD5s[s][k][i * n + j];
                        String readDigest = TestTools.md5(tile);
                        if (writtenDigest.equals(readDigest)) continue;
                        AssertJUnit.fail((String)String.format("Compression:%s MD5:%d;%d;%d;%d;%d; %s != %s", compression, k, x, y, w, h, writtenDigest, readDigest));
                    }
                }
            }
        }
        outputReader.close();
    }

    @Parameters(value={"id"})
    @BeforeClass
    public void parse(String id) throws Exception {
        ServiceFactory factory = new ServiceFactory();
        this.service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        this.metadata = this.service.createOMEXMLMetadata();
        this.reader = new ImageReader();
        this.reader.setMetadataStore((loci.formats.meta.MetadataStore)this.metadata);
        this.reader.setId(id);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.reader.close();
    }

    @Test(enabled=true)
    public void testWriteFullImage() throws Exception {
        for (int i = 0; i < COMPRESSION.length; ++i) {
            for (int j = 0; j < BIG_TIFF.length; ++j) {
                File f = File.createTempFile("testWriteFullImage_" + j + "_" + COMPRESSION[i], ".tiff");
                f.deleteOnExit();
                this.assertTiles(f.getAbsolutePath(), COMPRESSION[i], 1, 1, BIG_TIFF[j]);
            }
        }
    }

    @Test(enabled=true)
    public void testWriteImageFourTiles() throws Exception {
        for (int i = 0; i < COMPRESSION.length; ++i) {
            for (int j = 0; j < BIG_TIFF.length; ++j) {
                File f = File.createTempFile("testWriteImageFourTiles_" + j + "_" + COMPRESSION[i], ".tiff");
                f.deleteOnExit();
                this.assertTiles(f.getAbsolutePath(), COMPRESSION[i], 2, 2, BIG_TIFF[j]);
            }
        }
    }

    @Test(enabled=true)
    public void testWriteImageSplitHorizontal() throws Exception {
        for (int i = 0; i < COMPRESSION.length; ++i) {
            for (int j = 0; j < BIG_TIFF.length; ++j) {
                File f = File.createTempFile("testWriteImageSplitHorizontal_" + j + "_" + COMPRESSION[i], ".tiff");
                f.deleteOnExit();
                this.assertTiles(f.getAbsolutePath(), COMPRESSION[i], 1, 2, BIG_TIFF[j]);
            }
        }
    }

    @Test(enabled=true)
    public void testWriteImageSplitVertical() throws Exception {
        for (int i = 0; i < COMPRESSION.length; ++i) {
            for (int j = 0; j < BIG_TIFF.length; ++j) {
                File f = File.createTempFile("testWriteImageSplitVertical_" + j + "_" + COMPRESSION[i], ".tiff");
                f.deleteOnExit();
                this.assertTiles(f.getAbsolutePath(), COMPRESSION[i], 2, 1, BIG_TIFF[j]);
            }
        }
    }

    @Test(enabled=true)
    public void testWriteUnevenTilesImage128x128Block() throws Exception {
        for (int i = 0; i < COMPRESSION.length; ++i) {
            for (int j = 0; j < BIG_TIFF.length; ++j) {
                File f = File.createTempFile("testWriteUnevenTilesImage128x128Block_" + j + "_" + COMPRESSION[i], ".tiff");
                f.deleteOnExit();
                this.assertUnevenTiles(f.getAbsolutePath(), COMPRESSION[i], 128, 128, BIG_TIFF[j]);
            }
        }
    }

    @Test(enabled=true)
    public void testWriteUnevenTilesImage256x256Block() throws Exception {
        for (int i = 0; i < COMPRESSION.length; ++i) {
            for (int j = 0; j < BIG_TIFF.length; ++j) {
                File f = File.createTempFile("testWriteUnevenTilesImage256x256Block_" + j + "_" + COMPRESSION[i], ".tiff");
                f.deleteOnExit();
                this.assertUnevenTiles(f.getAbsolutePath(), COMPRESSION[i], 256, 256, BIG_TIFF[j]);
            }
        }
    }

    static {
        TiffWriterTest.COMPRESSION[0] = TiffCompression.UNCOMPRESSED.getCodecName();
        TiffWriterTest.COMPRESSION[1] = TiffCompression.JPEG_2000.getCodecName();
        BIG_TIFF = new Boolean[2];
        TiffWriterTest.BIG_TIFF[0] = false;
        TiffWriterTest.BIG_TIFF[1] = true;
    }
}

