/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class SubResolutionTest {
    private String id;
    private IFormatReader reader;

    @Parameters(value={"id"})
    @BeforeClass
    public void init(String id) throws FormatException, IOException {
        this.id = id;
        this.reader = new ImageReader();
        this.reader.setFlattenedResolutions(false);
        this.reader.setId(id);
    }

    @Test
    public void testSubResolutionCount() {
        int seriesCount = this.reader.getSeriesCount();
        AssertJUnit.assertTrue((seriesCount > 0 ? 1 : 0) != 0);
        for (int series = 0; series < seriesCount; ++series) {
            this.reader.setSeries(series);
            int resolutionCount = this.reader.getResolutionCount();
            AssertJUnit.assertTrue((resolutionCount > 0 ? 1 : 0) != 0);
            for (int resolution = 0; resolution < resolutionCount; ++resolution) {
                this.reader.setResolution(resolution);
                AssertJUnit.assertTrue((this.reader.getSizeX() > 0 ? 1 : 0) != 0);
                AssertJUnit.assertTrue((this.reader.getSizeY() > 0 ? 1 : 0) != 0);
            }
        }
    }

    @AfterClass
    public void cleanup() throws IOException {
        this.reader.close();
    }
}

