/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.out;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.formats.FormatTools;

public class Plane {
    public ByteBuffer backingBuffer;
    public boolean rgbPlanar;
    public int rgbChannels;
    public String pixelType;

    public Plane(byte[] buffer, boolean littleEndian, boolean planar, int rgbChannels, String pixelType) {
        this.backingBuffer = ByteBuffer.wrap(buffer);
        this.backingBuffer.order(littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        this.rgbPlanar = planar;
        this.pixelType = pixelType;
        this.rgbChannels = rgbChannels;
    }

    public boolean equals(Plane other) {
        this.backingBuffer.position(0);
        other.backingBuffer.position(0);
        int bytes = FormatTools.getBytesPerPixel((String)this.pixelType);
        boolean fp = FormatTools.isFloatingPoint((int)FormatTools.pixelTypeFromString((String)this.pixelType));
        block6: while (this.backingBuffer.position() < this.backingBuffer.capacity()) {
            int otherPos = this.backingBuffer.position();
            if (this.rgbPlanar != other.rgbPlanar) {
                int channel = -1;
                int pixel = -1;
                int pos = this.backingBuffer.position() / bytes;
                int capacity = this.backingBuffer.capacity();
                if (this.rgbPlanar) {
                    pixel = pos % (capacity / (this.rgbChannels * bytes));
                    channel = pos / (capacity / (this.rgbChannels * bytes));
                } else {
                    channel = pos % this.rgbChannels;
                    pixel = pos / this.rgbChannels;
                }
                otherPos = other.rgbPlanar ? channel * (capacity / this.rgbChannels) + pixel * bytes : (pixel * this.rgbChannels + channel) * bytes;
            }
            if (otherPos >= other.backingBuffer.capacity()) break;
            other.backingBuffer.position(otherPos);
            switch (bytes) {
                case 1: {
                    byte thisB = this.backingBuffer.get();
                    byte otherB = other.backingBuffer.get();
                    if (thisB == otherB) break;
                    if (!this.pixelType.equals(other.pixelType)) {
                        if ((byte)(thisB - 128) == otherB) break;
                        return false;
                    }
                    return false;
                }
                case 2: {
                    short thisS = this.backingBuffer.getShort();
                    short otherS = other.backingBuffer.getShort();
                    if (thisS == otherS) break;
                    if (!this.pixelType.equals(other.pixelType)) {
                        if ((short)(thisS - 32768) == otherS) break;
                        return false;
                    }
                    return false;
                }
                case 4: {
                    int otherI;
                    int thisI;
                    float otherF;
                    float thisF;
                    if (!(fp ? (double)Math.abs((thisF = this.backingBuffer.getFloat()) - (otherF = other.backingBuffer.getFloat())) > 1.0E-6 : (thisI = this.backingBuffer.getInt()) != (otherI = other.backingBuffer.getInt()))) continue block6;
                    return false;
                }
                case 8: {
                    long otherL;
                    if (fp) {
                        double otherD;
                        double thisD = this.backingBuffer.getDouble();
                        if (!(Math.abs(thisD - (otherD = other.backingBuffer.getDouble())) > 1.0E-6)) continue block6;
                        return false;
                    }
                    long thisL = this.backingBuffer.getLong();
                    if (thisL == (otherL = other.backingBuffer.getLong())) break;
                    return false;
                }
            }
        }
        return true;
    }
}

