/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.File;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.TiffWriter;
import loci.formats.tiff.IFD;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TiffTileReadingTest {
    private static final int TILE_SIZE = 2;
    private File file;
    private ImageReader reader;

    @BeforeClass
    public void setUp() throws Exception {
        this.file = File.createTempFile("tileTest", ".tiff");
        this.writeFile(4, 4);
        this.reader = new ImageReader();
        this.reader.setId(this.file.getAbsolutePath());
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.reader.close();
        this.file.delete();
    }

    @Test
    public void testPixelByPixel() throws FormatException, IOException {
        for (int y = 0; y < this.reader.getSizeY(); ++y) {
            for (int x = 0; x < this.reader.getSizeX(); ++x) {
                byte[] pixel = this.reader.openBytes(0, x, y, 1, 1);
                int xp = x % 2;
                int yp = y % 2;
                AssertJUnit.assertEquals((byte)pixel[0], (byte)this.getValue(x - xp, yp * 2 + xp));
            }
        }
    }

    @Test
    public void testOnTileBoundaries() throws FormatException, IOException {
        for (int y = 0; y < this.reader.getSizeY(); y += 2) {
            for (int x = 0; x < this.reader.getSizeX(); x += 2) {
                byte[] tile = this.reader.openBytes(0, x, y, 2, 2);
                for (int q = 0; q < tile.length; ++q) {
                    AssertJUnit.assertEquals((byte)tile[q], (byte)this.getValue(x, q));
                }
            }
        }
    }

    @Test
    public void testOffTileBoundaries() throws FormatException, IOException {
        for (int y = 0; y <= this.reader.getSizeY() - 2; ++y) {
            for (int x = 0; x <= this.reader.getSizeX() - 2; ++x) {
                byte[] tile = this.reader.openBytes(0, x, y, 2, 2);
                for (int q = 0; q < tile.length; ++q) {
                    AssertJUnit.assertEquals((byte)tile[q], (byte)this.getValue(x, q));
                }
            }
        }
    }

    private void writeFile(int width, int height) throws FormatException, IOException {
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        this.populateImage(meta, 0, width, height, 1, false);
        TiffWriter writer = new TiffWriter();
        writer.setWriteSequentially(true);
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        writer.setId(this.file.getAbsolutePath());
        IFD ifd = new IFD();
        ifd.put((Object)322, (Object)2);
        ifd.put((Object)323, (Object)2);
        byte[] tile = new byte[4];
        for (int yy = 0; yy < height; yy += 2) {
            for (int xx = 0; xx < width; xx += 2) {
                for (int q = 0; q < tile.length; ++q) {
                    tile[q] = this.getValue(xx, q);
                }
                writer.saveBytes(0, tile, ifd, xx, yy, 2, 2);
            }
        }
        writer.close();
    }

    private byte getValue(int x, int tilePos) {
        int v = x + tilePos % 2;
        return (byte)(v & 0xFF);
    }

    private void populateImage(IMetadata meta, int p, int width, int height, int planes, boolean bigEndian) {
        meta.setImageID("Image:" + p, p);
        meta.setPixelsID("Pixels:" + p, p);
        meta.setPixelsDimensionOrder(DimensionOrder.XYZCT, p);
        meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(width)), p);
        meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(height)), p);
        meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(planes)), p);
        meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), p);
        meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1)), p);
        meta.setPixelsType(PixelType.UINT8, p);
        meta.setPixelsBigEndian(Boolean.valueOf(bigEndian), p);
        meta.setChannelID("Channel:" + p + ":0", p, 0);
        meta.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), p, 0);
    }
}

