/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URL;
import java.nio.file.Files;

public class ExampleSuite {
    public static void execute(String name, String[] args) throws Exception {
        System.out.println("Executing " + name);
        Class<?> c = Class.forName(name);
        Object[] passedArgs = new Object[]{args};
        c.getMethod("main", args.getClass()).invoke(null, passedArgs);
        System.out.println("Success");
    }

    public static void main(String[] args) throws Exception {
        URL resource = ExampleSuite.class.getResource("test.fake");
        URL overlappedResource = ExampleSuite.class.getResource("test&sizeX=1024&sizeY=1024.fake");
        URL pyramidResource = ExampleSuite.class.getResource("test&resolutions=4.fake");
        File inputFile = new File(resource.toURI());
        File overlappedInputFile = new File(overlappedResource.toURI());
        File pyramidFile = new File(pyramidResource.toURI());
        File parentDir = inputFile.getParentFile();
        File convertedFile = new File(parentDir, "converted.ome.tiff");
        File exportFile = new File(parentDir, "export.ome.tiff");
        File exportSPWFile = new File(parentDir, "exportSPW.ome.tiff");
        File simpleTiledFile = new File(parentDir, "simpleTiledFile.ome.tiff");
        File tiledFile = new File(parentDir, "tiledFile.ome.tiff");
        File tiledFile2 = new File(parentDir, "tiledFile2.ome.tiff");
        File overlappedTiledFile = new File(parentDir, "overlappedTiledFile.ome.tiff");
        File overlappedTiledFile2 = new File(parentDir, "overlappedTiledFile2.ome.tiff");
        File inMemoryFile = new File(parentDir, inputFile.getName() + ".ome.tif");
        File orthogonalFile = new File(parentDir, "orthogonal.ome.tiff");
        File pyramidOutputFile = new File(parentDir, "generatedPyramid.ome.tiff");
        Files.deleteIfExists(convertedFile.toPath());
        Files.deleteIfExists(exportFile.toPath());
        Files.deleteIfExists(exportSPWFile.toPath());
        Files.deleteIfExists(simpleTiledFile.toPath());
        Files.deleteIfExists(tiledFile.toPath());
        Files.deleteIfExists(tiledFile2.toPath());
        Files.deleteIfExists(overlappedTiledFile.toPath());
        Files.deleteIfExists(overlappedTiledFile2.toPath());
        Files.deleteIfExists(inMemoryFile.toPath());
        Files.deleteIfExists(orthogonalFile.toPath());
        Files.deleteIfExists(pyramidOutputFile.toPath());
        ExampleSuite.execute("ReadPhysicalSize", new String[]{inputFile.getAbsolutePath()});
        ExampleSuite.execute("FileConvert", new String[]{inputFile.getAbsolutePath(), convertedFile.getAbsolutePath()});
        ExampleSuite.execute("FileExport", new String[]{exportFile.getAbsolutePath()});
        ExampleSuite.execute("FileExportSPW", new String[]{exportSPWFile.getAbsolutePath()});
        ExampleSuite.execute("SimpleTiledWriter", new String[]{inputFile.getAbsolutePath(), simpleTiledFile.getAbsolutePath(), "256", "256"});
        ExampleSuite.execute("TiledReaderWriter", new String[]{inputFile.getAbsolutePath(), tiledFile.getAbsolutePath(), "256", "256"});
        ExampleSuite.execute("TiledReaderWriter", new String[]{inputFile.getAbsolutePath(), tiledFile2.getAbsolutePath(), "256", "128"});
        ExampleSuite.execute("OverlappedTiledWriter", new String[]{overlappedInputFile.getAbsolutePath(), overlappedTiledFile.getAbsolutePath(), "96", "96"});
        ExampleSuite.execute("OverlappedTiledWriter", new String[]{overlappedInputFile.getAbsolutePath(), overlappedTiledFile2.getAbsolutePath(), "192", "96"});
        ExampleSuite.execute("ReadWriteInMemory", new String[]{inputFile.getAbsolutePath(), inMemoryFile.getAbsolutePath()});
        ExampleSuite.execute("OrthogonalReader", new String[]{"--input", inputFile.getAbsolutePath(), "--output", orthogonalFile.getAbsolutePath()});
        ExampleSuite.execute("SubResolutionExample", new String[]{pyramidFile.getAbsolutePath()});
        ExampleSuite.execute("GeneratePyramidResolutions", new String[]{overlappedInputFile.getAbsolutePath(), "2", "4", pyramidOutputFile.getAbsolutePath()});
    }
}

