/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import java.io.File;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;

public class LibraryEntry
implements Comparable<Object> {
    public static final String MISSING_VERSION_CODE = "!";
    private static final String PRESENT = "";
    private static final String MISSING = "<font color=\"7f7f7f\"><i>";
    protected String name;
    protected String type;
    protected String libClass;
    protected String url;
    protected String license;
    protected String notes;
    protected String status;
    protected String version;
    protected String path;

    public LibraryEntry(PrintWriter log, HashMap<String, String> props) {
        this(log, props.get("name"), props.get("type"), props.get("class"), props.get("version"), props.get("url"), props.get("license"), props.get("notes"));
    }

    public LibraryEntry(PrintWriter log, String name, String type, String libClass, String version, String url, String license, String notes) {
        this.name = name;
        this.type = type;
        this.libClass = libClass;
        this.url = url;
        this.license = license;
        this.notes = notes;
        try {
            Class<?> c = Class.forName(libClass);
            if (version == null) {
                Package p;
                version = PRESENT;
                if (c != null && (p = c.getPackage()) != null) {
                    String pVendor = p.getImplementationVendor();
                    String pVersion = p.getImplementationVersion();
                    if (pVendor != null && pVersion != null) {
                        version = pVersion + " (" + pVendor + ")";
                    } else if (pVersion != null) {
                        version = pVersion;
                    } else if (pVendor != null) {
                        version = pVendor;
                    }
                }
            } else if (version.equals(MISSING_VERSION_CODE)) {
                version = null;
                throw new ClassNotFoundException();
            }
            this.version = version;
            String className = libClass.substring(libClass.lastIndexOf(".") + 1);
            this.path = c.getResource(className + ".class").toString();
            this.path = this.path.replaceAll("^jar:", PRESENT);
            this.path = this.path.replaceAll("^file:", PRESENT);
            this.path = this.path.replaceAll("^/*/", "/");
            this.path = this.path.replaceAll("^/([A-Z]:)", "$1");
            this.path = this.path.replaceAll("!.*", PRESENT);
            this.path = URLDecoder.decode(this.path, "UTF-8");
            String slash = File.separator;
            if (slash.equals("\\")) {
                slash = "\\\\";
            }
            this.path = this.path.replaceAll("/", slash);
            log.println("Found library " + name + ":");
            if (!PRESENT.equals(version)) {
                log.println("    Version = " + version);
            }
            log.println("    Path = " + this.path);
        }
        catch (Throwable t2) {
            if (t2 instanceof ClassNotFoundException) {
                log.println("No library " + name + ".");
            }
            log.println("Error communicating with library " + name + ":");
            t2.printStackTrace(log);
        }
        this.status = version == null ? "Missing" : "Installed";
    }

    @Override
    public int compareTo(Object o) {
        LibraryEntry entry = (LibraryEntry)o;
        return this.name.compareTo(entry.name);
    }

    public String toString() {
        String markup = this.version == null ? MISSING : PRESENT;
        return "<html>" + markup + this.name;
    }
}

