/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ImaconReader
extends BaseTiffReader {
    private static final int CREATOR_TAG = 34377;
    private static final int XML_TAG = 50457;
    private static final int PIXELS_TAG = 46275;
    private String experimenterName;
    private String creationDate;
    private String imageName;

    public ImaconReader() {
        super("Imacon", new String[]{"fff"});
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey((Object)50457);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.experimenterName = null;
            this.creationDate = null;
            this.imageName = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        this.tiffParser.getSamples((IFD)this.ifds.get(this.getSeries()), buf, x, y, (long)w, (long)h);
        return buf;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        String[] creationInfo;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        this.core.clear();
        for (int i = 0; i < this.ifds.size(); ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add((Object)ms);
            ms.imageCount = 1;
            IFD ifd = (IFD)this.ifds.get(i);
            ifd.remove((Object)46275);
            this.tiffParser.fillInIFD(ifd);
            PhotoInterp photo = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            boolean bl = ms.rgb = samples > 1 || photo == PhotoInterp.RGB || photo == PhotoInterp.CFA_ARRAY;
            if (photo == PhotoInterp.CFA_ARRAY) {
                samples = 3;
            }
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeC = this.isRGB() ? samples : 1;
            ms.sizeT = 1;
            ms.pixelType = ifd.getPixelType();
            ms.indexed = photo == PhotoInterp.RGB_PALETTE;
            ms.dimensionOrder = "XYCZT";
            ms.interleaved = false;
        }
        IFD firstIFD = (IFD)this.ifds.get(0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String xml = firstIFD.getIFDTextValue(50457).trim();
            xml = xml.substring(xml.indexOf(60));
            XMLTools.parseXML((String)xml, (DefaultHandler)((Object)new ImaconHandler()));
        }
        if ((creationInfo = firstIFD.getIFDTextValue(34377).split("\n")).length > 4) {
            this.experimenterName = creationInfo[4].trim();
        }
        if (creationInfo.length > 6) {
            this.imageName = creationInfo[6].trim();
        }
        if (creationInfo.length > 8) {
            this.creationDate = creationInfo[8].trim();
        }
        if (creationInfo.length > 10) {
            this.creationDate = this.creationDate + " " + creationInfo[10].trim();
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        if (this.creationDate != null) {
            this.creationDate = DateTools.formatDate((String)this.creationDate, (String)"yyyyMMdd HHmmSSZ");
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            String name = this.imageName;
            name = this.imageName.length() == 0 ? "#" + (i + 1) : name + " #" + (i + 1);
            store.setImageName(name, i);
            if (this.creationDate == null) continue;
            store.setImageAcquisitionDate(new Timestamp(this.creationDate), i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int nameSpace;
            if (this.experimenterName == null) {
                this.experimenterName = "";
            }
            String firstName = (nameSpace = this.experimenterName.indexOf(32)) == -1 ? "" : this.experimenterName.substring(0, nameSpace);
            String lastName = nameSpace == -1 ? this.experimenterName : this.experimenterName.substring(nameSpace + 1);
            String experimenter = MetadataTools.createLSID((String)"Experimenter", (int[])new int[]{0});
            store.setExperimenterID(experimenter, 0);
            store.setExperimenterFirstName(firstName, 0);
            store.setExperimenterLastName(lastName, 0);
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                store.setImageExperimenterRef(experimenter, i);
            }
        }
    }

    class ImaconHandler
    extends BaseHandler {
        private String key;
        private String value;
        private String qName;

        ImaconHandler() {
        }

        public void characters(char[] data, int start, int len) {
            if (this.qName.equals("key")) {
                this.key = new String(data, start, len);
                this.value = null;
            } else {
                this.value = new String(data, start, len);
            }
            if (this.key != null && this.value != null) {
                ImaconReader.this.addGlobalMeta(this.key, this.value);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.qName = qName;
        }
    }
}

