/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.util.ArrayList;
import java.util.List;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSCollectionXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSImageXmlDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XlifDocument
extends LMSImageXmlDocument {
    LMSFileReader.ImageFormat imageFormat;
    List<String> imagePaths = new ArrayList<String>();

    public XlifDocument(String filepath, LMSCollectionXmlDocument parent) {
        super(filepath, parent);
        this.initImagePaths();
        this.imageFormat = this.checkImageFormat();
    }

    public LMSFileReader.ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public List<String> getImagePaths() {
        return this.imagePaths;
    }

    public String getName() {
        return this.getAttr(this.xPath("//Element").item(0), "Name");
    }

    public Node getElementNode() {
        return this.xPath("//Element").item(0);
    }

    @Override
    public Node getImageNode() {
        for (int i = 0; i < this.doc.getDocumentElement().getChildNodes().getLength(); ++i) {
            Node child = this.doc.getDocumentElement().getChildNodes().item(i);
            if (!child.getNodeName().equals("Element")) continue;
            for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                Node elementChild = child.getChildNodes().item(k);
                if (!elementChild.getNodeName().equals("Data")) continue;
                for (int m = 0; m < elementChild.getChildNodes().getLength(); ++m) {
                    Node dataChild = elementChild.getChildNodes().item(m);
                    if (!dataChild.getNodeName().equals("Image")) continue;
                    return dataChild;
                }
            }
        }
        return null;
    }

    @Override
    public String getImageName() {
        return this.getAttr(this.xPath("//Element").item(0), "Name");
    }

    public int getTileCount() {
        NodeList dimDescs = this.xPath("//DimensionDescription");
        for (int i = 0; i < dimDescs.getLength(); ++i) {
            if (!this.getAttr(dimDescs.item(i), "DimID").equals("10")) continue;
            return Integer.parseInt(this.getAttr(dimDescs.item(i), "NumberOfElements"));
        }
        return 1;
    }

    private LMSFileReader.ImageFormat checkImageFormat() {
        for (String path : this.imagePaths) {
            if (path.endsWith("tif") || path.endsWith("tiff")) {
                return LMSFileReader.ImageFormat.TIF;
            }
            if (path.endsWith("bmp")) {
                return LMSFileReader.ImageFormat.BMP;
            }
            if (path.endsWith("jpeg") || path.endsWith("jpg")) {
                return LMSFileReader.ImageFormat.JPEG;
            }
            if (path.endsWith("png")) {
                return LMSFileReader.ImageFormat.PNG;
            }
            if (!path.endsWith("lof")) continue;
            return LMSFileReader.ImageFormat.LOF;
        }
        return LMSFileReader.ImageFormat.UNKNOWN;
    }

    private void initImagePaths() {
        NodeList references = this.xPath("//Frame");
        if (references.getLength() == 0) {
            references = this.xPath("//Block");
        }
        LOGGER.info("References Found: " + references.getLength());
        for (int i = 0; i < references.getLength(); ++i) {
            String path = this.parseFilePath(this.getAttr(references.item(i), "File").toLowerCase());
            String correctedPath = XlifDocument.fileExists(path);
            this.imagePaths.add(correctedPath);
        }
    }

    public void printXlifInfo() {
        String name = this.getAttr(this.xPath("//Element").item(0), "Name");
        LOGGER.info("---- Image name: " + name + ", references: " + this.imagePaths.size() + ", image format: " + (Object)((Object)this.imageFormat) + " ----");
        LOGGER.info("path: " + this.filepath);
    }

    public boolean isValid() {
        return this.imagePaths.size() > 0;
    }
}

