/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.LIPixelFormat;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Timestamp;

public class LiFlimReader
extends FormatReader {
    public static final String INFO_TABLE = "FLIMIMAGE: INFO";
    public static final String LAYOUT_TABLE = "FLIMIMAGE: LAYOUT";
    public static final String BACKGROUND_TABLE = "FLIMIMAGE: BACKGROUND";
    public static final String VERSION_KEY = "version";
    public static final String COMPRESSION_KEY = "compression";
    public static final String DATATYPE_KEY = "datatype";
    public static final String PACKING_KEY = "packing";
    public static final String C_KEY = "channels";
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";
    public static final String Z_KEY = "z";
    public static final String P_KEY = "phases";
    public static final String F_KEY = "frequencies";
    public static final String T_KEY = "timestamps";
    public static final String DarkImage_KEY = "hasDarkImage";
    public static final String TIMESTAMP_KEY = "FLIMIMAGE: TIMESTAMPS - t";
    public static final String NUMBEROFFRAMES_KEY = "numberOfFrames";
    public static final String NUMBEROFDARKIMAGES_KEY = "nrOfDarkImages";
    public static final String PIXELFORMAT_KEY = "pixelFormat";
    public static final String[] KNOWN_VERSIONS = new String[]{"1.0", "2.0"};
    public static final String COMPRESSION_NONE = "0";
    public static final String COMPRESSION_GZIP = "1";
    public static final String DATATYPE_UINT8 = "UINT8";
    public static final String DATATYPE_INT8 = "INT8";
    public static final String DATATYPE_UINT16 = "UINT16";
    public static final String DATATYPE_INT16 = "INT16";
    public static final String DATATYPE_UINT32 = "UINT32";
    public static final String DATATYPE_INT32 = "INT32";
    public static final String DATATYPE_REAL32 = "REAL32";
    public static final String DATATYPE_REAL64 = "REAL64";
    public static final String DATATYPE_UINT12 = "UINT12";
    private long dataOffset;
    private IniList ini;
    private String version;
    private String compression;
    private String datatype;
    private String packing;
    private String channels;
    private String xLen;
    private String yLen;
    private String zLen;
    private String phases;
    private String frequencies;
    private String timestamps;
    private String DarkImage;
    private String backgroundDatatype;
    private String backgroundX;
    private String backgroundY;
    private String backgroundC;
    private String backgroundZ;
    private String backgroundT;
    private String backgroundP;
    private String backgroundF;
    private int numRegions = 0;
    private Map<Integer, ROI> rois;
    private Map<Integer, String> stampValues;
    private Double exposureTime;
    private Unit<Time> exposureTimeUnit = UNITS.SECOND;
    private boolean gzip;
    private DataInputStream gz;
    private int gzPos;
    private int gzSeries;
    private boolean TypeUINT12;
    private DataInputStream UINT12stream;
    private int UINT12streamPos;
    private int UINT12streamSeries;

    public LiFlimReader() {
        super("LI-FLIM", "fli");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int bytesPerPlane = FormatTools.getPlaneSize((IFormatReader)this);
        if (this.gzip) {
            this.prepareGZipStream(no);
            byte[] bytes = new byte[bytesPerPlane];
            try {
                this.gz.readFully(bytes);
            }
            catch (EOFException e) {
                LOGGER.debug("Could not read full plane", (Throwable)e);
            }
            RandomAccessInputStream s = new RandomAccessInputStream(bytes);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        } else if (this.TypeUINT12) {
            this.prepareUINT12Stream(no);
            bytesPerPlane = bytesPerPlane * 3 / 4;
            byte[] bytes = new byte[bytesPerPlane];
            try {
                this.UINT12stream.readFully(bytes);
            }
            catch (EOFException e) {
                LOGGER.debug("Could not read full 12-bit plane", (Throwable)e);
            }
            byte[] returnArray = new byte[]{};
            returnArray = this.packing.equals("msb") ? LiFlimReader.convert12to16MSB(bytes) : LiFlimReader.convert12to16LSB(bytes);
            RandomAccessInputStream s = new RandomAccessInputStream(returnArray);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        } else {
            this.in.seek(this.dataOffset + (long)bytesPerPlane * (long)no);
            int thisSeries = this.getSeries();
            for (int i = 0; i < thisSeries; ++i) {
                this.setSeries(i);
                this.in.skipBytes((long)this.getImageCount() * (long)FormatTools.getPlaneSize((IFormatReader)this));
            }
            this.setSeries(thisSeries);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataOffset = 0L;
            this.ini = null;
            this.gzip = false;
            if (this.gz != null) {
                this.gz.close();
            }
            this.gz = null;
            this.gzPos = 0;
            this.gzSeries = 0;
            this.version = null;
            this.compression = null;
            this.datatype = null;
            this.packing = null;
            if (this.UINT12stream != null) {
                this.UINT12stream.close();
            }
            this.UINT12stream = null;
            this.UINT12streamPos = 0;
            this.UINT12streamSeries = 0;
            this.channels = null;
            this.xLen = null;
            this.yLen = null;
            this.zLen = null;
            this.phases = null;
            this.frequencies = null;
            this.timestamps = null;
            this.backgroundDatatype = null;
            this.backgroundX = null;
            this.backgroundY = null;
            this.backgroundC = null;
            this.backgroundZ = null;
            this.backgroundT = null;
            this.backgroundP = null;
            this.backgroundF = null;
            this.numRegions = 0;
            this.rois = null;
            this.stampValues = null;
            this.exposureTime = null;
            this.exposureTimeUnit = UNITS.SECOND;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.info("Parsing header");
        this.in = new RandomAccessInputStream(id);
        this.parseHeader();
        LOGGER.info("Parsing metadata");
        this.version = this.getVersion();
        this.initOriginalMetadata();
        this.initCoreMetadata();
        this.initOMEMetadata();
    }

    private String getVersion() {
        HashMap map = this.ini.flattenIntoHashMap();
        for (String string : map.keySet()) {
            if (!string.contains(VERSION_KEY)) continue;
            return (String)map.get(string);
        }
        return "1.0";
    }

    private void parseHeader() throws IOException {
        String headerData = this.in.findString(new String[]{"{END}"});
        this.dataOffset = this.in.getFilePointer();
        IniParser parser = new IniParser();
        this.ini = parser.parseINI(new BufferedReader(new StringReader(headerData)));
    }

    private void initOriginalMetadata() {
        MetadataLevel level;
        this.rois = new HashMap<Integer, ROI>();
        this.stampValues = new HashMap<Integer, String>();
        LOGGER.info("Fli file version: " + this.version);
        if (this.version.equals("1.0")) {
            IniTable layoutTable = this.ini.getTable(LAYOUT_TABLE);
            this.datatype = (String)layoutTable.get((Object)DATATYPE_KEY);
            this.packing = (String)layoutTable.get((Object)PACKING_KEY);
            LOGGER.info("packing: " + this.packing);
            this.channels = (String)layoutTable.get((Object)C_KEY);
            this.xLen = (String)layoutTable.get((Object)X_KEY);
            this.yLen = (String)layoutTable.get((Object)Y_KEY);
            this.zLen = (String)layoutTable.get((Object)Z_KEY);
            this.phases = (String)layoutTable.get((Object)P_KEY);
            this.frequencies = (String)layoutTable.get((Object)F_KEY);
            this.timestamps = (String)layoutTable.get((Object)T_KEY);
            this.DarkImage = (String)layoutTable.get((Object)DarkImage_KEY);
            IniTable infoTable = this.ini.getTable(INFO_TABLE);
            this.compression = (String)infoTable.get((Object)COMPRESSION_KEY);
        } else if (this.version.equals("2.0")) {
            IniTable baseTable = this.ini.getTable("DEFAULT_HEADER");
            this.datatype = (String)baseTable.get((Object)PIXELFORMAT_KEY);
            this.packing = LIPixelFormat.getPacking(this.datatype);
            LOGGER.info("packing: " + this.packing);
            this.channels = COMPRESSION_GZIP;
            this.xLen = (String)baseTable.get((Object)X_KEY);
            this.yLen = (String)baseTable.get((Object)Y_KEY);
            this.zLen = (String)baseTable.get((Object)Z_KEY);
            this.phases = COMPRESSION_GZIP;
            this.frequencies = COMPRESSION_GZIP;
            this.timestamps = (String)baseTable.get((Object)NUMBEROFFRAMES_KEY);
            this.DarkImage = (String)baseTable.get((Object)NUMBEROFDARKIMAGES_KEY);
            this.compression = COMPRESSION_NONE;
        }
        IniTable backgroundTable = this.ini.getTable(BACKGROUND_TABLE);
        if (backgroundTable != null) {
            this.backgroundDatatype = (String)backgroundTable.get((Object)DATATYPE_KEY);
            this.backgroundC = (String)backgroundTable.get((Object)C_KEY);
            this.backgroundX = (String)backgroundTable.get((Object)X_KEY);
            this.backgroundY = (String)backgroundTable.get((Object)Y_KEY);
            this.backgroundZ = (String)backgroundTable.get((Object)Z_KEY);
            this.backgroundT = (String)backgroundTable.get((Object)T_KEY);
            this.backgroundP = (String)backgroundTable.get((Object)P_KEY);
            this.backgroundF = (String)backgroundTable.get((Object)F_KEY);
        }
        if ((level = this.getMetadataOptions().getMetadataLevel()) != MetadataLevel.MINIMUM) {
            for (IniTable table : this.ini) {
                String name = (String)table.get((Object)"header");
                for (String key : table.keySet()) {
                    if (key.equals("header")) continue;
                    String value = (String)table.get((Object)key);
                    String metaKey = name + " - " + key;
                    this.addGlobalMeta(metaKey, value);
                    if (metaKey.startsWith(TIMESTAMP_KEY)) {
                        Integer index = Integer.parseInt(metaKey.replaceAll(TIMESTAMP_KEY, ""));
                        this.stampValues.put(index, value);
                        continue;
                    }
                    if (metaKey.equals("ROI: INFO - numregions")) {
                        this.numRegions = Integer.parseInt(value);
                        continue;
                    }
                    if (metaKey.startsWith("ROI: ROI") && level != MetadataLevel.NO_OVERLAYS) {
                        int end;
                        int start = metaKey.lastIndexOf("ROI") + 3;
                        Integer index = Integer.parseInt(metaKey.substring(start, end = metaKey.indexOf(" ", start)));
                        ROI roi = this.rois.get(index);
                        if (roi == null) {
                            roi = new ROI();
                        }
                        if (metaKey.endsWith("name")) {
                            roi.name = value;
                        } else if (metaKey.indexOf(" - p") >= 0) {
                            String p = metaKey.substring(metaKey.indexOf(" - p") + 4);
                            roi.points.put(Integer.parseInt(p), value.replaceAll(" ", ","));
                        }
                        this.rois.put(index, roi);
                        continue;
                    }
                    if (!metaKey.equals("ExposureTime")) continue;
                    int space = value.indexOf(32);
                    double expTime = Double.parseDouble(value.substring(0, space));
                    String units = value.substring(space + 1).toLowerCase();
                    this.exposureTimeUnit = units.equals("ms") ? UNITS.MILLISECOND : UNITS.SECOND;
                    this.exposureTime = expTime;
                }
            }
        }
    }

    private void initCoreMetadata() throws FormatException {
        if (DataTools.indexOf((Object[])KNOWN_VERSIONS, (Object)this.version) < 0) {
            LOGGER.warn("Unknown LI-FLIM version: {}", (Object)this.version);
        }
        if (COMPRESSION_NONE.equals(this.compression)) {
            this.gzip = false;
        } else if (COMPRESSION_GZIP.equals(this.compression)) {
            this.gzip = true;
        } else {
            throw new UnsupportedCompressionException("Unknown compression type: " + this.compression);
        }
        int sizeP = Integer.parseInt(this.phases);
        int sizeF = Integer.parseInt(this.frequencies);
        int p = this.backgroundP == null ? 1 : Integer.parseInt(this.backgroundP);
        int f = this.backgroundF == null ? 1 : Integer.parseInt(this.backgroundF);
        CoreMetadata ms = (CoreMetadata)this.core.get(0);
        ms.sizeX = Integer.parseInt(this.xLen);
        ms.sizeY = Integer.parseInt(this.yLen);
        ms.sizeZ = Integer.parseInt(this.zLen) * sizeF;
        ms.sizeC = Integer.parseInt(this.channels);
        ms.sizeT = Integer.parseInt(this.timestamps) * sizeP;
        ms.imageCount = this.getSizeZ() * this.getSizeT();
        ms.rgb = this.getSizeC() > 1;
        ms.indexed = false;
        ms.dimensionOrder = "XYCZT";
        ms.pixelType = this.getPixelTypeFromString(this.datatype);
        ms.littleEndian = true;
        ms.interleaved = true;
        ms.falseColor = false;
        if (this.TypeUINT12) {
            ms.bitsPerPixel = 12;
        }
        ms.moduloZ.type = "Frequency";
        ms.moduloZ.step = (double)ms.sizeZ / (double)sizeF;
        ms.moduloZ.start = 0.0;
        ms.moduloZ.end = ms.sizeZ - 1;
        ms.moduloT.type = "Phase";
        ms.moduloT.step = (double)ms.sizeT / (double)sizeP;
        ms.moduloT.start = 0.0;
        ms.moduloT.end = ms.sizeT - 1;
        if (this.backgroundX != null) {
            ms = new CoreMetadata();
            ms.sizeX = Integer.parseInt(this.backgroundX);
            ms.sizeY = Integer.parseInt(this.backgroundY);
            ms.sizeZ = Integer.parseInt(this.backgroundZ) * f;
            ms.sizeC = Integer.parseInt(this.backgroundC);
            ms.sizeT = Integer.parseInt(this.backgroundT) * p;
            ms.imageCount = ms.sizeZ * ms.sizeT;
            ms.rgb = ms.sizeC > 1;
            ms.indexed = false;
            ms.dimensionOrder = "XYCZT";
            ms.pixelType = this.getPixelTypeFromString(this.backgroundDatatype);
            ms.littleEndian = true;
            ms.interleaved = true;
            ms.falseColor = false;
            ms.moduloZ.type = "Frequency";
            ms.moduloZ.step = (double)ms.sizeZ / (double)f;
            ms.moduloZ.start = 0.0;
            ms.moduloZ.end = ms.sizeZ - 1;
            ms.moduloT.type = "Phase";
            ms.moduloT.step = (double)ms.sizeT / (double)p;
            ms.moduloT.start = 0.0;
            ms.moduloT.end = ms.sizeT - 1;
            this.core.add(ms);
        }
        if (this.DarkImage != null && this.DarkImage.equals(new String(COMPRESSION_GZIP))) {
            ms = new CoreMetadata();
            ms.sizeX = Integer.parseInt(this.xLen);
            ms.sizeY = Integer.parseInt(this.yLen);
            ms.sizeZ = 1;
            ms.sizeC = 1;
            ms.sizeT = 1;
            ms.imageCount = 1;
            ms.rgb = this.getSizeC() > 1;
            ms.indexed = false;
            ms.dimensionOrder = "XYCZT";
            ms.pixelType = this.getPixelTypeFromString(this.datatype);
            ms.littleEndian = true;
            ms.interleaved = true;
            ms.falseColor = false;
            if (this.TypeUINT12) {
                ms.bitsPerPixel = 12;
            }
            this.core.add(ms);
        }
    }

    private void initOMEMetadata() {
        int times = this.timestamps == null ? 0 : Integer.parseInt(this.timestamps);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (times > 0 ? 1 : 0) != 0);
        String path = new Location(this.getCurrentFile()).getName();
        store.setImageName(path + " Primary Image #1", 0);
        if (this.getSeriesCount() > 1) {
            store.setImageName(path + " Background Image #1", 1);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        long firstStamp = 0L;
        for (int t = 0; t < times && this.stampValues.get(t) != null; ++t) {
            Double deltaT;
            String[] stampWords = this.stampValues.get(t).split(" ");
            long stampHi = Long.parseLong(stampWords[0]);
            long stampLo = Long.parseLong(stampWords[1]);
            long stamp = DateTools.getMillisFromTicks((long)stampHi, (long)stampLo);
            if (t == 0) {
                String date = DateTools.convertDate((long)stamp, (int)1);
                if (date != null) {
                    store.setImageAcquisitionDate(new Timestamp(date), 0);
                }
                firstStamp = stamp;
                deltaT = 0.0;
            } else {
                long ms = stamp - firstStamp;
                deltaT = (double)ms / 1000.0;
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int index = this.getIndex(z, c, t);
                    if (deltaT != null) {
                        store.setPlaneDeltaT(new Time((Number)deltaT, UNITS.SECOND), 0, index);
                    }
                    if (this.exposureTime == null) continue;
                    store.setPlaneExposureTime(new Time((Number)this.exposureTime, this.exposureTimeUnit), 0, index);
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        Object[] roiIndices = this.rois.keySet().toArray(new Integer[this.rois.size()]);
        Arrays.sort(roiIndices);
        for (int roi = 0; roi < roiIndices.length; ++roi) {
            ROI r = this.rois.get(roiIndices[roi]);
            String polylineID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roi, 0});
            store.setPolygonID(polylineID, roi, 0);
            store.setPolygonPoints(r.pointsToString(), roi, 0);
            String roiID = MetadataTools.createLSID((String)"ROI", (int[])new int[]{roi});
            store.setROIID(roiID, roi);
            for (int s = 0; s < this.getSeriesCount(); ++s) {
                store.setImageROIRef(roiID, s, roi);
            }
        }
    }

    private int getPixelTypeFromString(String type) throws FormatException {
        if (DATATYPE_UINT8.equals(type) || LIPixelFormat.pixelFormatEqualsBitSize(8, type).booleanValue()) {
            return 1;
        }
        if (DATATYPE_INT8.equals(type)) {
            return 0;
        }
        if (DATATYPE_UINT16.equals(type) || LIPixelFormat.pixelFormatEqualsBitSize(16, type).booleanValue() || LIPixelFormat.pixelFormatEqualsBitSize(10, type).booleanValue() || LIPixelFormat.pixelFormatEqualsBitSize(14, type).booleanValue()) {
            return 3;
        }
        if (DATATYPE_INT16.equals(type)) {
            return 2;
        }
        if (DATATYPE_UINT32.equals(type)) {
            return 5;
        }
        if (DATATYPE_INT32.equals(type)) {
            return 4;
        }
        if (DATATYPE_REAL32.equals(type)) {
            return 6;
        }
        if (DATATYPE_REAL64.equals(type)) {
            return 7;
        }
        if (DATATYPE_UINT12.equals(type) || LIPixelFormat.pixelFormatEqualsBitSize(12, type).booleanValue()) {
            LOGGER.info("getPixelTypeFromString TypeUINT12");
            if (this.packing != "") {
                this.TypeUINT12 = true;
            }
            return 3;
        }
        LOGGER.info("Unknown data type: " + type);
        throw new FormatException("Unknown data type: " + type);
    }

    private void prepareGZipStream(int no) throws IOException {
        int bytesPerPlane = FormatTools.getPlaneSize((IFormatReader)this);
        if (this.gz == null || no < this.gzPos && this.getSeries() == this.gzSeries || this.gzSeries > this.getSeries()) {
            if (this.gz != null) {
                this.gz.close();
            }
            String path = Location.getMappedId((String)this.currentId);
            FileInputStream fis = new FileInputStream(path);
            this.skip(fis, this.dataOffset);
            this.gz = new DataInputStream(new GZIPInputStream(fis));
            this.gzPos = 0;
            this.gzSeries = 0;
        }
        if (this.getSeries() >= 1 && this.gzSeries < this.getSeries()) {
            int originalSeries = this.getSeries();
            for (int i = this.gzSeries; i < originalSeries; ++i) {
                this.setSeries(i);
                int nPlanes = this.getImageCount() - this.gzPos;
                int nBytes = FormatTools.getPlaneSize((IFormatReader)this) * nPlanes;
                this.skip(this.gz, nBytes);
                this.gzPos = 0;
            }
            this.setSeries(originalSeries);
            this.gzSeries = this.getSeries();
        }
        this.skip(this.gz, bytesPerPlane * (no - this.gzPos));
        this.gzPos = no + 1;
    }

    private void prepareUINT12Stream(int no) throws IOException {
        int bytesPerPlane = FormatTools.getPlaneSize((IFormatReader)this);
        bytesPerPlane = bytesPerPlane * 3 / 4;
        if (this.UINT12stream == null || no < this.UINT12streamPos && this.getSeries() == this.UINT12streamSeries || this.UINT12streamSeries > this.getSeries()) {
            if (this.UINT12stream != null) {
                this.UINT12stream.close();
            }
            String path = Location.getMappedId((String)this.currentId);
            FileInputStream fis = new FileInputStream(path);
            this.skip(fis, this.dataOffset);
            this.UINT12stream = new DataInputStream(fis);
            this.UINT12streamPos = 0;
            this.UINT12streamSeries = 0;
        }
        if (this.getSeries() >= 1 && this.UINT12streamSeries < this.getSeries()) {
            int originalSeries = this.getSeries();
            for (int i = this.UINT12streamSeries; i < originalSeries; ++i) {
                this.setSeries(i);
                long nPlanes = this.getImageCount() - this.UINT12streamPos;
                long nBytes = (long)FormatTools.getPlaneSize((IFormatReader)this) * nPlanes * 3L / 4L;
                this.skip(this.UINT12stream, nBytes);
                this.UINT12streamPos = 0;
            }
            this.setSeries(originalSeries);
            this.UINT12streamSeries = this.getSeries();
        } else if (this.UINT12streamSeries == 1 && this.DarkImage != null && this.DarkImage.equals(new String(COMPRESSION_GZIP))) {
            long nBytes = (long)FormatTools.getPlaneSize((IFormatReader)this) * (long)this.getSizeT() * 3L / 4L;
            this.skip(this.UINT12stream, nBytes);
            this.UINT12streamPos = 0;
        } else {
            this.skip(this.UINT12stream, (long)bytesPerPlane * (long)(no - this.UINT12streamPos));
            this.UINT12streamPos = no + 1;
        }
    }

    private static byte[] convert12to16LSB(byte[] image) {
        byte[] image16 = new byte[image.length * 4 / 3];
        if (image16.length / 4 != image.length / 3) {
            return new byte[0];
        }
        int idx = 0;
        for (int idx16 = 0; idx < image.length - 2 && idx16 < image16.length - 3; idx += 3, idx16 += 4) {
            image16[idx16] = (byte)(image[idx] & 0xFF);
            image16[idx16 + 1] = (byte)(image[idx + 1] & 0xF);
            image16[idx16 + 2] = (byte)((image[idx + 1] & 0xF0) >> 4 | (image[idx + 2] & 0xF) << 4);
            image16[idx16 + 3] = (byte)((image[idx + 2] & 0xF0) >> 4);
        }
        return image16;
    }

    private static byte[] convert12to16MSB(byte[] image) {
        byte[] image16 = new byte[image.length * 4 / 3];
        if (image16.length / 4 != image.length / 3) {
            return new byte[0];
        }
        int idx = 0;
        for (int idx16 = 0; idx < image.length - 2 && idx16 < image16.length - 3; idx += 3, idx16 += 4) {
            image16[idx16] = (byte)((image[idx] & 0xF) << 4 | (image[idx + 1] & 0xF0) >> 4);
            image16[idx16 + 1] = (byte)((image[idx] & 0xF0) >> 4);
            image16[idx16 + 2] = (byte)(image[idx + 2] & 0xFF);
            image16[idx16 + 3] = (byte)(image[idx + 1] & 0xF);
        }
        return image16;
    }

    private void skip(InputStream is, long num) throws IOException {
        long skip;
        for (long skipLeft = num; skipLeft > 0L; skipLeft -= skip) {
            skip = is.skip(skipLeft);
            if (skip > 0L) continue;
            throw new IOException("Cannot skip bytes");
        }
    }

    private class ROI {
        public String name;
        public final Map<Integer, String> points = new HashMap<Integer, String>();

        private ROI() {
        }

        public String pointsToString() {
            StringBuilder s = new StringBuilder();
            Object[] pointIndices = this.points.keySet().toArray(new Integer[0]);
            Arrays.sort(pointIndices);
            for (Object point : pointIndices) {
                if (point == null) continue;
                String p = this.points.get(point);
                if (s.length() > 0) {
                    s.append(" ");
                }
                s.append(p);
            }
            return s.toString();
        }
    }
}

