/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class PovrayReader
extends FormatReader {
    private static final int HEADER_SIZE = 6;

    public PovrayReader() {
        super("POV-Ray", "df3");
        this.domains = new String[]{"Graphics"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek((long)(6 + FormatTools.getPlaneSize((IFormatReader)this) * no));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = false;
        this.in.order(this.isLittleEndian());
        m.sizeX = this.in.readShort();
        m.sizeY = this.in.readShort();
        m.sizeZ = this.in.readShort();
        long fileLength = this.in.length() - 6L;
        int nBytes = (int)(fileLength / (long)(this.getSizeX() * this.getSizeY() * this.getSizeZ()));
        m.pixelType = FormatTools.pixelTypeFromBytes((int)nBytes, (boolean)false, (boolean)false);
        m.sizeC = 1;
        m.sizeT = 1;
        m.rgb = false;
        m.dimensionOrder = "XYZCT";
        m.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

