/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.CoreMetadata;
import loci.formats.CoreMetadataList;
import loci.formats.in.ND2Handler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ND2HandlerTest {
    private CoreMetadataList coreList;
    private ND2Handler handler;

    @BeforeMethod
    public void setUp() {
        this.coreList = new CoreMetadataList();
        this.coreList.add((Object)new CoreMetadata());
        this.handler = new ND2Handler(this.coreList, 1);
    }

    @DataProvider(name="pixelsSizeKey")
    public Object[][] createPixelsSizeKey() {
        return new Object[][]{{"dZStep", ".1", 0.1}, {"- Step .1 ", "", 0.1}, {"- Step .1", "", 0.1}, {"- Step ,1 ", "", 0.1}, {"- Step", "", 0.0}, {"- Step ", "", 0.0}, {"- Step d", "", 0.0}};
    }

    @Test(dataProvider="pixelsSizeKey")
    public void testParsePixelsSizeZ(String key, String value, double pixelSizeZ) {
        this.handler.parseKeyAndValue(key, value, "");
        Assert.assertEquals((Object)this.handler.getPixelSizeZ(), (Object)pixelSizeZ);
    }
}

