/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.common.enumeration.CodedEnum;

public enum JPEG2000BoxType implements CodedEnum
{
    SIGNATURE(1783636000, "Signature"),
    SIGNATURE_WRONG_ENDIANNESS(538988650, "Signature (Wrong endianness)"),
    FILE(1718909296, "File"),
    HEADER(1785737832, "Header"),
    IMAGE_HEADER(1768449138, "Image header"),
    BITS_PER_COMPONENT(1651532643, "Bits per component"),
    COLOUR_SPECIFICATION(1668246642, "Colour specification"),
    PALETTE(1885564018, "Palette"),
    COMPONENT_MAPPING(1668112752, "Component mapping"),
    CHANNEL_DEFINITION(1667523942, "Channel definition"),
    RESOLUTION(1919251232, "Resolution"),
    CAPTURE_RESOLUTION(1919251299, "Capture resolution"),
    DEFAULT_DISPLAY_RESOLUTION(1919251300, "Default display resolution"),
    CONTIGUOUS_CODESTREAM(1785737827, "Contiguous codestream"),
    INTELLECTUAL_PROPERTY(1785737833, "Intellectual property"),
    XML(2020437024, "XML"),
    UUID(1970628964, "UUID"),
    UUID_INFO(1969843814, "UUID info"),
    UUID_LIST(1970041716, "UUID list"),
    URL(1970433056, "URL"),
    ASSOCIATION(1634955107, "Association"),
    LABEL(1818389536, "Label"),
    PLACEHOLDER(1885891684, "Placeholder");

    private int code;
    private String name;
    private static final Map<Integer, JPEG2000BoxType> lookup;

    public static JPEG2000BoxType get(int code) {
        return lookup.get(code);
    }

    private JPEG2000BoxType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        lookup = new HashMap<Integer, JPEG2000BoxType>();
        for (JPEG2000BoxType v : EnumSet.allOf(JPEG2000BoxType.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

