/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.ResourceNamer;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.specification.XMLMockObjects;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Channel;
import ome.xml.model.MapPair;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.Timestamp;

public class FakeReader
extends FormatReader {
    private static final long ANN_LONG_VALUE = 365L;
    private static final Double ANN_DOUBLE_VALUE = 0.111;
    private static final String ANNOTATION_PREFIX = "Annotation:";
    private static final String ANNOTATION_NAMESPACE = "fake-reader";
    private static final String ANN_TERM_VALUE = "Term:";
    private static final String ANN_TAG_VALUE = "Tag:";
    private static final Timestamp ANN_TIME_VALUE = new Timestamp("1970-01-01T00:00:00");
    private static final boolean ANN_BOOLEAN_VALUE = true;
    private static final String ANN_COMMENT_VALUE = "Comment:";
    private static final String ANN_XML_VALUE_START = "<dummyXml>";
    private static final String ANN_XML_VALUE_END = "</dummyXml>";
    private static final String ROI_PREFIX = "ROI:";
    private static final String SHAPE_PREFIX = "Shape:";
    public static final int BOX_SIZE = 10;
    private static final int ROI_SPACING = 10;
    public static final int DEFAULT_SIZE_X = 512;
    public static final int DEFAULT_SIZE_Y = 512;
    public static final int DEFAULT_SIZE_Z = 1;
    public static final int DEFAULT_SIZE_C = 1;
    public static final int DEFAULT_SIZE_T = 1;
    public static final int DEFAULT_PIXEL_TYPE = 1;
    public static final int DEFAULT_RGB_CHANNEL_COUNT = 1;
    public static final String DEFAULT_DIMENSION_ORDER = "XYZCT";
    public static final String DEFAULT_RGB_DIMENSION_ORDER = "XYCZT";
    public static final int DEFAULT_RESOLUTION_SCALE = 2;
    private static final String TOKEN_SEPARATOR = "&";
    private static final long SEED = -889275714L;
    private int sizeX = 512;
    private int sizeY = 512;
    private int sizeZ = 1;
    private int sizeC = 1;
    private int sizeT = 1;
    private Time exposureTime = null;
    private Length physicalSizeX;
    private Length physicalSizeY;
    private Length physicalSizeZ;
    private transient ArrayList<Length> excitationWavelengths = new ArrayList();
    private transient ArrayList<Length> emissionWavelengths = new ArrayList();
    private int annBool = 0;
    private int annComment = 0;
    private int annDouble = 0;
    private int annLong = 0;
    private int annMap = 0;
    private int annTime = 0;
    private int annTag = 0;
    private int annTerm = 0;
    private int annXml = 0;
    private int annotationCount = 0;
    private int annotationBoolCount = 0;
    private int annotationCommentCount = 0;
    private int annotationDoubleCount = 0;
    private int annotationLongCount = 0;
    private int annotationMapCount = 0;
    private int annotationTagCount = 0;
    private int annotationTermCount = 0;
    private int annotationTimeCount = 0;
    private int annotationXmlCount = 0;
    private int ellipses = 0;
    private int labels = 0;
    private int lines = 0;
    private int masks = 0;
    private int points = 0;
    private int polygons = 0;
    private int polylines = 0;
    private int rectangles = 0;
    private int roiCount = 0;
    private double scaleFactor = 1.0;
    private byte[][][] lut8 = null;
    private short[][][] lut16 = null;
    private int[][] indexToValue = null;
    private int[][] valueToIndex = null;
    private int ac = 0;
    private String iniFile;
    private List<String> fakeSeries = new ArrayList<String>();
    private OMEXMLMetadata omeXmlMetadata;
    private OMEXMLService omeXmlService;
    private transient int screens = 0;
    private transient int plates = 0;
    private transient int plateRows = 0;
    private transient int plateCols = 0;
    private transient int fields = 0;
    private transient int plateAcqs = 0;
    private int sleepOpenBytes = 0;
    private int sleepInitFile = 0;
    private boolean labelPlanes = false;

    static void sleep(String msg, int ms) {
        if (ms <= 0) {
            return;
        }
        try {
            LOGGER.info("sleeping {}s.", (Object)ms);
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            LOGGER.warn("sleeping interrupted");
        }
    }

    public static int[] readSpecialPixels(byte[] plane) {
        return FakeReader.readSpecialPixels(plane, 1, true);
    }

    public static int[] readSpecialPixels(byte[] plane, int pixelType, boolean little) {
        return FakeReader.readSpecialPixels(plane, pixelType, little, 1, false);
    }

    public static int[] readSpecialPixels(byte[] plane, int pixelType, boolean little, int rgb, boolean interleaved) {
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        int[] idx = new int[5];
        for (int i = 0; i < idx.length; ++i) {
            int offset = i * 10 * bpp * (interleaved ? rgb : 1);
            idx[i] = pixelType == 6 ? (int)DataTools.bytesToFloat((byte[])plane, (int)offset, (int)bpp, (boolean)little) : (pixelType == 7 ? (int)DataTools.bytesToDouble((byte[])plane, (int)offset, (int)bpp, (boolean)little) : (2 == bpp ? (int)DataTools.bytesToShort((byte[])plane, (int)offset, (int)bpp, (boolean)little) : DataTools.bytesToInt((byte[])plane, (int)offset, (int)bpp, (boolean)little)));
        }
        return idx;
    }

    public FakeReader() {
        super("Simulated data", "fake");
        this.hasCompanionFiles = true;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.ac < 0 || this.lut8 == null ? null : this.lut8[this.ac];
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.ac < 0 || this.lut16 == null ? null : this.lut16[this.ac];
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        long min;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        FakeReader.sleep("openBytes", this.sleepOpenBytes);
        int s = this.getSeries();
        int pixelType = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        boolean signed = FormatTools.isSigned((int)pixelType);
        boolean floating = FormatTools.isFloatingPoint((int)pixelType);
        int rgb = this.getRGBChannelCount();
        boolean indexed = this.isIndexed();
        boolean little = this.isLittleEndian();
        boolean interleaved = this.isInterleaved();
        int[] zct = this.getZCTCoords(no);
        int zIndex = zct[0];
        int cIndex = zct[1];
        int tIndex = zct[2];
        this.ac = cIndex;
        long l = min = signed ? (long)(-Math.pow(2.0, 8 * bpp - 1)) : 0L;
        if (floating) {
            min = 0L;
        }
        for (int cOffset = 0; cOffset < rgb; ++cOffset) {
            int channel = rgb * cIndex + cOffset;
            for (int row = 0; row < h; ++row) {
                int yy = y + row;
                for (int col = 0; col < w; ++col) {
                    int xx = x + col;
                    long pixel = min + (long)xx;
                    boolean specialPixel = false;
                    if (yy < 10) {
                        int grid = xx / 10;
                        specialPixel = true;
                        switch (grid) {
                            case 0: {
                                pixel = s;
                                break;
                            }
                            case 1: {
                                pixel = no;
                                break;
                            }
                            case 2: {
                                pixel = zIndex;
                                break;
                            }
                            case 3: {
                                pixel = channel;
                                break;
                            }
                            case 4: {
                                pixel = tIndex;
                                break;
                            }
                            default: {
                                specialPixel = false;
                            }
                        }
                    }
                    if (indexed) {
                        if (this.lut8 != null) {
                            pixel = this.valueToIndex[this.ac][(int)(pixel % 256L)];
                        }
                        if (this.lut16 != null) {
                            pixel = this.valueToIndex[this.ac][(int)(pixel % 65536L)];
                        }
                    }
                    switch (pixelType) {
                        case 6: {
                            float floatPixel = specialPixel ? (float)pixel : (float)(this.scaleFactor * (double)pixel);
                            pixel = Float.floatToIntBits(floatPixel);
                            break;
                        }
                        case 7: {
                            double doublePixel = specialPixel ? (double)pixel : this.scaleFactor * (double)pixel;
                            pixel = Double.doubleToLongBits(doublePixel);
                            break;
                        }
                        default: {
                            if (specialPixel) break;
                            pixel = (long)(this.scaleFactor * (double)pixel);
                        }
                    }
                    int index = interleaved ? w * rgb * row + rgb * col + cOffset : h * w * cOffset + w * row + col;
                    DataTools.unpackBytes((long)pixel, (byte[])buf, (int)(index *= bpp), (int)bpp, (boolean)little);
                }
            }
        }
        if (this.labelPlanes) {
            BufferedImage plane = AWTImageTools.openImage(buf, (IFormatReader)this, w, h);
            Graphics2D g = plane.createGraphics();
            ArrayList<TextLine> lines = new ArrayList<TextLine>();
            Font font = g.getFont();
            lines.add(new TextLine(new Location(this.getCurrentFile()).getName(), font.deriveFont(16.0f), 5, -5));
            lines.add(new TextLine("Core index " + this.getCoreIndex(), font.deriveFont(16.0f), 5, 5));
            lines.add(new TextLine(this.getSizeX() + " x " + this.getSizeY(), font.deriveFont(2, 16.0f), 20, 10));
            lines.add(new TextLine(this.getDimensionOrder(), font.deriveFont(2, 14.0f), 30, 5));
            int space = 5;
            if (this.getSizeZ() > 1) {
                lines.add(new TextLine("Focal plane = " + (zIndex + 1) + "/" + this.getSizeZ(), font, 20, space));
                space = 2;
            }
            if (this.getSizeC() > 1) {
                lines.add(new TextLine("Channel = " + (cIndex + 1) + "/" + this.getSizeC(), font, 20, space));
                space = 2;
            }
            if (this.getSizeT() > 1) {
                lines.add(new TextLine("Time point = " + (tIndex + 1) + "/" + this.getSizeT(), font, 20, space));
                space = 2;
            }
            g.setColor(java.awt.Color.white);
            int yoff = 10;
            for (TextLine text : lines) {
                g.setFont(text.font);
                Rectangle2D r = g.getFont().getStringBounds(text.line, g.getFontRenderContext());
                g.drawString(text.line, text.xoff, yoff += (int)r.getHeight() + text.ypad);
            }
            g.dispose();
            byte[][] pixelBytes = AWTImageTools.getPixelBytes(plane, little);
            if (interleaved) {
                for (int i = 0; i < pixelBytes[0].length; i += bpp) {
                    for (int j = 0; j < pixelBytes.length; ++j) {
                        System.arraycopy(pixelBytes[j], i, buf, i * pixelBytes.length + j * bpp, bpp);
                    }
                }
            } else {
                for (int i = 0; i < pixelBytes.length; ++i) {
                    System.arraycopy(pixelBytes[i], 0, buf, i * pixelBytes[0].length, pixelBytes[i].length);
                }
            }
            pixelBytes = null;
        }
        return buf;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        if (new Location(id).isDirectory() && FakeReader.checkSuffix((String)id, (String)"fake")) {
            this.fakeSeries.clear();
            return this.listFakeSeries(id).size() <= 1;
        }
        if (FakeReader.checkSuffix((String)id, (String)"fake.ini")) {
            return !new Location(id).exists();
        }
        return !new Location(id + ".ini").exists();
    }

    public boolean isThisType(String name, boolean open) {
        if (FakeReader.checkSuffix((String)name, (String)"fake.ini")) {
            return true;
        }
        this.fakeSeries.clear();
        if (name.endsWith(".fake") && this.listFakeSeries(name).size() > 0) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        this.fakeSeries.clear();
        if (!noPixels) {
            files.addAll(this.listFakeSeries(this.currentId));
        }
        if (this.iniFile != null) {
            files.add(this.iniFile);
        }
        return files.toArray(new String[files.size()]);
    }

    private void findLogFiles() {
        this.iniFile = null;
        Location loc = new Location(this.getCurrentFile() + ".ini");
        if (loc.exists()) {
            this.iniFile = loc.getAbsolutePath();
        }
    }

    public void close(boolean fileOnly) throws IOException {
        this.iniFile = null;
        this.sizeX = 512;
        this.sizeY = 512;
        this.sizeZ = 1;
        this.sizeC = 1;
        this.sizeT = 1;
        this.exposureTime = null;
        this.physicalSizeX = null;
        this.physicalSizeY = null;
        this.physicalSizeZ = null;
        this.annBool = 0;
        this.annComment = 0;
        this.annDouble = 0;
        this.annLong = 0;
        this.annMap = 0;
        this.annTime = 0;
        this.annTag = 0;
        this.annTerm = 0;
        this.annXml = 0;
        this.annotationCount = 0;
        this.annotationBoolCount = 0;
        this.annotationCommentCount = 0;
        this.annotationDoubleCount = 0;
        this.annotationLongCount = 0;
        this.annotationMapCount = 0;
        this.annotationTagCount = 0;
        this.annotationTermCount = 0;
        this.annotationTimeCount = 0;
        this.annotationXmlCount = 0;
        this.ellipses = 0;
        this.labels = 0;
        this.lines = 0;
        this.masks = 0;
        this.points = 0;
        this.polygons = 0;
        this.polylines = 0;
        this.rectangles = 0;
        this.roiCount = 0;
        this.scaleFactor = 1.0;
        this.lut8 = null;
        this.lut16 = null;
        this.screens = 0;
        this.plates = 0;
        this.plateRows = 0;
        this.plateCols = 0;
        this.fields = 0;
        this.plateAcqs = 0;
        this.labelPlanes = false;
        this.excitationWavelengths.clear();
        this.emissionWavelengths.clear();
        super.close(fileOnly);
    }

    public OMEXMLMetadata getOmeXmlMetadata() {
        if (this.omeXmlMetadata == null) {
            try {
                this.omeXmlMetadata = this.getOmeXmlService().createOMEXMLMetadata();
            }
            catch (ServiceException exc) {
                LOGGER.error("Could not create OME-XML metadata", (Throwable)exc);
            }
        }
        return this.omeXmlMetadata;
    }

    public OMEXMLService getOmeXmlService() {
        if (this.omeXmlService == null) {
            try {
                this.omeXmlService = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
            }
            catch (DependencyException exc) {
                LOGGER.error("Could not create OME-XML service", (Throwable)exc);
            }
        }
        return this.omeXmlService;
    }

    /*
     * WARNING - void declaration
     */
    protected void initFile(String id) throws FormatException, IOException {
        void var32_41;
        boolean hasSPW;
        Location root;
        String name;
        if (!FakeReader.checkSuffix((String)id, (String)"fake")) {
            Location file;
            if (FakeReader.checkSuffix((String)id, (String)"fake.ini")) {
                id = id.substring(0, id.lastIndexOf("."));
            }
            if (!(file = new Location(id).getAbsoluteFile()).exists()) {
                Location dir = file.getParentFile();
                String[] list = dir.list(true);
                name = file.getName();
                name = name.substring(0, name.lastIndexOf("."));
                for (String f : list) {
                    if (!FakeReader.checkSuffix((String)f, (String)"fake") || !f.startsWith(name)) continue;
                    id = new Location(dir, f).getAbsolutePath();
                    break;
                }
            }
        }
        super.initFile(id);
        this.findLogFiles();
        String path = id;
        Location location = new Location(id);
        String[] tokens = null;
        if (location.exists() && (path = location.getAbsoluteFile().getName()).startsWith("Field") && (root = location.getAbsoluteFile().getParentFile()) != null && (root = root.getParentFile()) != null && (root = root.getParentFile()) != null && this.isSPWStructure((root = root.getParentFile()).getAbsolutePath())) {
            tokens = this.extractTokensFromFakeSeries(root.getAbsolutePath());
            this.currentId = root.getAbsolutePath();
        }
        if (location.isDirectory() && this.isSPWStructure(location.getAbsolutePath())) {
            tokens = this.extractTokensFromFakeSeries(location.getAbsolutePath());
        } else if (tokens == null) {
            String noExt = path.substring(0, path.lastIndexOf("."));
            tokens = noExt.split(TOKEN_SEPARATOR);
        }
        name = null;
        int thumbSizeX = 0;
        int thumbSizeY = 0;
        int pixelType = 1;
        int bitsPerPixel = 0;
        int rgb = 1;
        String dimOrder = null;
        boolean orderCertain = true;
        boolean little = true;
        boolean interleaved = false;
        boolean indexed = false;
        boolean falseColor = false;
        boolean metadataComplete = true;
        boolean thumbnail = false;
        boolean withMicrobeam = false;
        boolean withInstrument = false;
        int seriesCount = 1;
        int resolutionCount = 1;
        int resolutionScale = 2;
        int lutLength = 3;
        String acquisitionDate = null;
        Integer defaultColor = null;
        ArrayList<Integer> color = new ArrayList<Integer>();
        ArrayList<IniTable> seriesTables = new ArrayList<IniTable>();
        if (this.iniFile != null) {
            IniTable iniTable;
            String[] parser = new IniParser();
            IniList list = parser.parseINI(new File(this.iniFile));
            ArrayList<String> newTokens = new ArrayList<String>();
            IniTable iniTable2 = list.getTable("DEFAULT_HEADER");
            if (iniTable2 != null) {
                for (Map.Entry entry : iniTable2.entrySet()) {
                    newTokens.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
            if ((iniTable = list.getTable("GlobalMetadata")) != null) {
                for (Map.Entry entry : iniTable.entrySet()) {
                    if ("header".equals(entry.getKey())) continue;
                    this.addGlobalMeta((String)entry.getKey(), entry.getValue());
                }
            }
            String[] newTokArr = newTokens.toArray(new String[0]);
            String[] oldTokArr = tokens;
            tokens = new String[newTokArr.length + oldTokArr.length];
            System.arraycopy(oldTokArr, 0, tokens, 0, oldTokArr.length);
            System.arraycopy(newTokArr, 0, tokens, oldTokArr.length, newTokArr.length);
            int seriesIndex = 0;
            while (list.getTable("series_" + seriesIndex) != null) {
                seriesTables.add(list.getTable("series_" + seriesIndex));
                ++seriesIndex;
            }
        }
        for (IniParser iniParser : tokens) {
            int index;
            int intValue;
            double doubleValue;
            if (name == null) {
                name = iniParser;
                continue;
            }
            int equals = iniParser.indexOf(61);
            if (equals < 0) {
                LOGGER.warn("ignoring token: {}", (Object)iniParser);
                continue;
            }
            String key = iniParser.substring(0, equals);
            String value = iniParser.substring(equals + 1);
            boolean boolValue = value.equals("true");
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException exc) {
                doubleValue = Double.NaN;
            }
            int n = intValue = Double.isNaN(doubleValue) ? -1 : (int)doubleValue;
            if (key.equals("sizeX")) {
                this.sizeX = intValue;
                continue;
            }
            if (key.equals("sizeY")) {
                this.sizeY = intValue;
                continue;
            }
            if (key.equals("sizeZ")) {
                this.sizeZ = intValue;
                continue;
            }
            if (key.equals("sizeC")) {
                this.sizeC = intValue;
                continue;
            }
            if (key.equals("sizeT")) {
                this.sizeT = intValue;
                continue;
            }
            if (key.equals("thumbSizeX")) {
                thumbSizeX = intValue;
                continue;
            }
            if (key.equals("thumbSizeY")) {
                thumbSizeY = intValue;
                continue;
            }
            if (key.equals("pixelType")) {
                pixelType = FormatTools.pixelTypeFromString((String)value);
                continue;
            }
            if (key.equals("bitsPerPixel")) {
                bitsPerPixel = intValue;
                continue;
            }
            if (key.equals("rgb")) {
                rgb = intValue;
                continue;
            }
            if (key.equals("dimOrder")) {
                dimOrder = value.toUpperCase();
                continue;
            }
            if (key.equals("orderCertain")) {
                orderCertain = boolValue;
                continue;
            }
            if (key.equals("little")) {
                little = boolValue;
                continue;
            }
            if (key.equals("interleaved")) {
                interleaved = boolValue;
                continue;
            }
            if (key.equals("indexed")) {
                indexed = boolValue;
                continue;
            }
            if (key.equals("falseColor")) {
                falseColor = boolValue;
                continue;
            }
            if (key.equals("metadataComplete")) {
                metadataComplete = boolValue;
                continue;
            }
            if (key.equals("thumbnail")) {
                thumbnail = boolValue;
                continue;
            }
            if (key.equals("series")) {
                seriesCount = intValue;
                continue;
            }
            if (key.equals("resolutions")) {
                resolutionCount = intValue;
                continue;
            }
            if (key.equals("resolutionScale")) {
                resolutionScale = intValue;
                continue;
            }
            if (key.equals("lutLength")) {
                lutLength = intValue;
                continue;
            }
            if (key.equals("scaleFactor")) {
                this.scaleFactor = doubleValue;
                continue;
            }
            if (key.equals("exposureTime")) {
                this.exposureTime = new Time((Number)Float.valueOf((float)doubleValue), UNITS.SECOND);
                continue;
            }
            if (key.equals("acquisitionDate")) {
                acquisitionDate = value;
                continue;
            }
            if (key.equals("screens")) {
                this.screens = intValue;
                continue;
            }
            if (key.equals("plates")) {
                this.plates = intValue;
                continue;
            }
            if (key.equals("plateRows")) {
                this.plateRows = intValue;
                continue;
            }
            if (key.equals("plateCols")) {
                this.plateCols = intValue;
                continue;
            }
            if (key.equals("fields")) {
                this.fields = intValue;
                continue;
            }
            if (key.equals("plateAcqs")) {
                this.plateAcqs = intValue;
                continue;
            }
            if (key.equals("withMicrobeam")) {
                withMicrobeam = boolValue;
                continue;
            }
            if (key.equals("withInstrument")) {
                withInstrument = boolValue;
                continue;
            }
            if (key.equals("annLong")) {
                this.annLong = intValue;
                continue;
            }
            if (key.equals("annDouble")) {
                this.annDouble = intValue;
                continue;
            }
            if (key.equals("annMap")) {
                this.annMap = intValue;
                continue;
            }
            if (key.equals("annComment")) {
                this.annComment = intValue;
                continue;
            }
            if (key.equals("annBool")) {
                this.annBool = intValue;
                continue;
            }
            if (key.equals("annTime")) {
                this.annTime = intValue;
                continue;
            }
            if (key.equals("annTag")) {
                this.annTag = intValue;
                continue;
            }
            if (key.equals("annTerm")) {
                this.annTerm = intValue;
                continue;
            }
            if (key.equals("annXml")) {
                this.annXml = intValue;
                continue;
            }
            if (key.equals("ellipses")) {
                this.ellipses = intValue;
                continue;
            }
            if (key.equals("labels")) {
                this.labels = intValue;
                continue;
            }
            if (key.equals("lines")) {
                this.lines = intValue;
                continue;
            }
            if (key.equals("masks")) {
                this.masks = intValue;
                continue;
            }
            if (key.equals("points")) {
                this.points = intValue;
                continue;
            }
            if (key.equals("polygons")) {
                this.polygons = intValue;
                continue;
            }
            if (key.equals("polylines")) {
                this.polylines = intValue;
                continue;
            }
            if (key.equals("rectangles")) {
                this.rectangles = intValue;
                continue;
            }
            if (key.equals("physicalSizeX")) {
                this.physicalSizeX = this.parsePhysicalSize(value, Pixels.getPhysicalSizeXUnitXsdDefault());
                continue;
            }
            if (key.equals("physicalSizeY")) {
                this.physicalSizeY = this.parsePhysicalSize(value, Pixels.getPhysicalSizeYUnitXsdDefault());
                continue;
            }
            if (key.equals("physicalSizeZ")) {
                this.physicalSizeZ = this.parsePhysicalSize(value, Pixels.getPhysicalSizeZUnitXsdDefault());
                continue;
            }
            if (key.equals("color")) {
                defaultColor = this.parseColor(value);
                continue;
            }
            if (key.startsWith("color_")) {
                index = Integer.parseInt(key.substring(key.indexOf(95) + 1));
                while (index >= color.size()) {
                    color.add(null);
                }
                color.set(index, this.parseColor(value));
                continue;
            }
            if (key.startsWith("emission_")) {
                index = Integer.parseInt(key.substring(key.indexOf(95) + 1));
                while (index >= this.emissionWavelengths.size()) {
                    this.emissionWavelengths.add(null);
                }
                this.emissionWavelengths.set(index, this.parseWavelength(value, Channel.getEmissionWavelengthUnitXsdDefault()));
                continue;
            }
            if (key.startsWith("excitation_")) {
                index = Integer.parseInt(key.substring(key.indexOf(95) + 1));
                while (index >= this.excitationWavelengths.size()) {
                    this.excitationWavelengths.add(null);
                }
                this.excitationWavelengths.set(index, this.parseWavelength(value, Channel.getExcitationWavelengthUnitXsdDefault()));
                continue;
            }
            if (key.equals("sleepOpenBytes")) {
                this.sleepOpenBytes = intValue;
                continue;
            }
            if (key.equals("sleepInitFile")) {
                this.sleepInitFile = intValue;
                continue;
            }
            if (!key.equals("labelPlanes")) continue;
            this.labelPlanes = boolValue;
        }
        if (this.sizeX < 1) {
            throw new FormatException("Invalid sizeX: " + this.sizeX);
        }
        if (this.sizeY < 1) {
            throw new FormatException("Invalid sizeY: " + this.sizeY);
        }
        if (this.sizeZ < 1) {
            throw new FormatException("Invalid sizeZ: " + this.sizeZ);
        }
        if (this.sizeC < 1) {
            throw new FormatException("Invalid sizeC: " + this.sizeC);
        }
        if (this.sizeT < 1) {
            throw new FormatException("Invalid sizeT: " + this.sizeT);
        }
        if (thumbSizeX < 0) {
            throw new FormatException("Invalid thumbSizeX: " + thumbSizeX);
        }
        if (thumbSizeY < 0) {
            throw new FormatException("Invalid thumbSizeY: " + thumbSizeY);
        }
        if (rgb < 1 || rgb > this.sizeC || this.sizeC % rgb != 0) {
            throw new FormatException("Invalid sizeC/rgb combination: " + this.sizeC + "/" + rgb);
        }
        if (rgb > 1) {
            String newDimOrder;
            String string = newDimOrder = dimOrder == null ? DEFAULT_RGB_DIMENSION_ORDER : dimOrder;
            if (!newDimOrder.startsWith("XYC")) {
                newDimOrder = newDimOrder.indexOf("Z") < newDimOrder.indexOf("T") ? DEFAULT_RGB_DIMENSION_ORDER : "XYCTZ";
                LOGGER.warn("Dimension order {} incorrect for rgb={}; corrected to {}", new Object[]{dimOrder, rgb, newDimOrder});
            }
            dimOrder = newDimOrder;
        } else if (dimOrder == null) {
            dimOrder = DEFAULT_DIMENSION_ORDER;
        }
        MetadataTools.getDimensionOrder((String)dimOrder);
        if (falseColor && !indexed) {
            throw new FormatException("False color images must be indexed");
        }
        if (seriesCount < 1) {
            throw new FormatException("Invalid seriesCount: " + seriesCount);
        }
        if (lutLength < 1) {
            throw new FormatException("Invalid lutLength: " + lutLength);
        }
        if (resolutionCount < 1) {
            throw new FormatException("Invalid resolutionCount: " + resolutionCount);
        }
        if (resolutionScale <= 1) {
            throw new FormatException("Invalid resolutionScale: " + resolutionScale);
        }
        MetadataStore store = this.makeFilterMetadata();
        boolean bl = hasSPW = this.screens > 0 || this.plates > 0 || this.plateRows > 0 || this.plateCols > 0 || this.fields > 0 || this.plateAcqs > 0;
        if (hasSPW) {
            int imageCount;
            if (this.screens < 0) {
                this.screens = 0;
            }
            if (this.plates <= 0) {
                this.plates = 1;
            }
            if (this.plateRows <= 0) {
                this.plateRows = 1;
            }
            if (this.plateCols <= 0) {
                this.plateCols = 1;
            }
            if (this.fields <= 0) {
                this.fields = 1;
            }
            if (this.plateAcqs <= 0) {
                this.plateAcqs = 1;
            }
            if ((imageCount = this.populateSPW(store, this.screens, this.plates, this.plateRows, this.plateCols, this.fields, this.plateAcqs, withMicrobeam)) > 0) {
                seriesCount = imageCount;
            } else {
                hasSPW = false;
            }
        } else if (withInstrument) {
            this.populateInstrument(store);
        }
        int effSizeC = this.sizeC / rgb;
        this.core.clear();
        boolean bl2 = false;
        while (var32_41 < seriesCount) {
            CoreMetadata ms = new CoreMetadata();
            ms.resolutionCount = resolutionCount;
            this.core.add(ms);
            ms.sizeX = this.sizeX;
            ms.sizeY = this.sizeY;
            ms.sizeZ = this.sizeZ;
            ms.sizeC = this.sizeC;
            ms.sizeT = this.sizeT;
            ms.thumbSizeX = thumbSizeX;
            ms.thumbSizeY = thumbSizeY;
            ms.pixelType = pixelType;
            ms.bitsPerPixel = bitsPerPixel;
            ms.imageCount = this.sizeZ * effSizeC * this.sizeT;
            ms.rgb = rgb > 1;
            ms.dimensionOrder = dimOrder;
            ms.orderCertain = orderCertain;
            ms.littleEndian = little;
            ms.interleaved = interleaved;
            ms.indexed = indexed;
            ms.falseColor = falseColor;
            ms.metadataComplete = metadataComplete;
            ms.thumbnail = thumbnail;
            for (int r = 1; r < resolutionCount; ++r) {
                CoreMetadata subres = new CoreMetadata(ms);
                int scale = (int)Math.pow(resolutionScale, r);
                subres.sizeX /= scale;
                subres.sizeY /= scale;
                this.core.add(subres);
            }
            ++var32_41;
        }
        boolean bl3 = this.exposureTime != null || seriesTables.size() > 0;
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)bl3);
        this.fillExposureTime(store);
        this.fillPhysicalSizes(store);
        this.fillChannelWavelengths(store);
        for (int currentImageIndex = 0; currentImageIndex < seriesCount; ++currentImageIndex) {
            if (hasSPW || withInstrument) {
                this.fillInstrumentRefs(store);
            }
            if (currentImageIndex < seriesTables.size()) {
                this.parseSeriesTable((IniTable)seriesTables.get(currentImageIndex), store, currentImageIndex);
            }
            String imageName = currentImageIndex > 0 ? name + " " + (currentImageIndex + 1) : name;
            store.setImageName(imageName, currentImageIndex);
            this.fillAcquisitionDate(store, acquisitionDate, currentImageIndex);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                Color channel;
                Color color2 = channel = defaultColor == null ? null : new Color(defaultColor);
                if (c < color.size() && color.get(c) != null) {
                    channel = new Color((Integer)color.get(c));
                }
                if (channel == null) continue;
                store.setChannelColor(channel, currentImageIndex, c);
            }
            this.fillAnnotations(store, currentImageIndex);
            this.fillRegions(store, currentImageIndex);
        }
        if (indexed) {
            int i;
            int num;
            if (pixelType == 1) {
                num = 256;
                this.createIndexMap(256);
                this.lut8 = new byte[this.sizeC][lutLength][256];
                for (int c = 0; c < this.sizeC; ++c) {
                    for (i = 0; i < lutLength; ++i) {
                        for (int index = 0; index < 256; ++index) {
                            this.lut8[c][i][index] = (byte)this.indexToValue[c][index];
                        }
                    }
                }
            } else if (pixelType == 3) {
                num = 65536;
                this.createIndexMap(65536);
                this.lut16 = new short[this.sizeC][lutLength][65536];
                for (int c = 0; c < this.sizeC; ++c) {
                    for (i = 0; i < lutLength; ++i) {
                        for (int index = 0; index < 65536; ++index) {
                            this.lut16[c][i][index] = (short)this.indexToValue[c][index];
                        }
                    }
                }
            }
        }
        FakeReader.sleep("initFile", this.sleepInitFile);
    }

    public void reopenFile() throws IOException {
    }

    private void fillPhysicalSizes(MetadataStore store) {
        if (this.physicalSizeX == null && this.physicalSizeY == null && this.physicalSizeZ == null) {
            return;
        }
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            store.setPixelsPhysicalSizeX(this.physicalSizeX, s);
            store.setPixelsPhysicalSizeY(this.physicalSizeY, s);
            store.setPixelsPhysicalSizeZ(this.physicalSizeZ, s);
        }
    }

    private void fillExposureTime(MetadataStore store) {
        if (this.exposureTime == null) {
            return;
        }
        int oldSeries = this.getSeries();
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            this.setSeries(s);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneExposureTime(this.exposureTime, s, i);
            }
        }
        this.setSeries(oldSeries);
    }

    private void fillChannelWavelengths(MetadataStore store) {
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (c < this.emissionWavelengths.size() && this.emissionWavelengths.get(c) != null) {
                    store.setChannelEmissionWavelength(this.emissionWavelengths.get(c), s, c);
                }
                if (c >= this.excitationWavelengths.size() || this.excitationWavelengths.get(c) == null) continue;
                store.setChannelExcitationWavelength(this.excitationWavelengths.get(c), s, c);
            }
        }
    }

    private void fillAcquisitionDate(MetadataStore store, String date, int imageIndex) {
        if (date == null) {
            return;
        }
        if (DateTools.getTime((String)date, (String)"yyyy-MM-dd_HH-mm-ss") != -1L) {
            Timestamp stamp = new Timestamp(DateTools.formatDate((String)date, (String)"yyyy-MM-dd_HH-mm-ss"));
            store.setImageAcquisitionDate(stamp, imageIndex);
        }
    }

    private void fillAnnotations(MetadataStore store, int imageIndex) {
        String annotationID;
        int i;
        int annotationRefCount = 0;
        for (i = 0; i < this.annBool; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setBooleanAnnotationID(annotationID, this.annotationBoolCount);
            store.setBooleanAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationBoolCount);
            store.setBooleanAnnotationValue(Boolean.valueOf(true), this.annotationBoolCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationBoolCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annComment; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setCommentAnnotationID(annotationID, this.annotationCommentCount);
            store.setCommentAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationCommentCount);
            store.setCommentAnnotationValue(ANN_COMMENT_VALUE + (this.annotationCount + 1), this.annotationCommentCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationCommentCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annDouble; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setDoubleAnnotationID(annotationID, this.annotationDoubleCount);
            store.setDoubleAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationDoubleCount);
            store.setDoubleAnnotationValue(Double.valueOf(ANN_DOUBLE_VALUE * (double)(this.annotationCount + 1)), this.annotationDoubleCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationDoubleCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annLong; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setLongAnnotationID(annotationID, this.annotationLongCount);
            store.setLongAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationLongCount);
            store.setLongAnnotationValue(Long.valueOf(365L + (long)this.annotationCount), this.annotationLongCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationLongCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annMap; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setMapAnnotationID(annotationID, this.annotationMapCount);
            store.setMapAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationMapCount);
            ArrayList<MapPair> mapValue = new ArrayList<MapPair>();
            for (int keyNum = 0; keyNum < 10; ++keyNum) {
                mapValue.add(new MapPair("keyS" + imageIndex + "N" + keyNum, "val" + (keyNum + 1) * (this.annotationCount + 1)));
            }
            store.setMapAnnotationValue(mapValue, this.annotationMapCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationMapCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annTag; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setTagAnnotationID(annotationID, this.annotationTagCount);
            store.setTagAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationTagCount);
            store.setTagAnnotationValue(ANN_TAG_VALUE + (this.annotationCount + 1), this.annotationTagCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationTagCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annTerm; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setTermAnnotationID(annotationID, this.annotationTermCount);
            store.setTermAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationTermCount);
            store.setTermAnnotationValue(ANN_TERM_VALUE + (this.annotationCount + 1), this.annotationTermCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationTermCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annTime; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setTimestampAnnotationID(annotationID, this.annotationTimeCount);
            store.setTimestampAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationTimeCount);
            store.setTimestampAnnotationValue(ANN_TIME_VALUE, this.annotationTimeCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationTimeCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
        for (i = 0; i < this.annXml; ++i) {
            annotationID = ANNOTATION_PREFIX + this.annotationCount;
            store.setXMLAnnotationID(annotationID, this.annotationXmlCount);
            store.setXMLAnnotationNamespace(ANNOTATION_NAMESPACE, this.annotationXmlCount);
            store.setXMLAnnotationValue(ANN_XML_VALUE_START + (this.annotationCount + 1) + ANN_XML_VALUE_END, this.annotationXmlCount);
            store.setImageAnnotationRef(annotationID, imageIndex, annotationRefCount);
            ++this.annotationXmlCount;
            ++this.annotationCount;
            ++annotationRefCount;
        }
    }

    private void fillInstrumentRefs(MetadataStore store) {
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            String detectorID = this.getOmeXmlMetadata().getDetectorID(0, 0);
            String dichroicID = this.getOmeXmlMetadata().getDichroicID(0, 0);
            String emissionFilterID = this.getOmeXmlMetadata().getFilterID(0, 0);
            String excitationFilterID = this.getOmeXmlMetadata().getFilterID(0, 1);
            String filterSetID = this.getOmeXmlMetadata().getFilterSetID(0, 0);
            String instrumentID = this.getOmeXmlMetadata().getInstrumentID(0);
            String[] lightSourcesID = new String[]{this.getOmeXmlMetadata().getLaserID(0, 0), this.getOmeXmlMetadata().getArcID(0, 1), this.getOmeXmlMetadata().getFilamentID(0, 2), this.getOmeXmlMetadata().getLightEmittingDiodeID(0, 3), this.getOmeXmlMetadata().getLaserID(0, 4)};
            String objectiveID = this.getOmeXmlMetadata().getObjectiveID(0, 0);
            store.setImageInstrumentRef(instrumentID, s);
            store.setObjectiveSettingsID(objectiveID, s);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                store.setChannelFilterSetRef(filterSetID, s, c);
                store.setChannelLightSourceSettingsID(lightSourcesID[c % 5], s, c);
                store.setDetectorSettingsID(detectorID, s, c);
                store.setLightPathDichroicRef(dichroicID, s, c);
                store.setLightPathEmissionFilterRef(emissionFilterID, s, c, 0);
                store.setLightPathExcitationFilterRef(excitationFilterID, s, c, 0);
            }
        }
    }

    private Double getX(int i) {
        return 10 * i % this.sizeX;
    }

    private Double getY(int i) {
        return 10 * (10 * i / this.sizeX) % this.sizeY;
    }

    private String getPoints(int i) {
        Double x0 = this.getX(i) + 5.0;
        Double y0 = this.getY(i) + 5.0;
        double[] dx = new double[]{-0.8, -0.3, 0.4, 0.5, -0.1};
        double[] dy = new double[]{-0.4, 0.6, 0.5, -0.3, -0.7};
        StringBuilder p = new StringBuilder();
        for (int j = 0; j < 5; ++j) {
            p.append(x0 + 5.0 * dx[j]);
            p.append(",");
            p.append(y0 + 5.0 * dy[j]);
            if (j >= dx.length - 1) continue;
            p.append(" ");
        }
        return p.toString();
    }

    private void fillRegions(MetadataStore store, int imageIndex) {
        String roiID;
        int i;
        int roiRefCount = 0;
        Random random = new Random();
        for (i = 0; i < this.ellipses; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setEllipseID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setEllipseX(Double.valueOf(this.getX(i) + 5.0), this.roiCount, 0);
            store.setEllipseY(Double.valueOf(this.getY(i) + 5.0), this.roiCount, 0);
            store.setEllipseRadiusX(Double.valueOf(5.0), this.roiCount, 0);
            store.setEllipseRadiusY(Double.valueOf(5.0), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.labels; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setLabelID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setLabelX(this.getX(i), this.roiCount, 0);
            store.setLabelY(this.getY(i), this.roiCount, 0);
            store.setLabelText("Label " + i, this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.lines; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setLineID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setLineX1(Double.valueOf(this.getX(i) + 2.0), this.roiCount, 0);
            store.setLineY1(Double.valueOf(this.getY(i) + 2.0), this.roiCount, 0);
            store.setLineX2(Double.valueOf(this.getX(i) + 5.0), this.roiCount, 0);
            store.setLineY2(Double.valueOf(this.getY(i) + 5.0), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.masks; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setMaskID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setMaskX(Double.valueOf(10.0), this.roiCount, 0);
            store.setMaskY(Double.valueOf(10.0), this.roiCount, 0);
            store.setMaskWidth(Double.valueOf(10.0), this.roiCount, 0);
            store.setMaskHeight(Double.valueOf(10.0), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            byte[] rawBytes = new byte[100];
            random.nextBytes(rawBytes);
            store.setMaskBinData(rawBytes, this.roiCount, 0);
            store.setMaskBinDataBigEndian(Boolean.valueOf(true), this.roiCount, 0);
            store.setMaskBinDataLength(new NonNegativeLong(Long.valueOf(100L)), this.roiCount, 0);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.points; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setPointID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setPointX(Double.valueOf(this.getX(i) + 5.0), this.roiCount, 0);
            store.setPointY(Double.valueOf(this.getY(i) + 5.0), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.polygons; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setPolygonID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setPolygonPoints(this.getPoints(i), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.polylines; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setPolylineID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setPolylinePoints(this.getPoints(i), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
        for (i = 0; i < this.rectangles; ++i) {
            roiID = ROI_PREFIX + this.roiCount;
            store.setROIID(roiID, this.roiCount);
            store.setRectangleID(SHAPE_PREFIX + this.roiCount, this.roiCount, 0);
            store.setRectangleX(Double.valueOf(this.getX(i) + 2.0), this.roiCount, 0);
            store.setRectangleY(Double.valueOf(this.getY(i) + 2.0), this.roiCount, 0);
            store.setRectangleWidth(Double.valueOf(5.0), this.roiCount, 0);
            store.setRectangleHeight(Double.valueOf(5.0), this.roiCount, 0);
            store.setImageROIRef(roiID, imageIndex, roiRefCount);
            ++this.roiCount;
            ++roiRefCount;
        }
    }

    private void parseSeriesTable(IniTable table, MetadataStore store, int newSeries) {
        int s = this.getSeries();
        this.setSeries(newSeries);
        for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
            String excitationWavelength;
            String channelName = (String)table.get((Object)("ChannelName_" + c));
            store.setChannelName(channelName, newSeries, c);
            String emissionWavelength = (String)table.get((Object)("ChannelEmissionWavelength_" + c));
            if (emissionWavelength != null) {
                store.setChannelEmissionWavelength(this.parseWavelength(emissionWavelength, Channel.getEmissionWavelengthUnitXsdDefault()), newSeries, c);
            }
            if ((excitationWavelength = (String)table.get((Object)("ChannelExcitationWavelength_" + c))) == null) continue;
            store.setChannelExcitationWavelength(this.parseWavelength(excitationWavelength, Channel.getExcitationWavelengthUnitXsdDefault()), newSeries, c);
        }
        for (int i = 0; i < this.getImageCount(); ++i) {
            Length z;
            Length y;
            String exposureTime = (String)table.get((Object)("ExposureTime_" + i));
            String exposureTimeUnit = (String)table.get((Object)("ExposureTimeUnit_" + i));
            if (exposureTime != null) {
                try {
                    Double v = Double.valueOf(exposureTime);
                    Time exposure = FormatTools.getTime((Double)v, (String)exposureTimeUnit);
                    if (exposure != null) {
                        store.setPlaneExposureTime(exposure, newSeries, i);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.trace("Could not parse ExposureTime for series #" + newSeries + " plane #" + i, (Throwable)e);
                }
            }
            String deltaT = (String)table.get((Object)("DeltaT_" + i));
            String deltaTUnit = (String)table.get((Object)("DeltaTUnit_" + i));
            if (deltaT != null) {
                try {
                    Double v = Double.valueOf(deltaT);
                    Time delta = FormatTools.getTime((Double)v, (String)deltaTUnit);
                    if (delta != null) {
                        store.setPlaneDeltaT(delta, newSeries, i);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.trace("Could not parse DeltaT for series #" + newSeries + " plane #" + i, (Throwable)e);
                }
            }
            int[] spwCoordinate = this.toSPWCoordinates(newSeries);
            Length x = this.parsePosition("X", s, i, table);
            if (x != null) {
                store.setPlanePositionX(x, newSeries, i);
                if (spwCoordinate != null) {
                    store.setWellSamplePositionX(x, spwCoordinate[2], spwCoordinate[1], spwCoordinate[0]);
                }
            }
            if ((y = this.parsePosition("Y", s, i, table)) != null) {
                store.setPlanePositionY(y, newSeries, i);
                if (spwCoordinate != null) {
                    store.setWellSamplePositionY(y, spwCoordinate[2], spwCoordinate[1], spwCoordinate[0]);
                }
            }
            if ((z = this.parsePosition("Z", s, i, table)) == null) continue;
            store.setPlanePositionZ(z, newSeries, i);
        }
        this.setSeries(s);
    }

    private int[] toSPWCoordinates(int seriesIndex) {
        if (this.plates < 1) {
            return null;
        }
        int screenCount = Math.max(this.screens, 1);
        return FormatTools.rasterToPosition((int[])new int[]{this.plateAcqs * this.fields, this.plateRows * this.plateCols, screenCount * this.plates}, (int)seriesIndex);
    }

    private String[] extractTokensFromFakeSeries(String path) {
        ArrayList<String> tokens = new ArrayList<String>();
        int plates = 0;
        int plateAcqs = 0;
        int rows = 0;
        int cols = 0;
        int fields = 0;
        String currentPlate = "";
        String regExFileSeparator = File.separatorChar == '\\' ? "\\\\" : File.separator;
        for (String fakeImage : this.fakeSeries) {
            for (String pathToken : fakeImage.split(regExFileSeparator)) {
                if (!pathToken.startsWith("Plate") || pathToken.equals(currentPlate)) continue;
                currentPlate = pathToken;
                ++plates;
            }
        }
        for (String pathToken : this.fakeSeries.get(this.fakeSeries.size() - 1).split(regExFileSeparator)) {
            if (pathToken.startsWith("Run")) {
                plateAcqs = Integer.parseInt(pathToken.substring(pathToken.lastIndexOf("Run") + "Run".length(), pathToken.length())) + 1;
                continue;
            }
            if (pathToken.startsWith("Well")) {
                String wellId = pathToken.substring(pathToken.lastIndexOf("Well") + "Well".length(), pathToken.length());
                String[] elements = wellId.split("(?<=\\p{L})(?=\\d)");
                rows = ResourceNamer.alphabeticIndexCount(elements[0]);
                cols = Integer.parseInt(elements[1]) + 1;
                continue;
            }
            if (!pathToken.startsWith("Field")) continue;
            String fieldName = pathToken.substring(0, pathToken.indexOf("."));
            fields = Integer.parseInt(fieldName.substring(fieldName.lastIndexOf("Field") + "Field".length(), fieldName.length())) + 1;
        }
        tokens.add(path);
        tokens.add("plates=" + plates);
        tokens.add("plateRows=" + rows);
        tokens.add("plateCols=" + cols);
        tokens.add("fields=" + fields);
        tokens.add("plateAcqs=" + plateAcqs);
        return tokens.toArray(new String[tokens.size()]);
    }

    private boolean isSPWStructure(String path) {
        this.fakeSeries.clear();
        return !this.listFakeSeries(path).get(0).equals(path);
    }

    private int populateSPW(MetadataStore store, int screens, int plates, int rows, int cols, int fields, int acqs, boolean withMicrobeam) {
        XMLMockObjects xml = new XMLMockObjects();
        OME ome = null;
        ome = screens == 0 ? xml.createPopulatedPlate(plates, rows, cols, fields, acqs, withMicrobeam) : xml.createPopulatedScreen(screens, plates, rows, cols, fields, acqs, withMicrobeam);
        if (withMicrobeam) {
            this.roiCount += plates;
        }
        this.getOmeXmlMetadata().setRoot((MetadataRoot)new OMEXMLMetadataRoot(ome));
        this.getOmeXmlService().convertMetadata((MetadataRetrieve)this.omeXmlMetadata, store);
        this.domains = new String[]{"High-Content Screening (HCS)"};
        return ome.sizeOfImageList();
    }

    private void populateInstrument(MetadataStore store) {
        XMLMockObjects xml = new XMLMockObjects();
        OME ome = xml.getRoot();
        ome.addInstrument(xml.createInstrument(true));
        this.getOmeXmlMetadata().setRoot((MetadataRoot)new OMEXMLMetadataRoot(ome));
        this.getOmeXmlService().convertMetadata((MetadataRetrieve)this.omeXmlMetadata, store);
    }

    private void createIndexMap(int num) {
        int index;
        int c;
        int sizeC = ((CoreMetadata)this.core.get((int)0)).sizeC;
        this.indexToValue = new int[sizeC][num];
        for (c = 0; c < sizeC; ++c) {
            for (index = 0; index < num; ++index) {
                this.indexToValue[c][index] = index;
            }
            FakeReader.shuffle(c, this.indexToValue[c]);
        }
        this.valueToIndex = new int[sizeC][num];
        for (c = 0; c < sizeC; ++c) {
            index = 0;
            while (index < num) {
                int value = this.indexToValue[c][index];
                this.valueToIndex[c][value] = index++;
            }
        }
    }

    private List<String> listFakeSeries(String traversedDirectory) {
        File parent = new File(traversedDirectory);
        if (parent.isDirectory()) {
            Object[] children = parent.listFiles();
            Arrays.sort(children);
            if (children != null) {
                for (Object child : children) {
                    this.listFakeSeries(((File)child).getAbsolutePath());
                }
            }
        } else {
            String path = parent.getAbsolutePath();
            if (FakeReader.checkSuffix((String)path, (String)"fake") || FakeReader.checkSuffix((String)path, (String)"fake.ini")) {
                this.fakeSeries.add(path);
            }
        }
        return this.fakeSeries;
    }

    private static void shuffle(int c, int[] array) {
        Random r = new Random(-889275714L + (long)c);
        for (int i = array.length; i > 1; --i) {
            int j = r.nextInt(i);
            int tmp = array[j];
            array[j] = array[i - 1];
            array[i - 1] = tmp;
        }
    }

    private int parseColor(String value) {
        int base = 10;
        if (value.startsWith("0x") || value.startsWith("0X")) {
            value = value.substring(2);
            base = 16;
        }
        try {
            return (int)Long.parseLong(value, base);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Length parsePosition(String axis, int s, int index, IniTable table) {
        String position = (String)table.get((Object)("Position" + axis + "_" + index));
        String positionUnit = (String)table.get((Object)("Position" + axis + "Unit_" + index));
        if (position != null) {
            try {
                Double v = Double.valueOf(position);
                Length size = new Length((Number)v, UNITS.MICROMETER);
                if (positionUnit != null) {
                    try {
                        UnitsLength ul = UnitsLength.fromString((String)positionUnit);
                        size = UnitsLength.create((Number)v, (UnitsLength)ul);
                    }
                    catch (EnumerationException e) {
                        LOGGER.trace("Could not parse Position" + axis + "Unit for series #" + s + " plane #" + index, (Throwable)e);
                    }
                }
                return size;
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Could not parse Position" + axis + " for series #" + s + " plane #" + index, (Throwable)e);
            }
        }
        return null;
    }

    private Length parsePhysicalSize(String s, String defaultUnit) {
        Length physicalSize = FormatTools.parseLength((String)s, (String)defaultUnit);
        if (physicalSize == null) {
            throw new RuntimeException("Invalid physical size: " + s);
        }
        if (!FormatTools.isPositiveValue((Double)physicalSize.value().doubleValue())) {
            LOGGER.warn("Invalid physical size value: {}", (Object)physicalSize.value());
            return null;
        }
        return physicalSize;
    }

    private Length parseWavelength(String s, String defaultUnit) {
        Length wavelength = FormatTools.parseLength((String)s, (String)defaultUnit);
        if (wavelength == null) {
            throw new RuntimeException("Invalid wavelength: " + s);
        }
        if (!FormatTools.isPositiveValue((Double)wavelength.value().doubleValue())) {
            LOGGER.warn("Invalid wavelength value: {}", (Object)wavelength.value());
            return null;
        }
        return wavelength;
    }

    private static class TextLine {
        final String line;
        final Font font;
        final int xoff;
        final int ypad;

        TextLine(String line, Font font, int xoff, int ypad) {
            this.line = line;
            this.font = font;
            this.xoff = xoff;
            this.ypad = ypad;
        }
    }
}

