/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.util.HashMap;
import java.util.Map;
import omeis.providers.re.Renderer;
import omeis.providers.re.data.PlaneDef;

public class RenderingStats {
    private Renderer context;
    private PlaneDef plane;
    private long mallocTime;
    private Map<Integer, Long> ioTime;
    private long renderingTime;
    private long totalTime;

    private String getIoTimeString() {
        StringBuffer buf = new StringBuffer();
        long total = 0L;
        for (Integer key : this.ioTime.keySet()) {
            Long t = this.ioTime.get(key);
            total += t.longValue();
            buf.append("c=");
            buf.append(key);
            buf.append(";");
            buf.append(t);
            buf.append(" ");
        }
        return total + " -> " + buf.toString();
    }

    public RenderingStats(Renderer context, PlaneDef plane) {
        this.context = context;
        this.plane = plane;
        this.ioTime = new HashMap<Integer, Long>();
        this.totalTime = System.currentTimeMillis();
        this.mallocTime = 0L;
    }

    public void startMalloc() {
        this.mallocTime -= System.currentTimeMillis();
    }

    public void endMalloc() {
        this.mallocTime += System.currentTimeMillis();
    }

    public void startIO(int c) {
        this.ioTime.put(new Integer(c), new Long(System.currentTimeMillis()));
    }

    public void endIO(int c) {
        Integer channel = new Integer(c);
        long start = this.ioTime.get(channel);
        this.ioTime.put(channel, new Long(System.currentTimeMillis() - start));
    }

    public void startRendering() {
        this.renderingTime = System.currentTimeMillis();
    }

    public void endRendering() {
        this.renderingTime = System.currentTimeMillis() - this.renderingTime;
    }

    public void stop() {
        this.totalTime = System.currentTimeMillis() - this.totalTime;
    }

    public String getStats() {
        String a = "--------------- RENDERING STATS ---------------\n";
        a = a + String.format("CONTEXT ---- OMEIS Pixels ID: %d Plane: %s Type: %s PlaneData: %s Channels: %d Renderered Image: %s Color Model: %s\n", this.context.getMetadata().getId(), this.plane, this.context.getPlaneDimsAsString(this.plane), this.context.getPixelsType(), this.ioTime.keySet().size(), this.context.getImageSize(this.plane), this.context.getRenderingDef().getModel().getValue());
        a = a + String.format("TIMES (ms) ---- Memory Allocation: %d I/O: %s Rendering: %d Total: %d\n", this.mallocTime, this.getIoTimeString(), this.renderingTime, this.totalTime);
        a = a + "-----------------------------------------------";
        return a;
    }
}

