/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.EventHandler;
import IceInternal.EventHandlerOpPair;
import IceInternal.Instance;
import IceInternal.Selector;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolCurrent;
import IceInternal.ThreadPoolWorkItem;
import IceUtilInternal.Assert;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;
import java.util.List;

final class ThreadPoolWorkQueue
extends EventHandler {
    private final ThreadPool _threadPool;
    private boolean _destroyed;
    private Selector _selector;
    private EventHandlerOpPair _opPair = new EventHandlerOpPair(this, 1);
    private LinkedList<ThreadPoolWorkItem> _workItems = new LinkedList();

    ThreadPoolWorkQueue(Instance instance, ThreadPool threadPool, Selector selector) {
        this._threadPool = threadPool;
        this._selector = selector;
        this._destroyed = false;
        this._registered = 1;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._selector.wakeup();
    }

    synchronized void queue(ThreadPoolWorkItem item) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        assert (item != null);
        this._workItems.add(item);
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent current) {
        ThreadPoolWorkItem workItem = null;
        ThreadPoolWorkQueue threadPoolWorkQueue = this;
        synchronized (threadPoolWorkQueue) {
            if (!this._workItems.isEmpty()) {
                workItem = this._workItems.removeFirst();
                assert (workItem != null);
            } else {
                assert (this._destroyed);
                this._selector.wakeup();
            }
        }
        if (workItem == null) {
            this._threadPool.ioCompleted(current);
            throw new ThreadPool.DestroyedException();
        }
        workItem.execute(current);
    }

    @Override
    public void finished(ThreadPoolCurrent current, boolean close) {
        assert (false);
    }

    @Override
    public String toString() {
        return "work queue";
    }

    @Override
    public SelectableChannel fd() {
        return null;
    }

    synchronized int size() {
        int sz = this._workItems.size();
        if (this._destroyed) {
            ++sz;
        }
        return sz;
    }

    synchronized void update(List<EventHandlerOpPair> handlers) {
        for (int sz = this.size(); sz > 0; --sz) {
            handlers.add(this._opPair);
        }
    }
}

