/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr.compat;

import com.glencoesoftware.omero.zarr.compat.ZArray;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.v3.Array;
import dev.zarr.zarrjava.v3.DataType;
import java.io.IOException;
import java.nio.ByteBuffer;
import ucar.ma2.InvalidRangeException;

class ZArrayv3
implements ZArray {
    private Array array;

    public ZArrayv3(Array array) {
        this.array = array;
    }

    @Override
    public int[] getShape() {
        int[] shape = new int[this.array.metadata().shape.length];
        for (int i = 0; i < this.array.metadata().shape.length; ++i) {
            shape[i] = (int)this.array.metadata().shape[i];
        }
        return shape;
    }

    @Override
    public int[] getChunks() {
        int[] chunks = new int[this.array.metadata().chunkShape().length];
        for (int i = 0; i < this.array.metadata().chunkShape().length; ++i) {
            chunks[i] = this.array.metadata().chunkShape()[i];
        }
        return chunks;
    }

    @Override
    public void read(byte[] buffer, int[] shape, int[] offset) throws IOException, InvalidRangeException {
        try {
            long[] offsetLong = new long[offset.length];
            for (int i = 0; i < offset.length; ++i) {
                offsetLong[i] = offset[i];
            }
            ByteBuffer b = this.array.read(offsetLong, shape).getDataAsByteBuffer();
            System.arraycopy(b.array(), 0, buffer, 0, buffer.length);
        }
        catch (ZarrException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object read(int[] shape, int[] offset) throws IOException, InvalidRangeException {
        try {
            long[] offsetLong = new long[offset.length];
            for (int i = 0; i < offset.length; ++i) {
                offsetLong[i] = offset[i];
            }
            return this.array.read(offsetLong, shape).copyTo1DJavaArray();
        }
        catch (ZarrException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getPixelsType() {
        DataType dataType = this.array.metadata().dataType();
        switch (dataType) {
            case UINT8: {
                return 1;
            }
            case INT8: {
                return 0;
            }
            case UINT16: {
                return 3;
            }
            case INT16: {
                return 2;
            }
            case UINT32: {
                return 5;
            }
            case INT32: {
                return 4;
            }
            case FLOAT32: {
                return 6;
            }
            case FLOAT64: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Data type " + dataType + " not supported");
    }
}

