/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.dicom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.formats.dicom.DicomAttribute;
import loci.formats.dicom.DicomTag;
import loci.formats.dicom.DicomVR;
import loci.formats.dicom.ITagProvider;
import loci.formats.dicom.ResolutionStrategy;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomJSONProvider
implements ITagProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DicomJSONProvider.class);
    private List<DicomTag> tags = new ArrayList<DicomTag>();

    @Override
    public void readTagSource(String location) throws IOException {
        String rawJSON = DataTools.readFile((String)location);
        try {
            JSONObject root = new JSONObject(rawJSON);
            for (String tagKey : root.keySet()) {
                ResolutionStrategy rs;
                JSONObject tag = root.getJSONObject(tagKey);
                String value = tag.has("Value") ? tag.getString("Value") : null;
                Integer intTagCode = this.lookupTag(tagKey, tag);
                DicomVR vrEnum = this.lookupVR(intTagCode, tag);
                DicomTag dicomTag = new DicomTag(intTagCode, vrEnum);
                dicomTag.value = value;
                LOGGER.debug("Adding tag: {}, VR: {}, value: {}", new Object[]{DicomAttribute.formatTag(intTagCode), vrEnum, value});
                dicomTag.validateValue();
                if (vrEnum == DicomVR.SQ && tag.has("Sequence")) {
                    this.readSequence(tag, dicomTag);
                }
                ResolutionStrategy resolutionStrategy = rs = vrEnum == DicomVR.SQ ? ResolutionStrategy.APPEND : ResolutionStrategy.REPLACE;
                if (tag.has("ResolutionStrategy")) {
                    String strategy = tag.getString("ResolutionStrategy");
                    rs = Enum.valueOf(ResolutionStrategy.class, strategy);
                }
                dicomTag.strategy = rs;
                this.tags.add(dicomTag);
            }
        }
        catch (JSONException e) {
            throw new IOException("Could not parse JSON", e);
        }
    }

    @Override
    public List<DicomTag> getTags() {
        return this.tags;
    }

    private void readSequence(JSONObject rootTag, DicomTag parent) {
        JSONObject sequence = rootTag.getJSONObject("Sequence");
        for (String key : sequence.keySet()) {
            JSONObject tag = sequence.getJSONObject(key);
            Integer intTagCode = this.lookupTag(key, tag);
            DicomVR vrEnum = this.lookupVR(intTagCode, tag);
            DicomTag dicomTag = new DicomTag(intTagCode, vrEnum);
            if (tag.has("Value")) {
                dicomTag.value = tag.get("Value");
            }
            LOGGER.debug("Adding tag: {}, VR: {}, value: {}", new Object[]{intTagCode, vrEnum, dicomTag.value});
            dicomTag.validateValue();
            dicomTag.parent = parent;
            parent.children.add(dicomTag);
            if (vrEnum != DicomVR.SQ || tag.get("Sequence") == null) continue;
            this.readSequence(tag, dicomTag);
        }
        parent.children.sort(null);
    }

    private Integer lookupTag(String tagKey, JSONObject tag) {
        Integer intTagCode = null;
        if (tag.has("Tag")) {
            String[] tagCode = tag.getString("Tag").replaceAll("[()]", "").split(",");
            int tagUpper = Integer.parseInt(tagCode[0], 16);
            int tagLower = Integer.parseInt(tagCode[1], 16);
            intTagCode = tagUpper << 16 | tagLower;
        } else {
            intTagCode = DicomAttribute.getTag(tagKey);
            if (intTagCode == null) {
                throw new IllegalArgumentException("Tag not defined and could not be determined from description '" + tagKey + "'");
            }
        }
        return intTagCode;
    }

    private DicomVR lookupVR(Integer intTagCode, JSONObject tag) {
        DicomVR userEnum;
        DicomVR vrEnum = DicomAttribute.getDefaultVR(intTagCode);
        if (tag.has("VR") && !vrEnum.equals((Object)(userEnum = DicomVR.valueOf(DicomVR.class, tag.getString("VR"))))) {
            LOGGER.warn("User-defined VR ({}) for {} does not match expected VR ({})", new Object[]{userEnum, DicomAttribute.formatTag(intTagCode), vrEnum});
            if (userEnum != null) {
                vrEnum = userEnum;
            }
        }
        return vrEnum;
    }
}

