/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MinMaxCalculator;
import loci.formats.in.FakeReader;
import loci.formats.meta.IMinMaxStore;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MinMaxCalculatorTest {
    private static final String TEST_FILE = "test&pixelType=int8&sizeX=20&sizeY=20&sizeC=1&sizeZ=1&sizeT=1.fake";
    private MinMaxCalculatorTestReader reader;
    private MinMaxCalculator minMaxCalculator;
    private TestMinMaxStore minMaxStore;
    private static int fullPlaneCallIndex;
    private int sizeX;
    private int sizeY;
    private int bpp;
    private int planeSize;

    @BeforeMethod
    public void setUp() throws Exception {
        fullPlaneCallIndex = 1;
        Location.mapId((String)TEST_FILE, (String)TEST_FILE);
        this.reader = new MinMaxCalculatorTestReader();
        this.reader.setId(TEST_FILE);
        this.minMaxStore = new TestMinMaxStore();
        this.minMaxCalculator = new MinMaxCalculator((IFormatReader)this.reader);
        this.minMaxCalculator.setMinMaxStore((IMinMaxStore)this.minMaxStore);
        this.sizeX = this.reader.getSizeX();
        this.sizeY = this.reader.getSizeY();
        this.bpp = FormatTools.getBytesPerPixel((int)this.reader.getPixelType());
        this.planeSize = this.sizeY * this.sizeY * this.bpp;
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.minMaxCalculator.close();
        this.reader.close();
    }

    private void assertMinMax(double minimum, double maximum) throws Exception {
        Double[] min = this.minMaxCalculator.getPlaneMinimum(0);
        Double[] max = this.minMaxCalculator.getPlaneMaximum(0);
        Double globalMin = this.minMaxCalculator.getChannelGlobalMinimum(0);
        Double globalMax = this.minMaxCalculator.getChannelGlobalMaximum(0);
        Double knownGlobalMin = this.minMaxCalculator.getChannelKnownMinimum(0);
        Double knownGlobalMax = this.minMaxCalculator.getChannelKnownMaximum(0);
        AssertJUnit.assertTrue((boolean)this.minMaxCalculator.isMinMaxPopulated());
        AssertJUnit.assertNotNull((Object)min);
        AssertJUnit.assertNotNull((Object)max);
        AssertJUnit.assertNotNull((Object)globalMin);
        AssertJUnit.assertNotNull((Object)globalMax);
        AssertJUnit.assertNotNull((Object)knownGlobalMin);
        AssertJUnit.assertNotNull((Object)knownGlobalMax);
        AssertJUnit.assertEquals((int)1, (int)min.length);
        AssertJUnit.assertEquals((int)1, (int)max.length);
        AssertJUnit.assertEquals((Object)minimum, (Object)min[0]);
        AssertJUnit.assertEquals((Object)maximum, (Object)max[0]);
        AssertJUnit.assertEquals((Object)minimum, (Object)globalMin);
        AssertJUnit.assertEquals((Object)maximum, (Object)globalMax);
        AssertJUnit.assertEquals((Object)minimum, (Object)knownGlobalMin);
        AssertJUnit.assertEquals((Object)maximum, (Object)knownGlobalMax);
        List<List<double[]>> seriesGlobalMinimaMaxima = this.minMaxStore.seriesGlobalMinimaMaxima;
        AssertJUnit.assertEquals((int)(this.minMaxCalculator.getCoreIndex() + 1), (int)seriesGlobalMinimaMaxima.size());
        List<double[]> channelGlobalMinimaMaxima = seriesGlobalMinimaMaxima.get(0);
        AssertJUnit.assertEquals((int)1, (int)channelGlobalMinimaMaxima.size());
        double[] channelGlobalMinMax = channelGlobalMinimaMaxima.get(0);
        channelGlobalMinMax[0] = minimum;
        channelGlobalMinMax[1] = maximum;
    }

    @Test
    public void testValidOpenBytes() throws Exception {
        byte[] a = new byte[this.planeSize / 2];
        byte[] b = new byte[this.planeSize / 2];
        int halfway = this.sizeY / 2;
        this.reader.openBytes(0, a, 0, 0, this.sizeX, halfway);
        this.reader.openBytes(0, b, 0, halfway, this.sizeX, halfway);
        AssertJUnit.assertEquals((int)-1, (int)a[this.sizeX / 2]);
        AssertJUnit.assertEquals((int)1, (int)a[this.sizeX / 2 + 1]);
        AssertJUnit.assertEquals((int)-2, (int)b[this.sizeX / 2]);
        AssertJUnit.assertEquals((int)2, (int)b[this.sizeX / 2 + 1]);
    }

    @Test
    public void testValidMinMax() throws Exception {
        this.minMaxCalculator.openBytes(0);
        this.assertMinMax(-2.0, 101.0);
    }

    @Test
    public void testValidMinMaxNoOutOfBufferInspection() throws Exception {
        byte[] buf = new byte[this.planeSize * 2];
        buf[buf.length - 1] = 120;
        this.minMaxCalculator.openBytes(0, buf, 0, 0, this.sizeX, this.sizeY);
        this.assertMinMax(-2.0, 101.0);
    }

    @Test
    public void testValidMinMaxDoesntRecalculateOnFullPlane() throws Exception {
        this.minMaxCalculator.openBytes(0);
        this.minMaxCalculator.openBytes(0);
        this.assertMinMax(-2.0, 101.0);
    }

    @Test
    public void testValidMinMaxFirstHalf() throws Exception {
        byte[] buf = new byte[this.planeSize / 2];
        int halfway = this.sizeY / 2;
        this.minMaxCalculator.openBytes(0, buf, 0, 0, this.sizeX, halfway);
        this.assertMinMax(-1.0, 1.0);
    }

    @Test
    public void testValidMinMaxSecondHalf() throws Exception {
        byte[] buf = new byte[this.planeSize / 2];
        int halfway = this.sizeY / 2;
        this.minMaxCalculator.openBytes(0, buf, 0, halfway, this.sizeX, halfway);
        this.assertMinMax(-2.0, 2.0);
    }

    @Test
    public void testValidMinMaxBothHalvesLowerFirst() throws Exception {
        byte[] buf = new byte[this.planeSize / 2];
        int halfway = this.sizeY / 2;
        this.minMaxCalculator.openBytes(0, buf, 0, 0, this.sizeX, halfway);
        this.minMaxCalculator.openBytes(0, buf, 0, halfway, this.sizeX, halfway);
        this.assertMinMax(-2.0, 2.0);
    }

    @Test
    public void testValidMinMaxBothHalvesUpperFirst() throws Exception {
        byte[] buf = new byte[this.planeSize / 2];
        int halfway = this.sizeY / 2;
        this.minMaxCalculator.openBytes(0, buf, 0, halfway, this.sizeX, halfway);
        this.minMaxCalculator.openBytes(0, buf, 0, 0, this.sizeX, halfway);
        this.assertMinMax(-2.0, 2.0);
    }

    @Test
    public void testMultipleResolutions() throws Exception {
        this.minMaxCalculator.setCoreIndex(0);
        this.minMaxCalculator.openBytes(0);
        this.assertMinMax(-2.0, 101.0);
        this.minMaxCalculator.setCoreIndex(1);
        this.minMaxCalculator.openBytes(0);
        this.assertMinMax(-1.0, 102.0);
        try (MinMaxCalculator unflattened = new MinMaxCalculator((IFormatReader)new MinMaxCalculatorTestReader());){
            unflattened.setFlattenedResolutions(false);
            unflattened.setId(TEST_FILE);
            unflattened.setCoreIndex(0);
            unflattened.openBytes(0);
            AssertJUnit.assertEquals((Object)-2.0, (Object)unflattened.getPlaneMinimum(0)[0]);
            AssertJUnit.assertEquals((Object)103.0, (Object)unflattened.getPlaneMaximum(0)[0]);
            unflattened.setCoreIndex(1);
            unflattened.openBytes(0);
            AssertJUnit.assertEquals((Object)-1.0, (Object)unflattened.getPlaneMinimum(0)[0]);
            AssertJUnit.assertEquals((Object)104.0, (Object)unflattened.getPlaneMaximum(0)[0]);
        }
    }

    class MinMaxCalculatorTestReader
    extends FakeReader {
        MinMaxCalculatorTestReader() {
        }

        public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
            FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
            int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
            int sizeX = this.getSizeX();
            int sizeY = this.getSizeY();
            int planeSize = sizeX * sizeY * bpp;
            if (x != 0) {
                throw new FormatException("x != 0 not supported by this test!");
            }
            if (w != sizeX) {
                throw new FormatException("Width != sizeX not supported by this test!");
            }
            for (int i = 0; i < h; ++i) {
                int from = i * sizeX * bpp;
                int to = (i * sizeX + sizeX - 1) * bpp;
                Arrays.fill(buf, from, to, (byte)0);
                if (i + y == 0) {
                    buf[sizeX / 2 * bpp] = -1;
                    buf[(sizeX / 2 + 1) * bpp] = 1;
                }
                if (i + y != 10) continue;
                buf[sizeX / 2 * bpp] = -2;
                buf[(sizeX / 2 + 1) * bpp] = 2;
            }
            if (buf.length >= planeSize) {
                buf[planeSize - 1] = (byte)(100 + fullPlaneCallIndex);
                fullPlaneCallIndex++;
            }
            return buf;
        }

        public void setId(String id) throws FormatException, IOException {
            super.setId(id);
            this.core.add(new CoreMetadata((CoreMetadata)this.core.get(0)));
            ++((CoreMetadata)this.core.get((int)0)).resolutionCount;
            ((CoreMetadata)this.core.get((int)1)).sizeX /= 2;
            ((CoreMetadata)this.core.get((int)1)).sizeY /= 2;
        }
    }

    class TestMinMaxStore
    implements IMinMaxStore {
        public List<List<double[]>> seriesGlobalMinimaMaxima = new ArrayList<List<double[]>>();

        TestMinMaxStore() {
        }

        public void setChannelGlobalMinMax(int channel, double minimum, double maximum, int series) {
            List<double[]> channelGlobalMinimaMaxima;
            if (this.seriesGlobalMinimaMaxima.size() == series) {
                this.seriesGlobalMinimaMaxima.add(new ArrayList());
            }
            if ((channelGlobalMinimaMaxima = this.seriesGlobalMinimaMaxima.get(series)).size() == channel) {
                channelGlobalMinimaMaxima.add(new double[2]);
            }
            double[] channelGlobalMinMax = channelGlobalMinimaMaxima.get(channel);
            channelGlobalMinMax[0] = minimum;
            channelGlobalMinMax[1] = maximum;
        }
    }
}

