/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import loci.formats.cache.Cache;
import loci.formats.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUpdater
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheUpdater.class);
    private Cache cache;
    private boolean quit;

    public CacheUpdater(Cache cache) {
        super("Bio-Formats-Cache-Updater");
        this.setPriority(1);
        this.cache = cache;
        this.quit = false;
    }

    public void quit() {
        this.quit = true;
        try {
            this.join();
        }
        catch (InterruptedException exc) {
            LOGGER.info("Thread interrupted", (Throwable)exc);
        }
    }

    @Override
    public void run() {
        int length = 0;
        try {
            length = this.cache.getStrategy().getLoadList(this.cache.getCurrentPos()).length;
            for (int i = 0; i < length && !this.quit; ++i) {
                this.cache.recache(i);
            }
        }
        catch (CacheException e) {
            LOGGER.info("", (Throwable)((Object)e));
        }
    }
}

