/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model.enums;

import ome.xml.model.enums.handlers.UnitsTimeEnumHandler;
import ome.xml.model.primitives.*;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.units.UNITS;

@SuppressWarnings("SpellCheckingInspection")
public enum UnitsTime implements Enumeration
{
  /** yottasecond SI unit. */
  YOTTASECOND("Ys"),
  /** zettasecond SI unit. */
  ZETTASECOND("Zs"),
  /** exasecond SI unit. */
  EXASECOND("Es"),
  /** petasecond SI unit. */
  PETASECOND("Ps"),
  /** terasecond SI unit. */
  TERASECOND("Ts"),
  /** gigasecond SI unit. */
  GIGASECOND("Gs"),
  /** megasecond SI unit. */
  MEGASECOND("Ms"),
  /** kilosecond SI unit. */
  KILOSECOND("ks"),
  /** hectosecond SI unit. */
  HECTOSECOND("hs"),
  /** decasecond SI unit. */
  DECASECOND("das"),
  /** second SI unit. */
  SECOND("s"),
  /** decisecond SI unit. */
  DECISECOND("ds"),
  /** centisecond SI unit. */
  CENTISECOND("cs"),
  /** millisecond SI unit. */
  MILLISECOND("ms"),
  /** microsecond SI unit. */
  MICROSECOND("µs"),
  /** nanosecond SI unit. */
  NANOSECOND("ns"),
  /** picosecond SI unit. */
  PICOSECOND("ps"),
  /** femtosecond SI unit. */
  FEMTOSECOND("fs"),
  /** attosecond SI unit. */
  ATTOSECOND("as"),
  /** zeptosecond SI unit. */
  ZEPTOSECOND("zs"),
  /** yoctosecond SI unit. */
  YOCTOSECOND("ys"),
  /** minute SI-derived unit. */
  MINUTE("min"),
  /** hour SI-derived unit. */
  HOUR("h"),
  /** day SI-derived unit. */
  DAY("d");

  UnitsTime(String value)
  {
    this.value = value;
  }

  public static UnitsTime fromString(String value)
    throws EnumerationException
  {
    if ("Ys".equals(value))
    {
      return YOTTASECOND;
    }
    if ("Zs".equals(value))
    {
      return ZETTASECOND;
    }
    if ("Es".equals(value))
    {
      return EXASECOND;
    }
    if ("Ps".equals(value))
    {
      return PETASECOND;
    }
    if ("Ts".equals(value))
    {
      return TERASECOND;
    }
    if ("Gs".equals(value))
    {
      return GIGASECOND;
    }
    if ("Ms".equals(value))
    {
      return MEGASECOND;
    }
    if ("ks".equals(value))
    {
      return KILOSECOND;
    }
    if ("hs".equals(value))
    {
      return HECTOSECOND;
    }
    if ("das".equals(value))
    {
      return DECASECOND;
    }
    if ("s".equals(value))
    {
      return SECOND;
    }
    if ("ds".equals(value))
    {
      return DECISECOND;
    }
    if ("cs".equals(value))
    {
      return CENTISECOND;
    }
    if ("ms".equals(value))
    {
      return MILLISECOND;
    }
    if ("µs".equals(value))
    {
      return MICROSECOND;
    }
    if ("ns".equals(value))
    {
      return NANOSECOND;
    }
    if ("ps".equals(value))
    {
      return PICOSECOND;
    }
    if ("fs".equals(value))
    {
      return FEMTOSECOND;
    }
    if ("as".equals(value))
    {
      return ATTOSECOND;
    }
    if ("zs".equals(value))
    {
      return ZEPTOSECOND;
    }
    if ("ys".equals(value))
    {
      return YOCTOSECOND;
    }
    if ("min".equals(value))
    {
      return MINUTE;
    }
    if ("h".equals(value))
    {
      return HOUR;
    }
    if ("d".equals(value))
    {
      return DAY;
    }

    String s = String.format("'%s' not a supported value of '%s'",
                             value, UnitsTime.class);
    throw new EnumerationException(s);
  }

  @SuppressWarnings("unused")
  public String getValue()
  {
    return value;
  }

  @Override
  public String toString()
  {
    return value;
  }

  public static <T extends PrimitiveNumber> Time create(T newValue, UnitsTime newUnit)
  {
    Time theQuantity = null;

    try
    {
      theQuantity = UnitsTimeEnumHandler.getQuantity(newValue, newUnit);
    }
    catch (EnumerationException ignored)
    {
    }

    return theQuantity;
  }

  public static <T extends Number> Time create(T newValue, UnitsTime newUnit)
  {
    Time theQuantity = null;

    try
    {
      theQuantity = UnitsTimeEnumHandler.getQuantity(newValue, newUnit);
    }
    catch (EnumerationException ignored)
    {
    }

    return theQuantity;
  }

  private final String value;
}
